/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import javax.management.ObjectName;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanInterceptor;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.ConstrainedBeanListener;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.WriteableView;

public class ConfigBean
extends Dom
implements ConfigView {
    private static final int WAIT_ITERATIONS = Integer.getInteger("org.glassfish.hk2.config.locktimeout.iterations", 100);
    private WriteableView writeableView;
    private volatile boolean writeLock = false;
    private final Map<Class, ConfigBeanInterceptor> optionalFeatures = new HashMap<Class, ConfigBeanInterceptor>();
    private volatile ObjectName objectName = null;
    private final Lock lock = new Lock(){

        @Override
        public void lock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized boolean tryLock() {
            if (!ConfigBean.this.writeLock) {
                ConfigBean.this.writeLock = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            long nanosTimeout = TimeUnit.NANOSECONDS.convert(time, unit);
            long increment = nanosTimeout / (long)WAIT_ITERATIONS;
            long lastTime = System.nanoTime();
            do {
                if (this.tryLock()) {
                    return true;
                }
                if (nanosTimeout < 0L) {
                    return false;
                }
                LockSupport.parkNanos(increment);
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }

        @Override
        public synchronized void unlock() {
            ConfigBean.this.writeLock = false;
            ConfigBean.this.writeableView = null;
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    };

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectNameIn) {
        if (this.objectName != null) {
            throw new IllegalStateException();
        }
        this.objectName = objectNameIn;
    }

    public ConfigBean(ServiceLocator habitat, DomDocument document, ConfigBean parent, ConfigModel model, XMLStreamReader in) {
        super(habitat, document, parent, model, in);
        this.addInterceptor(ConstrainedBeanListener.class, new ConfigBeanInterceptor<ConstrainedBeanListener>(){
            List<VetoableChangeListener> listeners = new ArrayList<VetoableChangeListener>();

            @Override
            public ConstrainedBeanListener getConfiguration() {
                return new ConstrainedBeanListener(){

                    @Override
                    public void removeVetoableChangeListener(VetoableChangeListener listener) {
                        listeners.remove(listener);
                    }

                    @Override
                    public void addVetoableChangeListener(VetoableChangeListener listener) {
                        listeners.add(listener);
                    }
                };
            }

            @Override
            public void beforeChange(PropertyChangeEvent evt) throws PropertyVetoException {
                for (VetoableChangeListener listener : this.listeners) {
                    listener.vetoableChange(evt);
                }
            }

            @Override
            public void afterChange(PropertyChangeEvent evt, long timestamp) {
            }

            @Override
            public void readValue(ConfigBean source, String xmlName, Object Value2) {
            }
        });
    }

    public ConfigBean(Dom source, Dom parent) {
        super(source, parent);
    }

    @Override
    protected <T extends Dom> T copy(T parent) {
        return (T)new ConfigBean(this, parent);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && ((ConfigBean)o).objectName == this.objectName;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public <T> T getOptionalFeature(Class<T> featureType) {
        if (this.optionalFeatures.containsKey(featureType)) {
            return this.optionalFeatures.get(featureType).getConfiguration();
        }
        return null;
    }

    Collection<ConfigBeanInterceptor> getOptionalFeatures() {
        return this.optionalFeatures.values();
    }

    @Override
    protected void setter(ConfigModel.Property target, Object value) throws Exception {
        if (!this.writeLock) {
            throw new PropertyVetoException("Instance of " + this.getImplementation() + " named '" + this.getKey() + "' is not locked for writing when changing attribute " + target.xmlName() + ", you must use transaction semantics to access it.", null);
        }
        this._setter(target, value);
    }

    void _setter(ConfigModel.Property target, Object value) throws Exception {
        Object oldValue = super.getter(target, value.getClass());
        PropertyChangeEvent evt = new PropertyChangeEvent(this, target.xmlName(), oldValue, value);
        for (ConfigBeanInterceptor interceptor : this.optionalFeatures.values()) {
            interceptor.beforeChange(evt);
        }
        super.setter(target, value);
        for (ConfigBeanInterceptor interceptor : this.optionalFeatures.values()) {
            interceptor.afterChange(evt, System.currentTimeMillis());
        }
    }

    Object _getter(ConfigModel.Property target, Type t) {
        Object value = super.getter(target, t);
        for (ConfigBeanInterceptor interceptor : this.optionalFeatures.values()) {
            interceptor.readValue(this, target.xmlName(), value);
        }
        return value;
    }

    @Override
    protected Object getter(ConfigModel.Property target, Type t) {
        Object value = this._getter(target, t);
        if (value instanceof List) {
            final List valueList = (List)value;
            return new AbstractList(){

                @Override
                public int size() {
                    return valueList.size();
                }

                @Override
                public Object get(int index) {
                    return valueList.get(index);
                }

                @Override
                public boolean add(Object o) {
                    throw new IllegalStateException("Not part of a transaction !", null);
                }

                @Override
                public Object set(int index, Object element) {
                    throw new IllegalStateException("Not part of a transaction !", null);
                }

                @Override
                public Object remove(int index) {
                    throw new IllegalStateException("Not part of a transaction !", null);
                }
            };
        }
        return value;
    }

    public void addInterceptor(Class<?> interceptorType, ConfigBeanInterceptor interceptor) {
        this.optionalFeatures.put(interceptorType, interceptor);
    }

    @Override
    public ConfigBean getMasterView() {
        return this;
    }

    @Override
    public void setMasterView(ConfigView view) {
    }

    @Override
    public <T extends ConfigBeanProxy> T getProxy(final Class<T> proxyType) {
        ClassLoader cl = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return proxyType.getClassLoader();
            }
        }) : proxyType.getClassLoader();
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(cl, new Class[]{proxyType}, (InvocationHandler)this)));
    }

    public ConfigBean allocate(Class<?> type2) {
        return (ConfigBean)this.document.make(this.getHabitat(), null, this, this.document.buildModel(type2));
    }

    <T extends ConfigBeanProxy> T allocateProxy(Class<T> type2) {
        return this.allocate(type2).createProxy(type2);
    }

    public Lock getLock() {
        return this.lock;
    }

    @Override
    public ConfigBean parent() {
        return (ConfigBean)super.parent();
    }

    void setWriteableView(WriteableView writeableView) {
        if (!this.writeLock) {
            throw new IllegalStateException("Config bean is not locked");
        }
        this.writeableView = writeableView;
    }

    WriteableView getWriteableView() {
        return this.writeableView;
    }
}

