/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.ejb;

import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchEJBException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.helpers.ForwardingEjbDescriptor;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.SerializationLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.ejb.InternalEjbDescriptor;
import org.jboss.weld.module.ejb.SessionBeanImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.jboss.weld.util.reflection.Reflections;

class EnterpriseBeanProxyMethodHandler<T>
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 2107723373882153667L;
    private final BeanManagerImpl manager;
    private final BeanIdentifier beanId;
    private final SessionObjectReference reference;
    private final transient SessionBeanImpl<T> bean;
    private final transient Map<Class<?>, Class<?>> typeToBusinessInterfaceMap;

    EnterpriseBeanProxyMethodHandler(SessionBeanImpl<T> bean) {
        this(bean, null);
    }

    private EnterpriseBeanProxyMethodHandler(SessionBeanImpl<T> bean, SessionObjectReference reference) {
        this.bean = bean;
        this.manager = bean.getBeanManager();
        this.beanId = bean.getIdentifier();
        HashMap typeToBusinessInterfaceMap = new HashMap();
        this.discoverBusinessInterfaces(typeToBusinessInterfaceMap, ((InternalEjbDescriptor)bean.getEjbDescriptor()).getRemoteBusinessInterfacesAsClasses());
        this.discoverBusinessInterfaces(typeToBusinessInterfaceMap, ((InternalEjbDescriptor)bean.getEjbDescriptor()).getLocalBusinessInterfacesAsClasses());
        this.typeToBusinessInterfaceMap = ImmutableMap.copyOf(typeToBusinessInterfaceMap);
        if (reference == null) {
            this.reference = bean.createReference();
            BeanLogger.LOG.createdSessionBeanProxy(bean);
        } else {
            this.reference = reference;
            BeanLogger.LOG.activatedSessionBeanProxy(bean);
        }
    }

    @Override
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        if ("destroy".equals(method.getName()) && Marker.isMarker(0, method, args)) {
            if (((ForwardingEjbDescriptor)this.bean.getEjbDescriptor()).isStateful() && !this.reference.isRemoved()) {
                this.reference.remove();
            }
            return null;
        }
        if (!this.bean.isClientCanCallRemoveMethods() && this.isRemoveMethod(method)) {
            throw BeanLogger.LOG.invalidRemoveMethodInvocation(method);
        }
        Class<?> businessInterface = this.getBusinessInterface(method);
        Object proxiedInstance = this.reference.getBusinessObject(businessInterface);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new EJBException("Not a business method " + method.toString() + ". Do not call non-public methods on EJB's.");
        }
        try {
            Object returnValue = Reflections.invokeAndUnwrap(proxiedInstance, method, args);
            BeanLogger.LOG.callProxiedMethod(method, proxiedInstance, args, returnValue);
            return returnValue;
        }
        catch (NoSuchEJBException e) {
            if (this.isToStringMethod(method)) {
                return businessInterface.getName() + " [REMOVED]";
            }
            throw e;
        }
    }

    private boolean isRemoveMethod(Method method) {
        MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
        return ((InternalEjbDescriptor)this.bean.getEjbDescriptor()).getRemoveMethodSignatures().contains(methodSignature);
    }

    private boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && method.getParameterCount() == 0;
    }

    private Class<?> getBusinessInterface(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> businessInterface = null;
        businessInterface = declaringClass.equals(Object.class) ? ((InternalEjbDescriptor)this.bean.getEjbDescriptor()).getObjectInterface() : this.typeToBusinessInterfaceMap.get(declaringClass);
        if (businessInterface == null) {
            throw new RuntimeException("Unable to locate a business interface declaring " + method);
        }
        return businessInterface;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return new EnterpriseBeanProxyMethodHandler<T>((SessionBeanImpl)this.manager.getPassivationCapableBean(this.beanId), this.reference);
        }
        catch (Exception e) {
            throw SerializationLogger.LOG.unableToDeserialize(this.beanId, e);
        }
    }

    private void discoverBusinessInterfaces(Map<Class<?>, Class<?>> typeToBusinessInterfaceMap, Set<Class<?>> businessInterfaces) {
        for (Class<?> businessInterfaceClass : businessInterfaces) {
            for (Class<?> type2 : HierarchyDiscovery.forNormalizedType(businessInterfaceClass).getTypeMap().keySet()) {
                typeToBusinessInterfaceMap.put(type2, businessInterfaceClass);
            }
        }
    }
}

