/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator.util.reflection;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

final class WildcardTypeImpl
implements WildcardType {
    private static final Type[] NO_UPPER_BOUND = new Type[]{Object.class};
    private static final Type[] NO_LOWER_BOUND = new Type[0];
    private static final WildcardType UNBOUNDED = new WildcardTypeImpl(NO_UPPER_BOUND, NO_LOWER_BOUND);
    private final Type[] upperBounds;
    private final Type[] lowerBounds;

    static WildcardType unbounded() {
        return UNBOUNDED;
    }

    static WildcardType withUpperBound(Type type2) {
        return new WildcardTypeImpl(new Type[]{type2}, NO_LOWER_BOUND);
    }

    static WildcardType withLowerBound(Type type2) {
        return new WildcardTypeImpl(NO_UPPER_BOUND, new Type[]{type2});
    }

    private WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
    }

    @Override
    public Type[] getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public Type[] getLowerBounds() {
        return this.lowerBounds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof WildcardType) {
            WildcardType that = (WildcardType)o;
            return Arrays.equals(this.upperBounds, that.getUpperBounds()) && Arrays.equals(this.lowerBounds, that.getLowerBounds());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
    }

    public String toString() {
        boolean noUpperBound = Arrays.equals(this.upperBounds, NO_UPPER_BOUND);
        boolean noLowerBound = Arrays.equals(this.lowerBounds, NO_LOWER_BOUND);
        if (noUpperBound && noLowerBound) {
            return "?";
        }
        if (noUpperBound) {
            return "? super " + this.lowerBounds[0];
        }
        String returnString = "? extends " + this.upperBounds[0];
        if (noLowerBound) {
            return returnString;
        }
        return returnString + " super " + this.lowerBounds[0];
    }
}

