/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.enterprise.inject.spi.ProcessSyntheticObserverMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.weld.lite.extension.translator.BeanInfoImpl;
import org.jboss.weld.lite.extension.translator.ExtensionInvoker;
import org.jboss.weld.lite.extension.translator.ExtensionMethodParameterType;
import org.jboss.weld.lite.extension.translator.ExtensionPhase;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseBase;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseRegistrationAction;
import org.jboss.weld.lite.extension.translator.InterceptorInfoImpl;
import org.jboss.weld.lite.extension.translator.ObserverInfoImpl;
import org.jboss.weld.lite.extension.translator.SharedErrors;
import org.jboss.weld.lite.extension.translator.TypesImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;

class ExtensionPhaseRegistration
extends ExtensionPhaseBase {
    private final List<ExtensionPhaseRegistrationAction> actions;

    ExtensionPhaseRegistration(BeanManager beanManager, ExtensionInvoker util, SharedErrors errors, List<ExtensionPhaseRegistrationAction> actions2) {
        super(ExtensionPhase.REGISTRATION, beanManager, util, errors);
        this.actions = actions2;
    }

    @Override
    void runExtensionMethod(Method method) {
        Registration registration;
        Consumer<ProcessBean<?>> pbAcceptor;
        int numParameters = method.getParameterCount();
        int numQueryParameters = 0;
        ArrayList<ExtensionMethodParameterType> parameters = new ArrayList<ExtensionMethodParameterType>(numParameters);
        for (int i = 0; i < numParameters; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            ExtensionMethodParameterType parameter = ExtensionMethodParameterType.of(parameterType);
            parameters.add(parameter);
            if (parameter.isQuery()) {
                ++numQueryParameters;
            }
            parameter.verifyAvailable(ExtensionPhase.REGISTRATION, method);
        }
        if (numQueryParameters == 0 || numQueryParameters > 1) {
            throw LiteExtensionTranslatorLogger.LOG.incorrectParameterCount("BeanInfo or ObserverInfo", method, method.getDeclaringClass());
        }
        ExtensionMethodParameterType query = parameters.stream().filter(ExtensionMethodParameterType::isQuery).findAny().get();
        if (query == ExtensionMethodParameterType.BEAN_INFO) {
            pbAcceptor = pb -> {
                ArrayList<Object> arguments = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    Object argument;
                    if (parameter.isQuery()) {
                        AnnotatedParameter disposer = null;
                        if (pb instanceof ProcessProducerField) {
                            disposer = ((ProcessProducerField)pb).getAnnotatedDisposedParameter();
                        } else if (pb instanceof ProcessProducerMethod) {
                            disposer = ((ProcessProducerMethod)pb).getAnnotatedDisposedParameter();
                        }
                        argument = new BeanInfoImpl(pb.getBean(), pb.getAnnotated(), disposer, this.beanManager);
                    } else {
                        argument = this.argumentForExtensionMethod(parameter, method);
                    }
                    arguments.add(argument);
                }
                try {
                    this.util.callExtensionMethod(method, arguments);
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, arguments, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, arguments, e.toString(), e);
                }
            };
            registration = method.getAnnotation(Registration.class);
            this.actions.add(new ExtensionPhaseRegistrationAction(new HashSet(Arrays.asList(registration.types())), pbAcceptor, null));
        } else if (query == ExtensionMethodParameterType.INTERCEPTOR_INFO) {
            pbAcceptor = pb -> {
                if (!(pb.getBean() instanceof Interceptor)) {
                    return;
                }
                Interceptor cdiInterceptor = (Interceptor)pb.getBean();
                ArrayList<Object> arguments = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    Object argument = parameter.isQuery() ? new InterceptorInfoImpl(cdiInterceptor, pb.getAnnotated(), this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                    arguments.add(argument);
                }
                try {
                    this.util.callExtensionMethod(method, arguments);
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, arguments, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, arguments, e.toString(), e);
                }
            };
            registration = method.getAnnotation(Registration.class);
            this.actions.add(new ExtensionPhaseRegistrationAction(new HashSet(Arrays.asList(registration.types())), pbAcceptor, null));
        } else if (query == ExtensionMethodParameterType.OBSERVER_INFO) {
            Consumer<ProcessObserverMethod<?, ?>> pomAcceptor = pom -> {
                ArrayList<Object> arguments = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    Object argument;
                    if (parameter.isQuery()) {
                        boolean isSynthetic = pom instanceof ProcessSyntheticObserverMethod;
                        argument = new ObserverInfoImpl(pom.getObserverMethod(), isSynthetic ? null : pom.getAnnotatedMethod(), this.beanManager);
                    } else {
                        argument = this.argumentForExtensionMethod(parameter, method);
                    }
                    arguments.add(argument);
                }
                try {
                    this.util.callExtensionMethod(method, arguments);
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, arguments, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, arguments, e.toString(), e);
                }
            };
            registration = method.getAnnotation(Registration.class);
            this.actions.add(new ExtensionPhaseRegistrationAction(new HashSet(Arrays.asList(registration.types())), null, pomAcceptor));
        } else {
            throw LiteExtensionTranslatorLogger.LOG.unknownQueryParameter((Object)query);
        }
    }

    @Override
    Object argumentForExtensionMethod(ExtensionMethodParameterType type2, Method method) {
        if (type2 == ExtensionMethodParameterType.TYPES) {
            return new TypesImpl(this.beanManager);
        }
        return super.argumentForExtensionMethod(type2, method);
    }
}

