/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.Enhancement;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.weld.lite.extension.translator.ClassConfigImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.ExtensionInvoker;
import org.jboss.weld.lite.extension.translator.ExtensionMethodParameterType;
import org.jboss.weld.lite.extension.translator.ExtensionPhase;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseBase;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseEnhancementAction;
import org.jboss.weld.lite.extension.translator.FieldConfigImpl;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodConfigImpl;
import org.jboss.weld.lite.extension.translator.MethodConstructorConfigImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.SharedErrors;
import org.jboss.weld.lite.extension.translator.TypesImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;

class ExtensionPhaseEnhancement
extends ExtensionPhaseBase {
    private final List<ExtensionPhaseEnhancementAction> actions;

    ExtensionPhaseEnhancement(BeanManager beanManager, ExtensionInvoker util, SharedErrors errors, List<ExtensionPhaseEnhancementAction> actions2) {
        super(ExtensionPhase.ENHANCEMENT, beanManager, util, errors);
        this.actions = actions2;
    }

    @Override
    void runExtensionMethod(Method method) {
        int numParameters = method.getParameterCount();
        int numQueryParameters = 0;
        ArrayList<ExtensionMethodParameterType> parameters = new ArrayList<ExtensionMethodParameterType>(numParameters);
        for (int i = 0; i < numParameters; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            ExtensionMethodParameterType parameter = ExtensionMethodParameterType.of(parameterType);
            parameters.add(parameter);
            if (parameter.isQuery()) {
                ++numQueryParameters;
            }
            parameter.verifyAvailable(ExtensionPhase.ENHANCEMENT, method);
        }
        if (numQueryParameters == 0 || numQueryParameters > 1) {
            throw LiteExtensionTranslatorLogger.LOG.incorrectParameterCount("ClassInfo, MethodInfo, FieldInfo, ClassConfig, MethodConfig, or FieldConfig", method, method.getDeclaringClass());
        }
        ExtensionMethodParameterType query = parameters.stream().filter(ExtensionMethodParameterType::isQuery).findAny().get();
        Consumer<ProcessAnnotatedType<?>> patAcceptor = pat -> {
            Object argument;
            ArrayList<Object> arguments;
            Object argument2;
            ArrayList argumentsForAllInvocations = new ArrayList();
            if (query == ExtensionMethodParameterType.CLASS_INFO) {
                ArrayList<Object> arguments2 = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    Object argument22;
                    if (parameter == ExtensionMethodParameterType.CLASS_INFO) {
                        argument2 = new ClassInfoImpl(pat.getAnnotatedType(), this.beanManager);
                    } else {
                        argument22 = this.argumentForExtensionMethod(parameter, method);
                    }
                    arguments2.add(argument22);
                }
                argumentsForAllInvocations.add(arguments2);
            } else if (query == ExtensionMethodParameterType.CLASS_CONFIG) {
                ArrayList<Object> arguments2 = new ArrayList<Object>(numParameters);
                for (ExtensionMethodParameterType parameter : parameters) {
                    argument2 = parameter == ExtensionMethodParameterType.CLASS_CONFIG ? new ClassConfigImpl(pat.configureAnnotatedType(), this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                    arguments2.add(argument2);
                }
                argumentsForAllInvocations.add(arguments2);
            } else if (query == ExtensionMethodParameterType.METHOD_INFO) {
                for (AnnotatedMethod annotatedMethod : pat.getAnnotatedType().getMethods()) {
                    arguments = new ArrayList<Object>(numParameters);
                    for (ExtensionMethodParameterType parameter : parameters) {
                        argument = parameter == ExtensionMethodParameterType.METHOD_INFO ? new MethodInfoImpl(annotatedMethod, this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                        arguments.add(argument);
                    }
                    argumentsForAllInvocations.add(arguments);
                }
                for (AnnotatedConstructor annotatedConstructor : pat.getAnnotatedType().getConstructors()) {
                    arguments = new ArrayList(numParameters);
                    for (ExtensionMethodParameterType parameter : parameters) {
                        argument = parameter == ExtensionMethodParameterType.METHOD_INFO ? new MethodInfoImpl(annotatedConstructor, this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                        arguments.add(argument);
                    }
                    argumentsForAllInvocations.add(arguments);
                }
            } else if (query == ExtensionMethodParameterType.METHOD_CONFIG) {
                for (AnnotatedMethodConfigurator annotatedMethodConfigurator : pat.configureAnnotatedType().methods()) {
                    arguments = new ArrayList(numParameters);
                    for (ExtensionMethodParameterType parameter : parameters) {
                        argument = parameter == ExtensionMethodParameterType.METHOD_CONFIG ? new MethodConfigImpl(annotatedMethodConfigurator, this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                        arguments.add(argument);
                    }
                    argumentsForAllInvocations.add(arguments);
                }
                for (AnnotatedConstructorConfigurator annotatedConstructorConfigurator : pat.configureAnnotatedType().constructors()) {
                    arguments = new ArrayList(numParameters);
                    for (ExtensionMethodParameterType parameter : parameters) {
                        argument = parameter == ExtensionMethodParameterType.METHOD_CONFIG ? new MethodConstructorConfigImpl(annotatedConstructorConfigurator, this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                        arguments.add(argument);
                    }
                    argumentsForAllInvocations.add(arguments);
                }
            } else if (query == ExtensionMethodParameterType.FIELD_INFO) {
                for (AnnotatedField annotatedField : pat.getAnnotatedType().getFields()) {
                    arguments = new ArrayList(numParameters);
                    for (ExtensionMethodParameterType parameter : parameters) {
                        argument = parameter == ExtensionMethodParameterType.FIELD_INFO ? new FieldInfoImpl(annotatedField, this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                        arguments.add(argument);
                    }
                    argumentsForAllInvocations.add(arguments);
                }
            } else if (query == ExtensionMethodParameterType.FIELD_CONFIG) {
                for (AnnotatedFieldConfigurator annotatedFieldConfigurator : pat.configureAnnotatedType().fields()) {
                    arguments = new ArrayList(numParameters);
                    for (ExtensionMethodParameterType parameter : parameters) {
                        argument = parameter == ExtensionMethodParameterType.FIELD_CONFIG ? new FieldConfigImpl(annotatedFieldConfigurator, this.beanManager) : this.argumentForExtensionMethod(parameter, method);
                        arguments.add(argument);
                    }
                    argumentsForAllInvocations.add(arguments);
                }
            } else {
                throw LiteExtensionTranslatorLogger.LOG.unknownQueryParameter((Object)query);
            }
            for (List list : argumentsForAllInvocations) {
                try {
                    this.util.callExtensionMethod(method, list);
                }
                catch (InvocationTargetException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, list, e.getCause().toString(), e);
                }
                catch (ReflectiveOperationException e) {
                    throw LiteExtensionTranslatorLogger.LOG.unableToInvokeExtensionMethod(method, list, e.toString(), e);
                }
            }
        };
        Enhancement enhancement = method.getAnnotation(Enhancement.class);
        this.actions.add(new ExtensionPhaseEnhancementAction(new HashSet(Arrays.asList(enhancement.types())), enhancement.withSubtypes(), new HashSet<Class<? extends Annotation>>(Arrays.asList(enhancement.withAnnotations())), patAcceptor));
    }

    @Override
    Object argumentForExtensionMethod(ExtensionMethodParameterType type2, Method method) {
        if (type2 == ExtensionMethodParameterType.TYPES) {
            return new TypesImpl(this.beanManager);
        }
        return super.argumentForExtensionMethod(type2, method);
    }
}

