/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.FieldResourceInjection;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.ResourceInjection;
import org.jboss.weld.injection.SetterResourceInjection;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public abstract class ResourceInjectionProcessor<S extends Service, C> {
    protected <T, X> ResourceInjection<T> createStaticProducerFieldResourceInjection(FieldInjectionPoint<T, X> fieldInjectionPoint, BeanManagerImpl beanManager) {
        S injectionServices = this.getInjectionServices(beanManager);
        C processorContext = this.getProcessorContext(beanManager);
        if (injectionServices != null && fieldInjectionPoint.getAnnotated().isAnnotationPresent(this.getMarkerAnnotation(processorContext)) && this.accept((AnnotatedMember<?>)fieldInjectionPoint.getAnnotated(), processorContext)) {
            return this.createFieldResourceInjection(fieldInjectionPoint, injectionServices, processorContext);
        }
        return null;
    }

    protected <T> Set<ResourceInjection<?>> createResourceInjections(Bean<?> declaringBean, EnhancedAnnotatedType<T> type2, BeanManagerImpl manager) {
        S injectionServices = this.getInjectionServices(manager);
        C processorContext = this.getProcessorContext(manager);
        if (injectionServices == null) {
            return Collections.emptySet();
        }
        Class<Annotation> marker = this.getMarkerAnnotation(processorContext);
        Collection<EnhancedAnnotatedField<?, ? super T>> fields = type2.getDeclaredEnhancedFields(marker);
        Collection<EnhancedAnnotatedMethod<?, ? super T>> methods = type2.getDeclaredEnhancedMethods(marker);
        return this.createResourceInjections(fields, methods, declaringBean, type2.getJavaClass(), manager);
    }

    private <T, X> ResourceInjection<T> createFieldResourceInjection(FieldInjectionPoint<T, X> fieldInjectionPoint, S injectionServices, C processorContext) {
        return new FieldResourceInjection<T, X>(fieldInjectionPoint, (ResourceReferenceFactory)Reflections.cast(this.getResourceReferenceFactory(fieldInjectionPoint, injectionServices, processorContext)));
    }

    private <T, X> ResourceInjection<T> createSetterResourceInjection(ParameterInjectionPoint<T, X> parameterInjectionPoint, S injectionServices, C processorContext) {
        return new SetterResourceInjection<T, X>(parameterInjectionPoint, (ResourceReferenceFactory)Reflections.cast(this.getResourceReferenceFactory(parameterInjectionPoint, injectionServices, processorContext)));
    }

    public Class<? extends Annotation> getMarkerAnnotation(BeanManagerImpl manager) {
        return this.getMarkerAnnotation(this.getProcessorContext(manager));
    }

    protected abstract <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint var1, S var2, C var3);

    protected abstract Class<? extends Annotation> getMarkerAnnotation(C var1);

    protected abstract C getProcessorContext(BeanManagerImpl var1);

    protected abstract S getInjectionServices(BeanManagerImpl var1);

    protected <T> Set<ResourceInjection<?>> createResourceInjections(Iterable<EnhancedAnnotatedField<?, ? super T>> fields, Iterable<EnhancedAnnotatedMethod<?, ? super T>> methods, Bean<?> declaringBean, Class<?> declaringClass, BeanManagerImpl manager) {
        ImmutableSet.Builder<ResourceInjection<?>> resourceInjections = ImmutableSet.builder();
        S injectionServices = this.getInjectionServices(manager);
        C processorContext = this.getProcessorContext(manager);
        for (EnhancedAnnotatedField<?, T> enhancedAnnotatedField : fields) {
            if (!this.accept(enhancedAnnotatedField, processorContext)) continue;
            resourceInjections.add(this.createFieldResourceInjection(InjectionPointFactory.silentInstance().createFieldInjectionPoint(enhancedAnnotatedField, declaringBean, declaringClass, manager), injectionServices, processorContext));
        }
        for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : methods) {
            if (enhancedAnnotatedMethod.getParameters().size() != 1) {
                throw UtilLogger.LOG.resourceSetterInjectionNotAJavabean(enhancedAnnotatedMethod);
            }
            if (!this.accept(enhancedAnnotatedMethod, processorContext)) continue;
            EnhancedAnnotatedParameter parameter = enhancedAnnotatedMethod.getEnhancedParameters().get(0);
            resourceInjections.add(this.createSetterResourceInjection(InjectionPointFactory.silentInstance().createParameterInjectionPoint(parameter, declaringBean, declaringClass, manager), injectionServices, processorContext));
        }
        return resourceInjections.build();
    }

    protected boolean accept(AnnotatedMember<?> member, C processorContext) {
        return true;
    }

    protected Type getResourceInjectionPointType(AnnotatedMember<?> member) {
        if (member instanceof AnnotatedField) {
            return member.getBaseType();
        }
        if (member instanceof AnnotatedMethod) {
            AnnotatedMethod method = (AnnotatedMethod)member;
            if (method.getParameters().size() != 1) {
                throw UtilLogger.LOG.resourceSetterInjectionNotAJavabean(method);
            }
            return method.getParameters().get(0).getBaseType();
        }
        throw new IllegalArgumentException("Unknown member " + member);
    }
}

