/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal.interceptor;

import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.hibernate.validator.cdi.internal.interceptor.ValidationEnabledAnnotatedConstructor;
import org.hibernate.validator.cdi.internal.interceptor.ValidationEnabledAnnotatedMethod;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ValidationEnabledAnnotatedType<T>
implements AnnotatedType<T> {
    private final AnnotatedType<T> wrappedType;
    private final Set<AnnotatedMethod<? super T>> wrappedMethods;
    private final Set<AnnotatedConstructor<T>> wrappedConstructors;

    public ValidationEnabledAnnotatedType(AnnotatedType<T> type2, Set<AnnotatedCallable<? super T>> constrainedCallables) {
        this.wrappedType = type2;
        this.wrappedMethods = CollectionHelper.newHashSet();
        this.wrappedConstructors = CollectionHelper.newHashSet();
        this.buildWrappedCallable(constrainedCallables);
    }

    @Override
    public Class<T> getJavaClass() {
        return this.wrappedType.getJavaClass();
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.wrappedConstructors;
    }

    @Override
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.wrappedMethods;
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return this.wrappedType.getFields();
    }

    @Override
    public Type getBaseType() {
        return this.wrappedType.getBaseType();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.wrappedType.getTypeClosure();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.wrappedType.getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.wrappedType.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.wrappedType.isAnnotationPresent(annotationType);
    }

    private void buildWrappedCallable(Set<AnnotatedCallable<? super T>> constrainedCallables) {
        for (AnnotatedConstructor<T> annotatedConstructor : this.wrappedType.getConstructors()) {
            if (constrainedCallables.contains(annotatedConstructor)) {
                ValidationEnabledAnnotatedConstructor<T> wrappedConstructor = new ValidationEnabledAnnotatedConstructor<T>(annotatedConstructor);
                this.wrappedConstructors.add(wrappedConstructor);
                continue;
            }
            this.wrappedConstructors.add(annotatedConstructor);
        }
        for (AnnotatedMethod annotatedMethod : this.wrappedType.getMethods()) {
            if (constrainedCallables.contains(annotatedMethod)) {
                ValidationEnabledAnnotatedMethod wrappedMethod = this.wrap(annotatedMethod);
                this.wrappedMethods.add(wrappedMethod);
                continue;
            }
            this.wrappedMethods.add(annotatedMethod);
        }
    }

    private <U> ValidationEnabledAnnotatedMethod<U> wrap(AnnotatedMethod<U> method) {
        return new ValidationEnabledAnnotatedMethod<U>(method);
    }
}

