/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.cdi.HibernateValidator;
import org.hibernate.validator.internal.engine.ValidatorFactoryImpl;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ValidationProviderHelper {
    private final boolean isDefaultProvider;
    private final boolean isHibernateValidator;
    private final Class<? extends ValidatorFactory> validatorFactoryClass;
    private final Class<? extends Validator> validatorClass;
    private final Set<Annotation> qualifiers;

    public static ValidationProviderHelper forDefaultProvider(ValidatorFactory validatorFactory) {
        boolean isHibernateValidator = validatorFactory instanceof HibernateValidatorFactory;
        return new ValidationProviderHelper(true, isHibernateValidator, validatorFactory.getClass(), validatorFactory.getValidator().getClass(), ValidationProviderHelper.determineRequiredQualifiers(true, isHibernateValidator));
    }

    public static ValidationProviderHelper forHibernateValidator() {
        return new ValidationProviderHelper(false, true, ValidatorFactoryImpl.class, ValidatorImpl.class, ValidationProviderHelper.determineRequiredQualifiers(false, true));
    }

    private ValidationProviderHelper(boolean isDefaultProvider, boolean isHibernateValidator, Class<? extends ValidatorFactory> validatorFactoryClass, Class<? extends Validator> validatorClass, Set<Annotation> qualifiers) {
        this.isDefaultProvider = isDefaultProvider;
        this.isHibernateValidator = isHibernateValidator;
        this.validatorFactoryClass = validatorFactoryClass;
        this.validatorClass = validatorClass;
        this.qualifiers = Collections.unmodifiableSet(qualifiers);
    }

    public boolean isDefaultProvider() {
        return this.isDefaultProvider;
    }

    public boolean isHibernateValidator() {
        return this.isHibernateValidator;
    }

    Class<? extends ValidatorFactory> getValidatorFactoryBeanClass() {
        return this.validatorFactoryClass;
    }

    Class<? extends Validator> getValidatorBeanClass() {
        return this.validatorClass;
    }

    Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    private static Set<Annotation> determineRequiredQualifiers(boolean isDefaultProvider, boolean isHibernateValidator) {
        HashSet<Annotation> qualifiers = CollectionHelper.newHashSet(3);
        if (isDefaultProvider) {
            qualifiers.add(new AnnotationLiteral<Default>(){});
        }
        if (isHibernateValidator) {
            qualifiers.add(new AnnotationLiteral<HibernateValidator>(){});
        }
        qualifiers.add(new AnnotationLiteral<Any>(){});
        return qualifiers;
    }

    public String toString() {
        return "ValidationProviderHelper [isDefaultProvider=" + this.isDefaultProvider + ", isHibernateValidator=" + this.isHibernateValidator + ", validatorFactoryClass=" + this.validatorFactoryClass + ", validatorClass=" + this.validatorClass + ", qualifiers=" + this.qualifiers + "]";
    }
}

