/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.CommonResourceBundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.jsp.tagext.JspTag;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.cdi.CDILoggerInfo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.glassfish.weld.ACLSingletonProvider;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.ResourceLoaderImpl;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.WeldApplicationContainer;
import org.glassfish.weld.WeldContainer;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.EjbServicesImpl;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.NonModuleInjectionServices;
import org.glassfish.weld.services.ProxyServicesImpl;
import org.glassfish.weld.services.SecurityServicesImpl;
import org.glassfish.weld.services.TransactionServicesImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.EEModuleDescriptorImpl;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagerLookupService;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jvnet.hk2.annotations.Service;

@Service
public class WeldDeployer
extends SimpleDeployer<WeldContainer, WeldApplicationContainer>
implements PostConstruct,
EventListener {
    private static final Logger LOG = CDILoggerInfo.getLogger();
    private static final String KEY_BUNDLE_DESCRIPTOR = BundleDescriptor.class.getName();
    public static final String WELD_EXTENSION = "org.glassfish.weld";
    public static final String WELD_DEPLOYMENT = "org.glassfish.weld.WeldDeployment";
    static final String WELD_BOOTSTRAP = "org.glassfish.weld.WeldBootstrap";
    private static final String WELD_CONTEXT_LISTENER = "org.glassfish.weld.WeldContextListener";
    private static final String WELD_LISTENER = "org.jboss.weld.module.web.servlet.WeldListener";
    private static final String WELD_TERMINATION_LISTENER = "org.jboss.weld.module.web.servlet.WeldTerminalListener";
    private static final String WELD_SHUTDOWN = "weld_shutdown";
    private static final String WELD_BOOTSTRAP_SHUTDOWN = "weld_bootstrap_shutdown";
    private static final String WELD_CONVERSATION_FILTER_CLASS = "org.jboss.weld.module.web.servlet.ConversationFilter";
    private static final String WELD_CONVERSATION_FILTER_NAME = "CDI Conversation Filter";
    @Inject
    private Events events;
    @Inject
    private ServiceLocator services;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ArchiveFactory archiveFactory;
    private final Map<Application, WeldBootstrap> appToBootstrap = new HashMap<Application, WeldBootstrap>();
    private final Map<BundleDescriptor, BeanDeploymentArchive> bundleToBeanDeploymentArchive = new HashMap<BundleDescriptor, BeanDeploymentArchive>();
    private static final Class<?>[] NON_CONTEXT_CLASSES = new Class[]{Servlet.class, ServletContextListener.class, Filter.class, HttpSessionListener.class, ServletRequestListener.class, JspTag.class};

    @Override
    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    @Override
    public void postConstruct() {
        this.events.register(this);
    }

    @Override
    public WeldApplicationContainer load(WeldContainer container, DeploymentContext context) {
        BeanDeploymentArchive beanDeploymentArchive;
        DeploymentImpl deploymentImpl;
        DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        ApplicationInfo appInfo = this.applicationRegistry.get(deployParams.name);
        ReadableArchive archive = context.getSource();
        WeldBootstrap bootstrap = context.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        if (bootstrap == null) {
            bootstrap = new WeldBootstrap();
            Application app = context.getModuleMetaData(Application.class);
            this.appToBootstrap.put(app, bootstrap);
            context.addTransientAppMetaData(WELD_BOOTSTRAP, bootstrap);
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP, bootstrap);
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, "false");
        }
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        EjbServicesImpl ejbServices = null;
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        if (ejbBundle != null) {
            ejbs.addAll(ejbBundle.getEjbs());
            ejbServices = new EjbServicesImpl(this.services);
        }
        if ((deploymentImpl = context.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) == null) {
            deploymentImpl = new DeploymentImpl(archive, ejbs, context, this.archiveFactory);
            deploymentImpl.getServices().add(TransactionServices.class, new TransactionServicesImpl(this.services));
            deploymentImpl.getServices().add(SecurityServices.class, new SecurityServicesImpl());
            deploymentImpl.getServices().add(ProxyServices.class, new ProxyServicesImpl(this.services));
            this.addWeldListenerToAllWars(context);
        } else {
            deploymentImpl.scanArchive(archive, ejbs, context);
        }
        deploymentImpl.addDeployedEjbs(ejbs);
        if (ejbBundle != null && !deploymentImpl.getServices().contains(EjbServices.class)) {
            deploymentImpl.getServices().add(EjbServices.class, ejbServices);
        }
        if ((beanDeploymentArchive = deploymentImpl.getBeanDeploymentArchiveForArchive(archive.getName())) == null || beanDeploymentArchive.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            LOG.log(Level.FINE, "The bean discovery mode was explicitly set to NONE in the beans.xml file or the archive is not a CDI deployment archive.");
        } else {
            CommonResourceBundleDescriptor bundle2;
            WebBundleDescriptor webBundleDescriptor = context.getModuleMetaData(WebBundleDescriptor.class);
            if (webBundleDescriptor != null) {
                webBundleDescriptor.setExtensionProperty(WELD_EXTENSION, "true");
                webBundleDescriptor.addAppListenerDescriptorToFirst(new AppListenerDescriptorImpl(WELD_LISTENER));
                webBundleDescriptor.addAppListenerDescriptor(new AppListenerDescriptorImpl(WELD_CONTEXT_LISTENER));
                webBundleDescriptor.addAppListenerDescriptor(new AppListenerDescriptorImpl(WELD_TERMINATION_LISTENER));
                for (ServletFilterMapping filterMapping : webBundleDescriptor.getServletFilterMappings()) {
                    String displayName = ((ServletFilterMappingDescriptor)filterMapping).getDisplayName();
                    if (!WELD_CONVERSATION_FILTER_NAME.equals(displayName)) continue;
                    ServletFilterDescriptor filterDescriptor = new ServletFilterDescriptor();
                    filterDescriptor.setClassName(WELD_CONVERSATION_FILTER_CLASS);
                    filterDescriptor.setName(WELD_CONVERSATION_FILTER_NAME);
                    webBundleDescriptor.addServletFilter(filterDescriptor);
                    break;
                }
            }
            CommonResourceBundleDescriptor commonResourceBundleDescriptor = bundle2 = webBundleDescriptor == null ? ejbBundle : webBundleDescriptor;
            if (bundle2 != null) {
                InjectionManager injectionManager = this.services.getService(InjectionManager.class, new Annotation[0]);
                InjectionServicesImpl injectionServices = new InjectionServicesImpl(injectionManager, bundle2, deploymentImpl);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, beanDeploymentArchive.getId()});
                }
                beanDeploymentArchive.getServices().add(InjectionServices.class, injectionServices);
                EEModuleDescriptor eeModuleDescriptor = this.getEEModuleDescriptor(beanDeploymentArchive);
                if (eeModuleDescriptor != null) {
                    beanDeploymentArchive.getServices().add(EEModuleDescriptor.class, eeModuleDescriptor);
                }
                for (BeanDeploymentArchive subBeanDeploymentArchive : beanDeploymentArchive.getBeanDeploymentArchives()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "AS-CDI-00039", new Object[]{injectionServices, subBeanDeploymentArchive.getId()});
                    }
                    subBeanDeploymentArchive.getServices().add(InjectionServices.class, injectionServices);
                    eeModuleDescriptor = this.getEEModuleDescriptor(beanDeploymentArchive);
                    if (eeModuleDescriptor == null) continue;
                    beanDeploymentArchive.getServices().add(EEModuleDescriptor.class, eeModuleDescriptor);
                }
                LOG.log(Level.CONFIG, "Adding pair bundle.class={0}, bundle.name={1} and archive.class={2}, archive.id={3}", new Object[]{bundle2.getClass(), bundle2.getName(), beanDeploymentArchive.getClass(), beanDeploymentArchive.getId()});
                this.bundleToBeanDeploymentArchive.put(bundle2, beanDeploymentArchive);
                appInfo.addTransientAppMetaData(KEY_BUNDLE_DESCRIPTOR, bundle2);
            }
        }
        context.addTransientAppMetaData(WELD_DEPLOYMENT, deploymentImpl);
        appInfo.addTransientAppMetaData(WELD_DEPLOYMENT, deploymentImpl);
        return new WeldApplicationContainer();
    }

    @Override
    public void event(EventListener.Event<?> event) {
        LOG.log(Level.FINEST, () -> "event(event.name=" + event.name() + ", event.hook=" + String.valueOf(event.hook()) + ")");
        if (event.is(Deployment.APPLICATION_LOADED)) {
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            WeldBootstrap bootstrap = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
            if (bootstrap == null) {
                return;
            }
            this.enable(appInfo, bootstrap);
        } else if (event.is(Deployment.APPLICATION_STOPPED) || event.is(Deployment.APPLICATION_UNLOADED) || event.is(Deployment.APPLICATION_DISABLED)) {
            this.disable((ApplicationInfo)event.hook());
        }
    }

    @Override
    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    @Override
    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    @Override
    public <V> V loadMetaData(Class<V> type2, DeploymentContext context) {
        return null;
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForBundle(BundleDescriptor bundle2) {
        LOG.log(Level.FINEST, "getBeanDeploymentArchiveForBundle(bundle.class={0})", bundle2.getClass());
        return this.bundleToBeanDeploymentArchive.get(bundle2);
    }

    public boolean isCdiEnabled(BundleDescriptor bundle2) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle2);
    }

    public WeldBootstrap getBootstrapForApp(Application app) {
        LOG.log(Level.FINEST, "getBootstrapForApp(app.name={0})", app.getName());
        return this.appToBootstrap.get(app);
    }

    private void enable(ApplicationInfo appInfo, WeldBootstrap bootstrap) {
        LOG.log(Level.INFO, () -> "Enabling Weld for " + String.valueOf(appInfo));
        DeploymentImpl deploymentImpl = appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class);
        deploymentImpl.buildDeploymentGraph();
        Collection archives = deploymentImpl.getBeanDeploymentArchives();
        for (BeanDeploymentArchive archive : archives) {
            ResourceLoaderImpl loader = new ResourceLoaderImpl(((BeanDeploymentArchiveImpl)archive).getModuleClassLoaderForBDA());
            archive.getServices().add(ResourceLoader.class, loader);
        }
        InjectionManager injectionManager = this.services.getService(InjectionManager.class, new Annotation[0]);
        this.addCdiServicesToNonModuleBdas(deploymentImpl.getLibJarRootBdas(), injectionManager);
        this.addCdiServicesToNonModuleBdas(deploymentImpl.getRarRootBdas(), injectionManager);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.invocationManager.pushAppEnvironment(new WeldApplicationEnvironment(appInfo));
        try {
            this.doBootstrapStartup(appInfo, bootstrap, deploymentImpl);
        }
        catch (Throwable t) {
            this.doBootstrapShutdown(appInfo);
            String msgPrefix = this.getDeploymentErrorMsgPrefix(t);
            throw new DeploymentException(msgPrefix + t.getMessage(), t);
        }
        finally {
            this.invocationManager.popAppEnvironment();
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            this.deploymentComplete(deploymentImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(ApplicationInfo appInfo) {
        DeploymentImpl deploymentImpl;
        block12: {
            String shutdown;
            Application app = appInfo.getMetaData(Application.class);
            LOG.log(Level.FINEST, () -> "Found application: " + String.valueOf(app));
            if (app != null) {
                for (BundleDescriptor next : app.getBundleDescriptors()) {
                    if (!(next instanceof EjbBundleDescriptor) && !(next instanceof WebBundleDescriptor)) continue;
                    this.bundleToBeanDeploymentArchive.remove(next);
                }
                this.appToBootstrap.remove(app);
            }
            if (Boolean.TRUE.equals(Boolean.valueOf(shutdown = appInfo.getTransientAppMetaData(WELD_SHUTDOWN, String.class)))) {
                return;
            }
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(appInfo.getAppClassLoader());
            try {
                WeldBootstrap bootstrap = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
                LOG.log(Level.FINEST, () -> "Found bootstrap: " + String.valueOf(bootstrap));
                if (bootstrap == null) break block12;
                LOG.log(Level.INFO, () -> "Disabling Weld for " + String.valueOf(appInfo));
                this.invocationManager.pushAppEnvironment(new WeldApplicationEnvironment(appInfo));
                try {
                    this.doBootstrapShutdown(appInfo);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "AS-CDI-00036", e);
                }
                finally {
                    this.invocationManager.popAppEnvironment();
                }
                appInfo.addTransientAppMetaData(WELD_SHUTDOWN, "true");
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        if ((deploymentImpl = appInfo.getTransientAppMetaData(WELD_DEPLOYMENT, DeploymentImpl.class)) != null) {
            deploymentImpl.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBootstrapStartup(ApplicationInfo appInfo, WeldBootstrap bootstrap, DeploymentImpl deploymentImpl) {
        ComponentInvocation componentInvocation = this.createComponentInvocation(appInfo);
        try {
            this.invocationManager.preInvoke(componentInvocation);
            Iterable<Metadata<Extension>> extensions = deploymentImpl.getExtensions();
            LOG.log(Level.FINE, () -> "Starting extensions: " + String.valueOf(extensions));
            bootstrap.startExtensions(extensions);
            bootstrap.startContainer(appInfo.getName(), Environments.SERVLET, deploymentImpl);
            if (!deploymentImpl.getBeanDeploymentArchives().isEmpty()) {
                this.enableEjbSupport(bootstrap, deploymentImpl);
            }
            bootstrap.startInitialization();
            this.fireProcessInjectionTargetEvents(bootstrap, deploymentImpl);
            bootstrap.deployBeans();
            bootstrap.validateBeans();
            bootstrap.endInitialization();
        }
        finally {
            this.invocationManager.postInvoke(componentInvocation);
        }
    }

    private ComponentInvocation createComponentInvocation(ApplicationInfo applicationInfo) {
        BundleDescriptor bundleDescriptor = applicationInfo.getTransientAppMetaData(KEY_BUNDLE_DESCRIPTOR, BundleDescriptor.class);
        String componentEnvId = DOLUtils.getComponentEnvId((JndiNameEnvironment)((Object)bundleDescriptor));
        LOG.log(Level.FINE, () -> "Computed component env id=" + componentEnvId + " for application name=" + applicationInfo.getName());
        ComponentInvocation componentInvocation = new ComponentInvocation(componentEnvId, ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION, (Object)applicationInfo, applicationInfo.getName(), applicationInfo.getName());
        componentInvocation.setJNDIEnvironment(bundleDescriptor);
        return componentInvocation;
    }

    private void enableEjbSupport(WeldBootstrap bootstrap, DeploymentImpl deploymentImpl) {
        BeanDeploymentArchive rootArchive = (BeanDeploymentArchive)deploymentImpl.getBeanDeploymentArchives().get(0);
        ServiceRegistry rootServices = bootstrap.getManager(rootArchive).getServices();
        EjbSupport originalEjbSupport = rootServices.get(EjbSupport.class);
        if (originalEjbSupport != null) {
            WeldInvocationHandler handler = new WeldInvocationHandler(deploymentImpl, originalEjbSupport, bootstrap);
            EjbSupport proxyEjbSupport = (EjbSupport)Proxy.newProxyInstance(EjbSupport.class.getClassLoader(), new Class[]{EjbSupport.class}, (InvocationHandler)handler);
            rootServices.add(EjbSupport.class, proxyEjbSupport);
        }
    }

    private void deploymentComplete(DeploymentImpl deploymentImpl) {
        for (BeanDeploymentArchive oneBda : deploymentImpl.getBeanDeploymentArchives()) {
            ((BeanDeploymentArchiveImpl)oneBda).setDeploymentComplete(true);
        }
    }

    private void doBootstrapShutdown(ApplicationInfo appInfo) {
        WeldBootstrap bootstrap = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP, WeldBootstrap.class);
        String bootstrapShutdown = appInfo.getTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, String.class);
        if (bootstrapShutdown == null || Boolean.valueOf(bootstrapShutdown).equals(Boolean.FALSE)) {
            bootstrap.shutdown();
            appInfo.addTransientAppMetaData(WELD_BOOTSTRAP_SHUTDOWN, "true");
        }
    }

    private String getDeploymentErrorMsgPrefix(Throwable t) {
        if (t instanceof DefinitionException) {
            return "CDI definition failure: ";
        }
        if (t instanceof jakarta.enterprise.inject.spi.DeploymentException) {
            return "CDI deployment failure: ";
        }
        Throwable cause = t.getCause();
        if (cause == t || cause == null) {
            return "CDI deployment failure: ";
        }
        return this.getDeploymentErrorMsgPrefix(cause);
    }

    private void fireProcessInjectionTargetEvents(WeldBootstrap bootstrap, DeploymentImpl impl) {
        Collection bdaList = impl.getBeanDeploymentArchives();
        Class<?> messageListenerClass = this.loadMessageListenerClass();
        for (BeanDeploymentArchive bda : bdaList) {
            Collection<Class<?>> bdaClasses = ((BeanDeploymentArchiveImpl)bda).getBeanClassObjects();
            for (Class<?> bdaClazz : bdaClasses) {
                for (Class<?> nonClazz : NON_CONTEXT_CLASSES) {
                    if (!nonClazz.isAssignableFrom(bdaClazz)) continue;
                    this.firePITEvent(bootstrap, bda, bdaClazz);
                }
                if (messageListenerClass == null || !messageListenerClass.isAssignableFrom(bdaClazz)) continue;
                LOG.log(Level.FINE, "AS-CDI-00038", bdaClazz);
                this.firePITEvent(bootstrap, bda, bdaClazz);
            }
        }
    }

    private Class<?> loadMessageListenerClass() {
        try {
            Class<?> messageListenerClass = Thread.currentThread().getContextClassLoader().loadClass("jakarta.jms.MessageListener");
            LOG.log(Level.FINE, "AS-CDI-00037");
            return messageListenerClass;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private void firePITEvent(WeldBootstrap bootstrap, BeanDeploymentArchive bda, Class<?> bdaClazz) {
        if (bdaClazz.isInterface()) {
            return;
        }
        AnnotatedType<?> annotatedType = bootstrap.getManager(bda).createAnnotatedType(bdaClazz);
        InjectionTarget<?> injectionTarget = bootstrap.getManager(bda).fireProcessInjectionTarget(annotatedType);
        ((BeanDeploymentArchiveImpl)bda).putInjectionTarget(annotatedType, injectionTarget);
    }

    private EEModuleDescriptor getEEModuleDescriptor(BeanDeploymentArchive beanDeploymentArchive) {
        if (!(beanDeploymentArchive instanceof BeanDeploymentArchiveImpl)) {
            return null;
        }
        WeldUtils.BDAType bdaType = ((BeanDeploymentArchiveImpl)beanDeploymentArchive).getBDAType();
        if (bdaType.equals((Object)WeldUtils.BDAType.JAR)) {
            return new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.EJB_JAR);
        }
        if (bdaType.equals((Object)WeldUtils.BDAType.WAR)) {
            return new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.WEB);
        }
        if (bdaType.equals((Object)WeldUtils.BDAType.RAR)) {
            return new EEModuleDescriptorImpl(beanDeploymentArchive.getId(), EEModuleDescriptor.ModuleType.CONNECTOR);
        }
        return null;
    }

    private void addWeldListenerToAllWars(DeploymentContext context) {
        ApplicationHolder applicationHolder = context.getModuleMetaData(ApplicationHolder.class);
        if (applicationHolder != null && applicationHolder.app.getBundleDescriptors(EjbBundleDescriptor.class).size() > 0) {
            Set<WebBundleDescriptor> webBundleDescriptors = applicationHolder.app.getBundleDescriptors(WebBundleDescriptor.class);
            for (WebBundleDescriptor oneWebBundleDescriptor : webBundleDescriptors) {
                oneWebBundleDescriptor.addAppListenerDescriptorToFirst(new AppListenerDescriptorImpl(WELD_LISTENER));
                oneWebBundleDescriptor.addAppListenerDescriptor(new AppListenerDescriptorImpl(WELD_TERMINATION_LISTENER));
            }
        }
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        EjbBundleDescriptor ejbBundle = context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle != null) {
            return ejbBundle;
        }
        WebBundleDescriptor webBundleDescriptor = context.getModuleMetaData(WebBundleDescriptor.class);
        if (webBundleDescriptor == null) {
            return null;
        }
        Collection<EjbBundleDescriptor> ejbBundles = webBundleDescriptor.getExtensionsDescriptors(EjbBundleDescriptor.class);
        if (ejbBundles.iterator().hasNext()) {
            return ejbBundles.iterator().next();
        }
        return null;
    }

    private void addCdiServicesToNonModuleBdas(Iterator<RootBeanDeploymentArchive> rootBdas, InjectionManager injectionMgr) {
        if (injectionMgr != null && rootBdas != null) {
            while (rootBdas.hasNext()) {
                RootBeanDeploymentArchive oneRootBda = rootBdas.next();
                this.addCdiServicesToBda(injectionMgr, oneRootBda);
                this.addCdiServicesToBda(injectionMgr, oneRootBda.getModuleBda());
            }
        }
    }

    private void addCdiServicesToBda(InjectionManager injectionManager, BeanDeploymentArchive beanDeploymentArchive) {
        beanDeploymentArchive.getServices().add(InjectionServices.class, new NonModuleInjectionServices(injectionManager));
    }

    static {
        try {
            ACLSingletonProvider.initializeSingletonProvider();
        }
        catch (RuntimeException ignore) {
            LOG.log(Level.FINEST, "The singleton provider was already initialized, I am ignoring the exception.", ignore);
        }
    }

    private static class WeldApplicationEnvironment
    implements ApplicationEnvironment {
        private final ApplicationInfo appInfo;

        private WeldApplicationEnvironment(ApplicationInfo appInfo) {
            this.appInfo = appInfo;
        }

        @Override
        public String getName() {
            return this.appInfo.getName();
        }
    }

    private static class WeldInvocationHandler
    implements InvocationHandler {
        private final DeploymentImpl deploymentImpl;
        private final EjbSupport originalEjbSupport;
        private final WeldBootstrap bootstrap;

        private WeldInvocationHandler(DeploymentImpl deploymentImpl, EjbSupport originalEjbSupport, WeldBootstrap bootstrap) {
            this.deploymentImpl = deploymentImpl;
            this.originalEjbSupport = originalEjbSupport;
            this.bootstrap = bootstrap;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object enhancedAnnotated;
            Class beanClass;
            EjbSupport targetEjbSupport;
            if (method.getName().equals("isEjb")) {
                EjbSupport targetEjbSupport2 = this.getTargetEjbSupport((Class)args[0]);
                if (targetEjbSupport2 != null) {
                    return method.invoke((Object)targetEjbSupport2, args);
                }
            } else if (method.getName().equals("createSessionBeanAttributes") && (targetEjbSupport = this.getTargetEjbSupport(beanClass = (Class)(enhancedAnnotated = args[0]).getClass().getMethod("getJavaClass", new Class[0]).invoke(enhancedAnnotated, new Object[0]))) != null) {
                return method.invoke((Object)targetEjbSupport, args);
            }
            return method.invoke((Object)this.originalEjbSupport, args);
        }

        private EjbSupport getTargetEjbSupport(Class<?> beanClass) {
            BeanDeploymentArchive ejbArchive = this.deploymentImpl.getBeanDeploymentArchive(beanClass);
            if (ejbArchive == null) {
                return null;
            }
            BeanManagerImpl ejbBeanManager = BeanManagerLookupService.lookupBeanManager(beanClass, this.bootstrap.getManager(ejbArchive));
            return ejbBeanManager.getServices().get(EjbSupport.class);
        }
    }
}

