/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Engine;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.web.config.serverbeans.ContextParam;
import org.glassfish.web.config.serverbeans.WebModuleConfig;
import org.glassfish.web.plugin.common.WebModuleConfigCommand;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-web-context-param")
@I18n(value="setWebContextParam.command")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.POST, path="set-web-context-param", description="set-web-context-param", params={@RestParam(name="id", value="$parent")})})
public class SetWebContextParamCommand
extends WebModuleConfigCommand {
    @Param(name="name")
    private String name;
    @Param(name="value", optional=true)
    private String value;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="ignoreDescriptorItem", optional=true)
    private Boolean ignoreDescriptorItem;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Engine engine = this.engine(report);
            if (engine != null) {
                this.setContextParam(engine, this.name, this.value, this.description, this.ignoreDescriptorItem, report);
            }
        }
        catch (Exception e) {
            this.fail(report, e, "errSetContextParam", "Error setting context param", new Object[0]);
        }
    }

    private void setContextParam(Engine owningEngine, String paramName, String paramValue, String description, Boolean ignoreDescriptorItem, ActionReport report) throws PropertyVetoException, TransactionFailure {
        WebModuleConfig config = WebModuleConfig.webModuleConfig(owningEngine);
        if (config == null) {
            this.createContextParamOnNewWMC(owningEngine, paramName, paramValue, description, ignoreDescriptorItem);
        } else {
            ContextParam cp = config.getContextParam(paramName);
            if (cp == null) {
                this.createContextParamOnExistingWMC(config, paramName, paramValue, description, ignoreDescriptorItem);
            } else {
                this.modifyContextParam(cp, paramValue, description, ignoreDescriptorItem);
                this.succeed(report, "setWebContextParamOverride", "Previous context-param setting of {0} for application/module {1} was overridden.", this.name, this.appNameAndOptionalModuleName());
            }
        }
    }

    private void createContextParamOnNewWMC(Engine owningEngine, final String paramName, final String paramValue, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode<Engine>(){

            @Override
            public Object run(Engine e) throws PropertyVetoException, TransactionFailure {
                WebModuleConfig config = e.createChild(WebModuleConfig.class);
                e.getApplicationConfigs().add(config);
                ContextParam newParam = config.createChild(ContextParam.class);
                config.getContextParam().add(newParam);
                SetWebContextParamCommand.this.set(newParam, paramName, paramValue, description, ignoreDescriptorItem);
                return config;
            }
        }, owningEngine);
    }

    private void createContextParamOnExistingWMC(WebModuleConfig config, final String paramName, final String paramValue, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode<WebModuleConfig>(){

            @Override
            public Object run(WebModuleConfig cf) throws PropertyVetoException, TransactionFailure {
                ContextParam param = cf.createChild(ContextParam.class);
                cf.getContextParam().add(param);
                SetWebContextParamCommand.this.set(param, paramName, paramValue, description, ignoreDescriptorItem);
                return param;
            }
        }, config);
    }

    private void modifyContextParam(ContextParam param, final String paramValue, final String description, final Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        ConfigSupport.apply(new SingleConfigCode<ContextParam>(){

            @Override
            public Object run(ContextParam cp) throws PropertyVetoException, TransactionFailure {
                SetWebContextParamCommand.this.set(cp, cp.getParamName(), paramValue, description, ignoreDescriptorItem);
                return cp;
            }
        }, param);
    }

    private void set(ContextParam param, String paramName, String paramValue, String description, Boolean ignoreDescriptorItem) throws PropertyVetoException, TransactionFailure {
        if (ignoreDescriptorItem != null) {
            param.setIgnoreDescriptorItem(ignoreDescriptorItem.toString());
        }
        if (description != null) {
            param.setDescription(description);
        }
        if (paramValue != null) {
            param.setParamValue(paramValue);
        }
        if (paramName != null) {
            param.setParamName(paramName);
        }
    }
}

