/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.statistics;

import jakarta.inject.Inject;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class HTTPListenerStatsImpl
implements MonitorContract {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    private static final String name = "httplistener";
    private static final String displayFormat = "%1$-4s %2$-4s %3$-6.2f %4$-4s";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public ActionReport process(ActionReport report, String filter) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("HTTPListenerStatsImpl: process ...");
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(rb.getString("AS-WEB-ADMIN-00046"));
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(rb.getString("AS-WEB-ADMIN-00046"));
            return report;
        }
        long errorCount = 0L;
        long maxTime = 0L;
        double processingTime = 0.0;
        long requestCount = 0L;
        List<TreeNode> tnL = serverNode.getNodes("server.web.request.*");
        for (TreeNode tn : tnL) {
            if (tn.hasChildNodes()) continue;
            if ("errorcount".equals(tn.getName())) {
                errorCount = this.getCountStatisticValue(tn.getValue());
                continue;
            }
            if ("maxtime".equals(tn.getName())) {
                maxTime = this.getCountStatisticValue(tn.getValue());
                continue;
            }
            if ("processingtime".equals(tn.getName())) {
                processingTime = this.getCountStatisticValue(tn.getValue());
                continue;
            }
            if (!"requestcount".equals(tn.getName())) continue;
            requestCount = this.getCountStatisticValue(tn.getValue());
        }
        report.setMessage(String.format(displayFormat, errorCount, maxTime, processingTime, requestCount));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private long getCountStatisticValue(Object obj) {
        long l = 0L;
        if (obj == null) {
            return l;
        }
        if (obj instanceof CountStatistic) {
            return ((CountStatistic)obj).getCount();
        }
        return l;
    }
}

