/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-protocol")
@PerLookup
@I18n(value="delete.protocol")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteProtocol
implements AdminCommand {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    Protocol protocol = null;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;

    @Override
    public void execute(AdminCommandContext context) {
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        try {
            this.protocol = protocols.findProtocol(this.protocolName);
            if (this.protocol == null) {
                report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00035"), this.protocolName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            List<NetworkListener> nwlsnrList = this.protocol.findNetworkListeners();
            for (NetworkListener nwlsnr : nwlsnrList) {
                if (!this.protocol.getName().equals(nwlsnr.getProtocol())) continue;
                report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00036"), this.protocolName, nwlsnr.getName()));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply(new SingleConfigCode<Protocols>(){

                @Override
                public Object run(Protocols param) {
                    param.getProtocol().remove(DeleteProtocol.this.protocol);
                    return DeleteProtocol.this.protocol;
                }
            }, protocols);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00037"), this.protocolName) + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

