/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tag.common.xml;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.glassfish.wasp.taglibs.standard.resources.Resources;
import org.glassfish.wasp.taglibs.standard.tag.common.core.ImportSupport;
import org.glassfish.wasp.taglibs.standard.tag.common.core.Util;
import org.glassfish.wasp.taglibs.standard.tag.common.xml.DocumentBuilderProvider;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ParseSupport
extends BodyTagSupport {
    protected Object xml;
    protected String systemId;
    protected XMLFilter filter;
    private String var;
    private String varDom;
    private int scope;
    private int scopeDom;
    private DocumentBuilder db;
    private TransformerFactory tf;
    private TransformerHandler th;

    public ParseSupport() {
        this.init();
    }

    private void init() {
        this.varDom = null;
        this.var = null;
        this.xml = null;
        this.systemId = null;
        this.filter = null;
        this.db = null;
        this.tf = null;
        this.th = null;
        this.scope = 1;
        this.scopeDom = 1;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            Document d;
            Object xmlText;
            this.db = DocumentBuilderProvider.createSecureDocumentBuilder();
            if (this.filter != null) {
                if (this.tf == null) {
                    this.tf = TransformerFactory.newInstance();
                }
                if (!this.tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                    throw new JspTagException(Resources.getMessage("PARSE_NO_SAXTRANSFORMER"));
                }
                try {
                    this.tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (TransformerConfigurationException e) {
                    throw new AssertionError((Object)"TransformerFactory does not support secure processing");
                }
                SAXTransformerFactory stf = (SAXTransformerFactory)this.tf;
                this.th = stf.newTransformerHandler();
            }
            if ((xmlText = this.xml) == null) {
                xmlText = this.bodyContent != null && this.bodyContent.getString() != null ? this.bodyContent.getString().trim() : "";
            }
            if (xmlText instanceof String) {
                d = this.parseStringWithFilter((String)xmlText, this.filter);
            } else if (xmlText instanceof Reader) {
                d = this.parseReaderWithFilter((Reader)xmlText, this.filter);
            } else {
                throw new JspTagException(Resources.getMessage("PARSE_INVALID_SOURCE"));
            }
            if (this.var != null) {
                this.pageContext.setAttribute(this.var, d, this.scope);
            }
            if (this.varDom != null) {
                this.pageContext.setAttribute(this.varDom, d, this.scopeDom);
            }
            return 6;
        }
        catch (SAXException ex) {
            throw new JspException(ex);
        }
        catch (IOException ex) {
            throw new JspException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new JspException(ex);
        }
    }

    @Override
    public void release() {
        this.init();
    }

    private Document parseInputSourceWithFilter(InputSource s, XMLFilter f) throws SAXException, IOException {
        if (f != null) {
            Document o = this.db.newDocument();
            this.th.setResult(new DOMResult(o));
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setEntityResolver(new JstlEntityResolver(this.pageContext));
            f.setParent(xr);
            f.setContentHandler(this.th);
            f.parse(s);
            return o;
        }
        return this.parseInputSource(s);
    }

    private Document parseReaderWithFilter(Reader r, XMLFilter f) throws SAXException, IOException {
        return this.parseInputSourceWithFilter(new InputSource(r), f);
    }

    private Document parseStringWithFilter(String s, XMLFilter f) throws SAXException, IOException {
        StringReader r = new StringReader(s);
        return this.parseReaderWithFilter(r, f);
    }

    private Document parseURLWithFilter(String url, XMLFilter f) throws SAXException, IOException {
        return this.parseInputSourceWithFilter(new InputSource(url), f);
    }

    private Document parseInputSource(InputSource s) throws SAXException, IOException {
        this.db.setEntityResolver(new JstlEntityResolver(this.pageContext));
        if (this.systemId == null) {
            s.setSystemId("jstl:");
        } else if (ImportSupport.isAbsoluteUrl(this.systemId)) {
            s.setSystemId(this.systemId);
        } else {
            s.setSystemId("jstl:" + this.systemId);
        }
        return this.db.parse(s);
    }

    private Document parseReader(Reader r) throws SAXException, IOException {
        return this.parseInputSource(new InputSource(r));
    }

    private Document parseString(String s) throws SAXException, IOException {
        StringReader r = new StringReader(s);
        return this.parseReader(r);
    }

    private Document parseURL(String url) throws SAXException, IOException {
        return this.parseInputSource(new InputSource(url));
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarDom(String varDom) {
        this.varDom = varDom;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    public void setScopeDom(String scopeDom) {
        this.scopeDom = Util.getScope(scopeDom);
    }

    public static class JstlEntityResolver
    implements EntityResolver {
        private final PageContext ctx;

        public JstlEntityResolver(PageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws FileNotFoundException {
            InputStream s;
            if (systemId == null) {
                return null;
            }
            if (systemId.startsWith("jstl:")) {
                systemId = systemId.substring(5);
            }
            if (ImportSupport.isAbsoluteUrl(systemId)) {
                return null;
            }
            if (systemId.startsWith("/")) {
                s = this.ctx.getServletContext().getResourceAsStream(systemId);
                if (s == null) {
                    throw new FileNotFoundException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", systemId));
                }
            } else {
                String pagePath = ((HttpServletRequest)this.ctx.getRequest()).getServletPath();
                String basePath = pagePath.substring(0, pagePath.lastIndexOf("/"));
                s = this.ctx.getServletContext().getResourceAsStream(basePath + "/" + systemId);
                if (s == null) {
                    throw new FileNotFoundException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", systemId));
                }
            }
            return new InputSource(s);
        }
    }
}

