/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.lang.support;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.Tag;
import java.util.HashMap;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Coercions;
import org.glassfish.wasp.taglibs.standard.lang.jstl.ELException;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Logger;
import org.glassfish.wasp.taglibs.standard.lang.support.ExpressionEvaluator;

public class ExpressionEvaluatorManager {
    public static final String EVALUATOR_CLASS = "org.glassfish.wasp.taglibs.standard.lang.jstl.Evaluator";
    private static final HashMap<String, ExpressionEvaluator> nameMap = new HashMap();
    private static final Logger logger = new Logger(System.out);

    public static Object evaluate(String attributeName, String expression, Class expectedType, Tag tag, PageContext pageContext) throws JspException {
        ExpressionEvaluator target = ExpressionEvaluatorManager.getEvaluatorByName(EVALUATOR_CLASS);
        return target.evaluate(attributeName, expression, expectedType, tag, pageContext);
    }

    public static Object evaluate(String attributeName, String expression, Class expectedType, PageContext pageContext) throws JspException {
        ExpressionEvaluator target = ExpressionEvaluatorManager.getEvaluatorByName(EVALUATOR_CLASS);
        return target.evaluate(attributeName, expression, expectedType, null, pageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionEvaluator getEvaluatorByName(String name) throws JspException {
        ExpressionEvaluator oEvaluator = nameMap.get(name);
        if (oEvaluator != null) {
            return oEvaluator;
        }
        try {
            HashMap<String, ExpressionEvaluator> hashMap = nameMap;
            synchronized (hashMap) {
                oEvaluator = nameMap.get(name);
                if (oEvaluator != null) {
                    return oEvaluator;
                }
                ExpressionEvaluator e = (ExpressionEvaluator)Class.forName(name).newInstance();
                nameMap.put(name, e);
                return e;
            }
        }
        catch (ClassCastException ex) {
            throw new JspException("invalid ExpressionEvaluator: " + ex.toString(), ex);
        }
        catch (ClassNotFoundException ex) {
            throw new JspException("couldn't find ExpressionEvaluator: " + ex.toString(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new JspException("couldn't access ExpressionEvaluator: " + ex.toString(), ex);
        }
        catch (InstantiationException ex) {
            throw new JspException("couldn't instantiate ExpressionEvaluator: " + ex.toString(), ex);
        }
    }

    public static Object coerce(Object value, Class<?> classe) throws JspException {
        try {
            return Coercions.coerce(value, classe, logger);
        }
        catch (ELException ex) {
            throw new JspException(ex);
        }
    }
}

