/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.runtime;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ELException;
import jakarta.servlet.jsp.el.Expression;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.FunctionMapper;
import jakarta.servlet.jsp.el.VariableResolver;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.glassfish.wasp.runtime.ELContextImpl;
import org.glassfish.wasp.runtime.VariableResolverImpl;

public class ExpressionEvaluatorImpl
extends ExpressionEvaluator {
    private PageContext pageContext;

    public ExpressionEvaluatorImpl(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Expression parseExpression(String expression, Class expectedType, FunctionMapper fMapper) throws ELException {
        ValueExpression expr;
        ExpressionFactory fac = ExpressionFactory.newInstance();
        ELContextImpl elContext = new ELContextImpl(null);
        FunctionMapperWrapper fm = new FunctionMapperWrapper(fMapper);
        elContext.setFunctionMapper(fm);
        try {
            expr = fac.createValueExpression(elContext, expression, expectedType);
        }
        catch (jakarta.el.ELException ex) {
            throw new ELException(ex);
        }
        return new ExpressionImpl(expr, this.pageContext);
    }

    public Object evaluate(String expression, Class expectedType, VariableResolver vResolver, FunctionMapper fMapper) throws ELException {
        Object value;
        ELContextImpl elContext = vResolver instanceof VariableResolverImpl ? (ELContextImpl)this.pageContext.getELContext() : new ELContextImpl(new ELResolverWrapper(vResolver));
        FunctionMapperWrapper fm = new FunctionMapperWrapper(fMapper);
        elContext.setFunctionMapper(fm);
        ExpressionFactory fac = ExpressionFactory.newInstance();
        try {
            ValueExpression expr = fac.createValueExpression(elContext, expression, expectedType);
            value = expr.getValue(elContext);
        }
        catch (jakarta.el.ELException ex) {
            throw new ELException(ex);
        }
        return value;
    }

    private static class ELResolverWrapper
    extends ELResolver {
        private VariableResolver vResolver;

        ELResolverWrapper(VariableResolver vResolver) {
            this.vResolver = vResolver;
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) throws jakarta.el.ELException {
            if (base == null) {
                context.setPropertyResolved(true);
                try {
                    return this.vResolver.resolveVariable(property.toString());
                }
                catch (ELException ex) {
                    throw new jakarta.el.ELException(ex);
                }
            }
            return null;
        }

        public Class getType(ELContext context, Object base, Object property) throws jakarta.el.ELException {
            return null;
        }

        @Override
        public void setValue(ELContext context, Object base, Object property, Object value) throws jakarta.el.ELException {
        }

        @Override
        public boolean isReadOnly(ELContext context, Object base, Object property) throws jakarta.el.ELException {
            return false;
        }

        @Override
        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return null;
        }

        @Override
        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return null;
        }
    }

    private static class FunctionMapperWrapper
    extends jakarta.el.FunctionMapper {
        private FunctionMapper mapper;

        FunctionMapperWrapper(FunctionMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public Method resolveFunction(String prefix, String localName) {
            return this.mapper.resolveFunction(prefix, localName);
        }
    }

    private static class ExpressionImpl
    extends Expression {
        private ValueExpression valueExpr;
        private PageContext pageContext;

        ExpressionImpl(ValueExpression valueExpr, PageContext pageContext) {
            this.valueExpr = valueExpr;
            this.pageContext = pageContext;
        }

        @Override
        public Object evaluate(VariableResolver vResolver) throws ELException {
            ELContext elContext = vResolver instanceof VariableResolverImpl ? this.pageContext.getELContext() : new ELContextImpl(new ELResolverWrapper(vResolver));
            try {
                return this.valueExpr.getValue(elContext);
            }
            catch (jakarta.el.ELException ex) {
                throw new ELException(ex);
            }
        }
    }
}

