/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import jakarta.servlet.jsp.tagext.FunctionInfo;
import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagExtraInfo;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import jakarta.servlet.jsp.tagext.TagLibraryValidator;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.glassfish.wasp.Constants;
import org.glassfish.wasp.JspCompilationContext;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.ErrorDispatcher;
import org.glassfish.wasp.compiler.JspUtil;
import org.glassfish.wasp.compiler.PageInfo;
import org.glassfish.wasp.compiler.ParserController;
import org.glassfish.wasp.compiler.TagConstants;
import org.glassfish.wasp.compiler.TagFileProcessor;
import org.glassfish.wasp.compiler.WaspTagInfo;
import org.glassfish.wasp.runtime.TldScanner;
import org.glassfish.wasp.xmlparser.ParserUtils;
import org.glassfish.wasp.xmlparser.TreeNode;

public class TagLibraryInfoImpl
extends TagLibraryInfo
implements TagConstants {
    private JspCompilationContext ctxt;
    private ErrorDispatcher err;
    private ParserController parserController;
    private PageInfo pageInfo;
    protected TagLibraryValidator tagLibraryValidator;

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        this.print("uri", this.uri, out);
        this.print("tagLibraryValidator", "" + this.tagLibraryValidator, out);
        for (i = 0; i < this.tags.length; ++i) {
            out.println(this.tags[i].toString());
        }
        for (i = 0; i < this.tagFiles.length; ++i) {
            out.println(this.tagFiles[i].toString());
        }
        for (i = 0; i < this.functions.length; ++i) {
            out.println(this.functions[i].toString());
        }
        return sw.toString();
    }

    private InputStream getResourceAsStream(String uri) throws WaspException {
        try {
            String real = this.ctxt.getRealPath(uri);
            if (real == null) {
                return this.ctxt.getResourceAsStream(uri);
            }
            return new FileInputStream(real);
        }
        catch (FileNotFoundException ex) {
            return this.ctxt.getResourceAsStream(uri);
        }
    }

    public TagLibraryInfoImpl(String prefix, String uri, TagLibraryInfoImpl delegate, PageInfo pageInfo) {
        super(prefix, uri);
        this.pageInfo = pageInfo;
        this.tagFiles = delegate.getTagFiles();
        this.functions = delegate.getFunctions();
        this.jspversion = delegate.getRequiredVersion();
        this.shortname = delegate.getShortName();
        this.urn = delegate.getReliableURN();
        this.info = delegate.getInfoString();
        this.tagLibraryValidator = delegate.getTagLibraryValidator();
        TagInfo[] otherTags = delegate.getTags();
        if (otherTags != null) {
            this.tags = new TagInfo[otherTags.length];
            for (int i = 0; i < otherTags.length; ++i) {
                this.tags[i] = new TagInfo(otherTags[i].getTagName(), otherTags[i].getTagClassName(), otherTags[i].getBodyContent(), otherTags[i].getInfoString(), this, otherTags[i].getTagExtraInfo(), otherTags[i].getAttributes(), otherTags[i].getDisplayName(), otherTags[i].getSmallIcon(), otherTags[i].getLargeIcon(), otherTags[i].getTagVariableInfos(), otherTags[i].hasDynamicAttributes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagLibraryInfoImpl(JspCompilationContext ctxt, ParserController pc, String prefix, String uriIn, String[] location, ErrorDispatcher err) throws WaspException {
        block21: {
            super(prefix, uriIn);
            this.ctxt = ctxt;
            this.parserController = pc;
            this.pageInfo = pc.getCompiler().getPageInfo();
            this.err = err;
            InputStream in = null;
            ZipFile jarFile = null;
            if (location == null) {
                location = this.generateTLDLocation(this.uri, ctxt);
            }
            try {
                if (!location[0].endsWith("jar")) {
                    try {
                        in = this.getResourceAsStream(location[0]);
                        if (in == null) {
                            throw new FileNotFoundException(location[0]);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        err.jspError("jsp.error.file.not.found", location[0]);
                    }
                    this.parseTLD(ctxt, location[0], in, null);
                    PageInfo pageInfo = ctxt.createCompiler(false).getPageInfo();
                    if (pageInfo != null) {
                        pageInfo.addDependant(location[0]);
                    }
                    break block21;
                }
                try {
                    URL jarFileUrl = new URL("jar:" + location[0] + "!/");
                    JarURLConnection conn = (JarURLConnection)jarFileUrl.openConnection();
                    conn.setUseCaches(false);
                    conn.connect();
                    jarFile = conn.getJarFile();
                    ZipEntry jarEntry = ((JarFile)jarFile).getEntry(location[1]);
                    in = ((JarFile)jarFile).getInputStream(jarEntry);
                    this.parseTLD(ctxt, location[0], in, jarFileUrl);
                }
                catch (Exception ex) {
                    err.jspError("jsp.error.tld.unable_to_read", location[0], location[1], ex.toString());
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public TagLibraryInfo[] getTagLibraryInfos() {
        TagLibraryInfo[] taglibs = null;
        Collection<TagLibraryInfo> c = this.pageInfo.getTaglibs();
        if (c != null && c.size() > 0) {
            taglibs = c.toArray(new TagLibraryInfo[0]);
        }
        return taglibs;
    }

    private void parseTLD(JspCompilationContext ctxt, String uri, InputStream in, URL jarFileUrl) throws WaspException {
        ArrayList<TagInfo> tagVector = new ArrayList<TagInfo>();
        ArrayList<TagFileInfo> tagFileVector = new ArrayList<TagFileInfo>();
        HashMap<String, FunctionInfo> functionTable = new HashMap<String, FunctionInfo>();
        boolean blockExternal = Boolean.parseBoolean(ctxt.getServletContext().getInitParameter("org.glassfish.wasp.XML_BLOCK_EXTERNAL"));
        ParserUtils pu = new ParserUtils(blockExternal);
        TreeNode tld = pu.parseXMLDocument(uri, in, ctxt.getOptions().isValidationEnabled());
        this.jspversion = tld.findAttribute("version");
        Iterator<TreeNode> list = tld.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("tlibversion".equals(tname) || "tlib-version".equals(tname)) {
                this.tlibversion = element.getBody();
                continue;
            }
            if ("jspversion".equals(tname) || "jsp-version".equals(tname)) {
                this.jspversion = element.getBody();
                continue;
            }
            if ("shortname".equals(tname) || "short-name".equals(tname)) {
                this.shortname = element.getBody();
                continue;
            }
            if ("uri".equals(tname)) {
                this.urn = element.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                this.info = element.getBody();
                continue;
            }
            if ("validator".equals(tname)) {
                this.tagLibraryValidator = this.createValidator(element);
                continue;
            }
            if ("tag".equals(tname)) {
                tagVector.add(this.createTagInfo(element, this.jspversion));
                continue;
            }
            if ("tag-file".equals(tname)) {
                TagFileInfo tagFileInfo = this.createTagFileInfo(element, uri, jarFileUrl);
                tagFileVector.add(tagFileInfo);
                continue;
            }
            if ("function".equals(tname)) {
                FunctionInfo funcInfo = this.createFunctionInfo(element);
                String funcName = funcInfo.getName();
                if (functionTable.containsKey(funcName)) {
                    this.err.jspError("jsp.error.tld.fn.duplicate.name", funcName, uri);
                }
                functionTable.put(funcName, funcInfo);
                continue;
            }
            if ("display-name".equals(tname) || "small-icon".equals(tname) || "large-icon".equals(tname) || "listener".equals(tname) || "taglib-extension".equals(tname)) continue;
            this.err.jspError("jsp.error.unknown.element.in.taglib", tname);
        }
        if (this.tlibversion == null) {
            this.err.jspError("jsp.error.tld.mandatory.element.missing", "tlib-version");
        }
        if (this.jspversion == null) {
            this.err.jspError("jsp.error.tld.mandatory.element.missing", "jsp-version");
        }
        this.tags = tagVector.toArray(new TagInfo[0]);
        this.tagFiles = tagFileVector.toArray(new TagFileInfo[0]);
        this.functions = new FunctionInfo[functionTable.size()];
        int i = 0;
        for (FunctionInfo funcInfo : functionTable.values()) {
            this.functions[i++] = funcInfo;
        }
    }

    private String[] generateTLDLocation(String uri, JspCompilationContext ctxt) throws WaspException {
        int uriType = TldScanner.uriType(uri);
        if (uriType == 0) {
            this.err.jspError("jsp.error.taglibDirective.absUriCannotBeResolved", uri);
        } else if (uriType == 2) {
            uri = ctxt.resolveRelativeUri(uri);
        }
        String[] location = new String[2];
        location[0] = uri;
        if (location[0].endsWith("jar")) {
            URL url = null;
            try {
                url = ctxt.getResource(location[0]);
            }
            catch (Exception ex) {
                this.err.jspError("jsp.error.tld.unable_to_get_jar", location[0], ex.toString());
            }
            if (url == null) {
                this.err.jspError("jsp.error.tld.missing_jar", location[0]);
            }
            location[0] = url.toString();
            location[1] = "META-INF/taglib.tld";
        }
        return location;
    }

    private TagInfo createTagInfo(TreeNode elem, String jspVersion) throws WaspException {
        String tagName = null;
        String tagClassName = null;
        String teiClassName = null;
        String bodycontent = "JSP";
        String info = null;
        String displayName = null;
        String smallIcon = null;
        String largeIcon = null;
        boolean dynamicAttributes = false;
        ArrayList<TagAttributeInfo> attributeVector = new ArrayList<TagAttributeInfo>();
        ArrayList<TagVariableInfo> variableVector = new ArrayList<TagVariableInfo>();
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                tagName = element.getBody();
                continue;
            }
            if ("tagclass".equals(tname) || "tag-class".equals(tname)) {
                tagClassName = element.getBody();
                continue;
            }
            if ("teiclass".equals(tname) || "tei-class".equals(tname)) {
                teiClassName = element.getBody();
                continue;
            }
            if ("bodycontent".equals(tname) || "body-content".equals(tname)) {
                bodycontent = element.getBody();
                if (bodycontent != null) continue;
                bodycontent = "null";
                continue;
            }
            if ("display-name".equals(tname)) {
                displayName = element.getBody();
                continue;
            }
            if ("small-icon".equals(tname)) {
                smallIcon = element.getBody();
                continue;
            }
            if ("large-icon".equals(tname)) {
                largeIcon = element.getBody();
                continue;
            }
            if ("icon".equals(tname)) {
                TreeNode icon = element.findChild("small-icon");
                if (icon != null) {
                    smallIcon = icon.getBody();
                }
                if ((icon = element.findChild("large-icon")) == null) continue;
                largeIcon = icon.getBody();
                continue;
            }
            if ("info".equals(tname) || "description".equals(tname)) {
                info = element.getBody();
                continue;
            }
            if ("variable".equals(tname)) {
                variableVector.add(this.createVariable(element));
                continue;
            }
            if ("attribute".equals(tname)) {
                attributeVector.add(this.createAttribute(element, jspVersion));
                continue;
            }
            if ("dynamic-attributes".equals(tname)) {
                dynamicAttributes = JspUtil.booleanValue(element.getBody());
                continue;
            }
            if ("example".equals(tname) || "tag-extension".equals(tname)) continue;
            this.err.jspError("jsp.error.unknown.element.in.tag", tname);
        }
        Double jspVersionDouble = Double.valueOf(this.jspversion);
        if (!(Double.compare(jspVersionDouble, Constants.JSP_VERSION_2_0) < 0 || bodycontent.equals("JSP") || bodycontent.equals("empty") || bodycontent.equals("tagdependent") || bodycontent.equals("scriptless"))) {
            this.err.jspError("jsp.error.tld.badbodycontent", bodycontent, tagName);
        }
        TagExtraInfo tei = null;
        if (teiClassName != null && !teiClassName.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiClassName);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError("jsp.error.teiclass.instantiation", teiClassName, e);
            }
        }
        TagAttributeInfo[] tagAttributeInfo = attributeVector.toArray(new TagAttributeInfo[0]);
        TagVariableInfo[] tagVariableInfos = variableVector.toArray(new TagVariableInfo[0]);
        TagInfo taginfo = new TagInfo(tagName, tagClassName, bodycontent, info, this, tei, tagAttributeInfo, displayName, smallIcon, largeIcon, tagVariableInfos, dynamicAttributes);
        return taginfo;
    }

    private TagFileInfo createTagFileInfo(TreeNode elem, String uri, URL jarFileUrl) throws WaspException {
        String name = null;
        String path = null;
        String description = null;
        String displayName = null;
        String icon = null;
        boolean checkConflict = false;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode child = list.next();
            String tname = child.getName();
            if ("name".equals(tname)) {
                name = child.getBody();
                continue;
            }
            if ("path".equals(tname)) {
                path = child.getBody();
                continue;
            }
            if ("description".equals(tname)) {
                checkConflict = true;
                description = child.getBody();
                continue;
            }
            if ("display-name".equals(tname)) {
                checkConflict = true;
                displayName = child.getBody();
                continue;
            }
            if ("icon".equals(tname)) {
                checkConflict = true;
                icon = child.getBody();
                continue;
            }
            if ("example".equals(tname) || "tag-extension".equals(tname)) continue;
            this.err.jspError("jsp.error.unknown.element.in.tagfile", tname);
        }
        if (path.startsWith("/META-INF/tags")) {
            if (jarFileUrl != null) {
                this.ctxt.getTagFileJarUrls().put(path, jarFileUrl);
            }
        } else if (!path.startsWith("/WEB-INF/tags")) {
            this.err.jspError("jsp.error.tagfile.illegalPath", path);
        }
        WaspTagInfo tagInfo = (WaspTagInfo)TagFileProcessor.parseTagFileDirectives(this.parserController, name, path, this);
        if (checkConflict) {
            String tstring = tagInfo.getInfoString();
            if (tstring != null && !"".equals(tstring)) {
                description = tstring;
            }
            if ((tstring = tagInfo.getDisplayName()) != null && !"".equals(tstring)) {
                displayName = tstring;
            }
            if ((tstring = tagInfo.getSmallIcon()) != null && !"".equals(tstring)) {
                icon = tstring;
            }
            tagInfo = new WaspTagInfo(tagInfo.getTagName(), tagInfo.getTagClassName(), tagInfo.getBodyContent(), description, tagInfo.getTagLibrary(), tagInfo.getTagExtraInfo(), tagInfo.getAttributes(), displayName, icon, tagInfo.getLargeIcon(), tagInfo.getTagVariableInfos(), tagInfo.getDynamicAttributesMapName());
        }
        return new TagFileInfo(name, path, tagInfo);
    }

    private TagAttributeInfo createAttribute(TreeNode elem, String jspVersion) throws WaspException {
        String name = null;
        Object type2 = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean isFragment = false;
        boolean deferredValue = false;
        boolean deferredMethod = false;
        String expectedType = "java.lang.Object";
        String methodSignature = "void method()";
        String description = null;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            String s;
            TreeNode element2;
            Iterator<TreeNode> iter;
            String s2;
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("required".equals(tname)) {
                s2 = element.getBody();
                if (s2 == null) continue;
                required = JspUtil.booleanValue(s2);
                continue;
            }
            if ("rtexprvalue".equals(tname)) {
                s2 = element.getBody();
                if (s2 == null) continue;
                rtexprvalue = JspUtil.booleanValue(s2);
                continue;
            }
            if ("type".equals(tname)) {
                type2 = element.getBody();
                if (!"1.2".equals(jspVersion) || !((String)type2).equals("Boolean") && !((String)type2).equals("Byte") && !((String)type2).equals("Character") && !((String)type2).equals("Double") && !((String)type2).equals("Float") && !((String)type2).equals("Integer") && !((String)type2).equals("Long") && !((String)type2).equals("Object") && !((String)type2).equals("Short") && !((String)type2).equals("String")) continue;
                type2 = "java.lang." + (String)type2;
                continue;
            }
            if ("fragment".equals(tname)) {
                s2 = element.getBody();
                if (s2 == null) continue;
                isFragment = JspUtil.booleanValue(s2);
                continue;
            }
            if ("description".equals(tname)) {
                description = element.getBody();
                continue;
            }
            if ("deferred-value".equals(tname)) {
                deferredValue = true;
                iter = element.findChildren();
                if (!iter.hasNext()) continue;
                element2 = iter.next();
                tname = element2.getName();
                if ("type".equals(tname)) {
                    s = element2.getBody();
                    if (s == null) continue;
                    expectedType = s;
                    continue;
                }
                this.err.jspError("jsp.error.unknown.element.in.attribute", tname);
                continue;
            }
            if ("deferred-method".equals(tname)) {
                deferredMethod = true;
                iter = element.findChildren();
                if (!iter.hasNext()) continue;
                element2 = iter.next();
                tname = element2.getName();
                if ("method-signature".equals(tname)) {
                    s = element2.getBody();
                    if (s == null) continue;
                    methodSignature = s;
                    continue;
                }
                this.err.jspError("jsp.error.unknown.element.in.attribute", tname);
                continue;
            }
            this.err.jspError("jsp.error.unknown.element.in.attribute", tname);
        }
        if (isFragment) {
            type2 = "jakarta.servlet.jsp.tagext.JspFragment";
            rtexprvalue = true;
        }
        if (!rtexprvalue) {
            type2 = "java.lang.String";
        }
        return new TagAttributeInfo(name, required, (String)type2, rtexprvalue, isFragment, description, deferredValue, deferredMethod, expectedType, methodSignature);
    }

    private TagVariableInfo createVariable(TreeNode elem) throws WaspException {
        String nameGiven = null;
        String nameFromAttribute = null;
        String className = "java.lang.String";
        boolean declare = true;
        int scope = 0;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            String s;
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name-given".equals(tname)) {
                nameGiven = element.getBody();
                continue;
            }
            if ("name-from-attribute".equals(tname)) {
                nameFromAttribute = element.getBody();
                continue;
            }
            if ("variable-class".equals(tname)) {
                className = element.getBody();
                continue;
            }
            if ("declare".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                declare = JspUtil.booleanValue(s);
                continue;
            }
            if ("scope".equals(tname)) {
                s = element.getBody();
                if (s == null) continue;
                if ("NESTED".equals(s)) {
                    scope = 0;
                    continue;
                }
                if ("AT_BEGIN".equals(s)) {
                    scope = 1;
                    continue;
                }
                if (!"AT_END".equals(s)) continue;
                scope = 2;
                continue;
            }
            if ("description".equals(tname)) continue;
            this.err.jspError("jsp.error.unknown.element.in.variable", tname);
        }
        return new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope);
    }

    private TagLibraryValidator createValidator(TreeNode elem) throws WaspException {
        String validatorClass = null;
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("validator-class".equals(tname)) {
                validatorClass = element.getBody();
                continue;
            }
            if ("init-param".equals(tname)) {
                String[] initParam = this.createInitParam(element);
                initParams.put(initParam[0], initParam[1]);
                continue;
            }
            if ("description".equals(tname)) continue;
            this.err.jspError("jsp.error.unknown.element.in.validator", tname);
        }
        TagLibraryValidator tlv = null;
        if (validatorClass != null && !validatorClass.equals("")) {
            try {
                Class<?> tlvClass = this.ctxt.getClassLoader().loadClass(validatorClass);
                tlv = (TagLibraryValidator)tlvClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError("jsp.error.tlvclass.instantiation", validatorClass, e);
            }
        }
        if (tlv != null) {
            tlv.setInitParameters(initParams);
        }
        return tlv;
    }

    private String[] createInitParam(TreeNode elem) throws WaspException {
        String[] initParam = new String[2];
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("param-name".equals(tname)) {
                initParam[0] = element.getBody();
                continue;
            }
            if ("param-value".equals(tname)) {
                initParam[1] = element.getBody();
                continue;
            }
            if ("description".equals(tname)) continue;
            this.err.jspError("jsp.error.unknown.element.in.initParam", tname);
        }
        return initParam;
    }

    private FunctionInfo createFunctionInfo(TreeNode elem) throws WaspException {
        String name = null;
        String klass = null;
        String signature = null;
        Iterator<TreeNode> list = elem.findChildren();
        while (list.hasNext()) {
            TreeNode element = list.next();
            String tname = element.getName();
            if ("name".equals(tname)) {
                name = element.getBody();
                continue;
            }
            if ("function-class".equals(tname)) {
                klass = element.getBody();
                continue;
            }
            if ("function-signature".equals(tname)) {
                signature = element.getBody();
                continue;
            }
            if ("display-name".equals(tname) || "small-icon".equals(tname) || "large-icon".equals(tname) || "description".equals(tname) || "example".equals(tname)) continue;
            this.err.jspError("jsp.error.unknown.element.in.function", tname);
        }
        return new FunctionInfo(name, klass, signature);
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    public ValidationMessage[] validate(PageData thePage) {
        TagLibraryValidator tlv = this.getTagLibraryValidator();
        if (tlv == null) {
            return null;
        }
        Object uri = this.getURI();
        if (((String)uri).startsWith("/")) {
            uri = "urn:jsptld:" + (String)uri;
        }
        ValidationMessage[] messages = tlv.validate(this.getPrefixString(), (String)uri, thePage);
        tlv.release();
        return messages;
    }
}

