/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Optional;
import org.glassfish.soteria.servlet.HttpStorageController;

public class SessionController
implements HttpStorageController {
    private final HttpServletRequest request;

    public SessionController(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public HttpStorageController store(String name, String value, Integer maxAge) {
        this.request.getSession().setAttribute(name, value);
        return this;
    }

    public Optional<Object> get(String name) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return Optional.ofNullable(session.getAttribute(name));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getAsString(String name) {
        return this.get(name).map(Object::toString);
    }

    @Override
    public void remove(String name) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }
}

