/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.domain;

import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.security.enterprise.identitystore.openid.Claims;
import jakarta.security.enterprise.identitystore.openid.JwtClaims;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class NimbusJwtClaims
implements JwtClaims {
    private final JWTClaimsSet claimsSet;

    NimbusJwtClaims(JWTClaimsSet claimsSet) {
        this.claimsSet = claimsSet;
    }

    @Override
    public Optional<String> getStringClaim(String name) {
        try {
            return Optional.ofNullable(this.claimsSet.getStringClaim(name));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + name + " as string", e);
        }
    }

    @Override
    public Optional<Instant> getNumericDateClaim(String name) {
        try {
            return Optional.ofNullable(this.claimsSet.getDateClaim(name)).map(Date::toInstant);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + name + " as numeric date", e);
        }
    }

    @Override
    public List<String> getArrayStringClaim(String name) {
        Object audValue = this.claimsSet.getClaim(name);
        if (audValue == null) {
            return Collections.emptyList();
        }
        if (audValue instanceof String) {
            return Collections.singletonList((String)audValue);
        }
        try {
            return this.claimsSet.getStringListClaim(name);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + name + " as a string array", e);
        }
    }

    @Override
    public OptionalInt getIntClaim(String name) {
        Integer value;
        try {
            value = this.claimsSet.getIntegerClaim(name);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + name + " as number");
        }
        return value == null ? OptionalInt.empty() : OptionalInt.of(value);
    }

    @Override
    public OptionalLong getLongClaim(String name) {
        Long value;
        try {
            value = this.claimsSet.getLongClaim(name);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + name + " as number");
        }
        return value == null ? OptionalLong.empty() : OptionalLong.of(value);
    }

    @Override
    public OptionalDouble getDoubleClaim(String name) {
        Double value;
        try {
            value = this.claimsSet.getDoubleClaim(name);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + name + " as number");
        }
        return value == null ? OptionalDouble.empty() : OptionalDouble.of(value);
    }

    @Override
    public Optional<Claims> getNested(String name) {
        return Optional.empty();
    }

    public String toString() {
        return this.claimsSet.toString();
    }

    static JwtClaims ifPresent(JWTClaimsSet claimsSet) {
        return claimsSet == null ? JwtClaims.NONE : new NimbusJwtClaims(claimsSet);
    }
}

