/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.domain;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.JwtClaims;
import java.text.ParseException;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.glassfish.soteria.mechanisms.openid.domain.NimbusJwtClaims;

public class IdentityTokenImpl
implements IdentityToken {
    private final String token;
    private final long tokenMinValidity;
    private final JWT tokenJWT;
    private final JWTClaimsSet claims;

    public IdentityTokenImpl(String token, long tokenMinValidity) {
        this.token = token;
        this.tokenMinValidity = tokenMinValidity;
        try {
            this.tokenJWT = JWTParser.parse(token);
            this.claims = this.tokenJWT.getJWTClaimsSet();
        }
        catch (ParseException ex) {
            throw new IllegalStateException("Error in parsing the Token", ex);
        }
    }

    private IdentityTokenImpl(JWT token, JWTClaimsSet verifiedClaims, long tokenMinValidity) {
        this.token = token.getParsedString();
        this.tokenJWT = token;
        this.claims = verifiedClaims;
        this.tokenMinValidity = tokenMinValidity;
    }

    public JWT getTokenJWT() {
        return this.tokenJWT;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public JwtClaims getJwtClaims() {
        return NimbusJwtClaims.ifPresent(this.claims);
    }

    @Override
    public boolean isExpired() {
        Optional<Instant> expirationTime = this.getJwtClaims().getExpirationTime();
        if (!expirationTime.isPresent()) {
            throw new IllegalStateException("Missing expiration time (exp) claim in identity token");
        }
        boolean expired = System.currentTimeMillis() + this.tokenMinValidity > expirationTime.get().toEpochMilli();
        return expired;
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims.getClaims();
    }

    public String toString() {
        return this.token;
    }

    public IdentityToken withClaims(JWTClaimsSet verifiedClaims) {
        return new IdentityTokenImpl(this.tokenJWT, verifiedClaims, this.tokenMinValidity);
    }
}

