/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.glassfish.soteria.Utils;

@ApplicationScoped
public class ProviderMetadataController {
    private static final String WELL_KNOWN_PREFIX = "/.well-known/openid-configuration";
    private final Map<String, JsonObject> providerDocuments = new HashMap<String, JsonObject>();

    public JsonObject getDocument(String providerURI) {
        if (Objects.isNull(this.providerDocuments.get(providerURI))) {
            if (Utils.isEmpty((String)providerURI)) {
                this.providerDocuments.put((String)providerURI, Json.createObjectBuilder().build());
            } else {
                if (((String)providerURI).endsWith("/")) {
                    providerURI = ((String)providerURI).substring(0, ((String)providerURI).length() - 1);
                }
                if (!((String)providerURI).endsWith(WELL_KNOWN_PREFIX)) {
                    providerURI = (String)providerURI + WELL_KNOWN_PREFIX;
                }
                Client client = ClientBuilder.newClient();
                WebTarget target = client.target((String)providerURI);
                Response response = target.request().accept("application/json").get();
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    String responseBody = response.readEntity(String.class);
                    try (JsonReader reader = Json.createReader(new StringReader(responseBody));){
                        JsonObject responseObject = reader.readObject();
                        this.providerDocuments.put((String)providerURI, responseObject);
                    }
                } else {
                    throw new IllegalStateException(String.format("Unable to retrieve OpenID Provider's [%s] configuration document, HTTP respons code : [%s] ", providerURI, response.getStatus()));
                }
            }
        }
        return this.providerDocuments.get(providerURI);
    }
}

