/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.identitystores;

import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStorePermission;
import jakarta.security.enterprise.identitystore.PasswordHash;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.soteria.cdi.AnnotationELPProcessor;
import org.glassfish.soteria.cdi.CdiUtils;
import org.glassfish.soteria.identitystores.IdentityStoreConfigurationException;
import org.glassfish.soteria.identitystores.IdentityStoreRuntimeException;

public class DatabaseIdentityStore
implements IdentityStore {
    private final DatabaseIdentityStoreDefinition dataBaseIdentityStoreDefinition;
    private final Set<IdentityStore.ValidationType> validationTypes;
    private final PasswordHash hashAlgorithm;

    protected DatabaseIdentityStore() {
        this.dataBaseIdentityStoreDefinition = null;
        this.validationTypes = null;
        this.hashAlgorithm = null;
    }

    public DatabaseIdentityStore(DatabaseIdentityStoreDefinition dataBaseIdentityStoreDefinition) {
        this.dataBaseIdentityStoreDefinition = dataBaseIdentityStoreDefinition;
        this.validationTypes = Collections.unmodifiableSet(new HashSet<IdentityStore.ValidationType>(Arrays.asList(dataBaseIdentityStoreDefinition.useFor())));
        this.hashAlgorithm = CdiUtils.getBeanReference(dataBaseIdentityStoreDefinition.hashAlgorithm(), new Annotation[0]);
        this.hashAlgorithm.initialize(Collections.unmodifiableMap(Arrays.stream(dataBaseIdentityStoreDefinition.hashAlgorithmParameters()).flatMap(s -> this.toStream(AnnotationELPProcessor.evalImmediate(s, s))).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> AnnotationELPProcessor.evalImmediate(s.substring(s.indexOf(61) + 1))))));
    }

    @Override
    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof UsernamePasswordCredential) {
            return this.validate((UsernamePasswordCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    public CredentialValidationResult validate(UsernamePasswordCredential usernamePasswordCredential) {
        DataSource dataSource = this.getDataSource();
        List<String> passwords = this.executeQuery(dataSource, this.dataBaseIdentityStoreDefinition.callerQuery(), usernamePasswordCredential.getCaller());
        if (passwords.isEmpty()) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        if (this.hashAlgorithm.verify(usernamePasswordCredential.getPassword().getValue(), passwords.get(0))) {
            Set<String> groups = Collections.emptySet();
            if (this.validationTypes.contains((Object)IdentityStore.ValidationType.PROVIDE_GROUPS)) {
                groups = new HashSet<String>(this.executeQuery(dataSource, this.dataBaseIdentityStoreDefinition.groupsQuery(), usernamePasswordCredential.getCaller()));
            }
            return new CredentialValidationResult(new CallerPrincipal(usernamePasswordCredential.getCaller()), groups);
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    @Override
    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new IdentityStorePermission("getGroups"));
        }
        DataSource dataSource = this.getDataSource();
        return new HashSet<String>(this.executeQuery(dataSource, this.dataBaseIdentityStoreDefinition.groupsQuery(), validationResult.getCallerPrincipal().getName()));
    }

    private List<String> executeQuery(DataSource dataSource, String query, String parameter) {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, parameter);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new IdentityStoreConfigurationException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int priority() {
        return this.dataBaseIdentityStoreDefinition.priority();
    }

    @Override
    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationTypes;
    }

    private Stream<String> toStream(Object raw) {
        if (raw instanceof String[]) {
            return Arrays.stream((String[])raw);
        }
        if (raw instanceof Stream) {
            return ((Stream)raw).map(String::toString);
        }
        return Arrays.asList(raw.toString()).stream();
    }

    private DataSource getDataSource() {
        try {
            return (DataSource)CdiUtils.jndiLookup(this.dataBaseIdentityStoreDefinition.dataSourceLookup());
        }
        catch (NamingException e) {
            throw new IdentityStoreRuntimeException("JNDI lookup failed for DataSource " + this.dataBaseIdentityStoreDefinition.dataSourceLookup(), e);
        }
    }
}

