/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import jakarta.el.ELProcessor;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.AnyAnnotationLiteral;

public class CdiUtils {
    public static <A extends Annotation> Optional<A> getAnnotation(BeanManager beanManager, Annotated annotated, Class<A> annotationType) {
        annotated.getAnnotation(annotationType);
        if (annotated.getAnnotations().isEmpty()) {
            return Optional.empty();
        }
        if (annotated.isAnnotationPresent(annotationType)) {
            return Optional.of(annotated.getAnnotation(annotationType));
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(annotated.getAnnotations());
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return Optional.empty();
    }

    public static void addAnnotatedTypes(BeforeBeanDiscovery beforeBean, BeanManager beanManager, Class<?> ... types) {
        for (Class<?> type2 : types) {
            beforeBean.addAnnotatedType(beanManager.createAnnotatedType(type2), "Soteria " + type2.getName());
        }
    }

    public static <A extends Annotation> Optional<A> getAnnotation(BeanManager beanManager, Class<?> annotatedClass, Class<A> annotationType) {
        if (annotatedClass.isAnnotationPresent(annotationType)) {
            return Optional.of(annotatedClass.getAnnotation(annotationType));
        }
        LinkedList<Annotation> annotations = new LinkedList<Annotation>(Arrays.asList(annotatedClass.getAnnotations()));
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return Optional.of((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return Optional.empty();
    }

    public static BeanManager getBeanManager() throws IllegalStateException {
        try {
            return (BeanManager)CdiUtils.jndiLookup("java:comp/BeanManager", "java:comp/env/BeanManager");
        }
        catch (NamingException e) {
            throw new IllegalStateException("The CDI Bean Manager is not available.", e);
        }
    }

    public static <T> T getBeanReference(Class<T> type2, Annotation ... qualifiers) {
        return type2.cast(CdiUtils.getBeanReferenceByType(CdiUtils.getBeanManager(), type2, qualifiers));
    }

    public static <T> T getBeanReference(BeanManager beanManager, Class<T> type2, Annotation ... qualifiers) {
        return type2.cast(CdiUtils.getBeanReferenceByType(beanManager, type2, qualifiers));
    }

    public static Object getBeanReferenceByType(BeanManager beanManager, Type type2, Annotation ... qualifiers) {
        Object beanReference = null;
        Bean bean = beanManager.resolve(beanManager.getBeans(type2, qualifiers));
        if (bean != null) {
            beanReference = beanManager.getReference(bean, type2, beanManager.createCreationalContext(bean));
        }
        return beanReference;
    }

    private static <T> T getContextualReference(Class<T> type2, BeanManager beanManager, Set<Bean<?>> beans) {
        Object beanReference = null;
        Bean bean = beanManager.resolve(beans);
        if (bean != null) {
            beanReference = beanManager.getReference(bean, type2, beanManager.createCreationalContext(bean));
        }
        return (T)beanReference;
    }

    public static <T> List<T> getBeanReferencesByType(Class<T> type2, boolean optional) {
        BeanManager beanManager = CdiUtils.getBeanManager();
        Set<Bean<?>> beans = CdiUtils.getBeanDefinitions(type2, optional, beanManager);
        ArrayList<T> result = new ArrayList<T>(beans.size());
        for (Bean<?> bean : beans) {
            result.add(CdiUtils.getContextualReference(type2, beanManager, Collections.singleton(bean)));
        }
        return result;
    }

    public static ELProcessor getELProcessor(ELProcessor elProcessor) {
        if (elProcessor != null) {
            return elProcessor;
        }
        return CdiUtils.getELProcessor();
    }

    public static ELProcessor getELProcessor() {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(CdiUtils.getBeanManager().getELResolver());
        return elProcessor;
    }

    private static <T> Set<Bean<?>> getBeanDefinitions(Class<T> type2, boolean optional, BeanManager beanManager) {
        Set<Bean<?>> beans = beanManager.getBeans(type2, new AnyAnnotationLiteral());
        if (!Utils.isEmpty(beans)) {
            return beans;
        }
        if (optional) {
            return Collections.emptySet();
        }
        throw new IllegalStateException("Could not find beans for Type=" + type2);
    }

    public static <T> T jndiLookup(String ... names) throws NamingException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            NamingException exceptionCollector = new NamingException(String.join((CharSequence)", ", names));
            for (String name : names) {
                Object object;
                try {
                    Object found = context.lookup(name);
                    if (found == null) continue;
                    object = found;
                }
                catch (NamingException e) {
                    exceptionCollector.addSuppressed(e);
                }
                return (T)object;
            }
            throw exceptionCollector;
        }
        finally {
            CdiUtils.close(context);
        }
    }

    private static void close(InitialContext context) {
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends Throwable> boolean is(Throwable exception, Class<T> type2) {
        for (Throwable unwrappedException = exception; unwrappedException != null; unwrappedException = unwrappedException.getCause()) {
            if (!type2.isInstance(unwrappedException)) continue;
            return true;
        }
        return false;
    }
}

