/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria;

import jakarta.annotation.PostConstruct;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.SecurityContext;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import org.glassfish.soteria.authorization.spi.CallerDetailsResolver;
import org.glassfish.soteria.authorization.spi.ResourceAccessResolver;
import org.glassfish.soteria.authorization.spi.impl.JaccResourceAccessResolver;
import org.glassfish.soteria.authorization.spi.impl.ReflectionAndJaccCallerDetailsResolver;
import org.glassfish.soteria.mechanisms.jaspic.Jaspic;

public class SecurityContextImpl
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private CallerDetailsResolver callerDetailsResolver;
    private ResourceAccessResolver resourceAccessResolver;

    @PostConstruct
    public void init() {
        this.callerDetailsResolver = new ReflectionAndJaccCallerDetailsResolver();
        this.resourceAccessResolver = new JaccResourceAccessResolver();
    }

    @Override
    public Principal getCallerPrincipal() {
        return this.callerDetailsResolver.getCallerPrincipal();
    }

    @Override
    public <T extends Principal> Set<T> getPrincipalsByType(Class<T> pType) {
        return this.callerDetailsResolver.getPrincipalsByType(pType);
    }

    @Override
    public boolean isCallerInRole(String role) {
        return this.callerDetailsResolver.isCallerInRole(role);
    }

    public Set<String> getAllDeclaredCallerRoles() {
        return this.callerDetailsResolver.getAllDeclaredCallerRoles();
    }

    @Override
    public boolean hasAccessToWebResource(String resource, String ... methods) {
        return this.resourceAccessResolver.hasAccessToWebResource(resource, methods);
    }

    @Override
    public AuthenticationStatus authenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationParameters parameters) {
        try {
            if (Jaspic.authenticate(request, response, parameters)) {
                return AuthenticationStatus.SUCCESS;
            }
            return Jaspic.getLastAuthenticationStatus(request);
        }
        catch (IllegalArgumentException e) {
            return AuthenticationStatus.SEND_FAILURE;
        }
    }
}

