/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.common;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.security.services.common.Secure;
import org.glassfish.security.services.common.SecurityAccessValidationService;

public class SecurityAccessFilter
implements Filter {
    private static final String SYS_PROP_JAVA_SEC_POLICY = "java.security.policy";
    private static final Logger LOG = SecurityAccessValidationService._theLog;
    private static boolean javaPolicySet = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            Boolean rtn = Boolean.FALSE;
            String wlsName = System.getProperty(SecurityAccessFilter.SYS_PROP_JAVA_SEC_POLICY);
            if (wlsName != null && !wlsName.isEmpty()) {
                rtn = Boolean.TRUE;
            }
            return rtn;
        }
    });

    @Override
    public boolean matches(Descriptor d) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Descripter: " + String.valueOf(d));
        }
        if (!javaPolicySet) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("java security policy is not set, so no validation for security servies.");
            }
            return false;
        }
        if (d == null) {
            return false;
        }
        Set<String> qualifiers = d.getQualifiers();
        if (qualifiers != null && qualifiers.size() != 0) {
            for (String s : qualifiers) {
                if (!Secure.class.getCanonicalName().equals(s)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("The instance is annotated with 'Secure': " + s);
                }
                return true;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("The instance has no 'Secure' annotated ");
        }
        return false;
    }
}

