/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.mail.annotation.handler;

import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.annotation.handlers.ResourceAnnotationControl;
import jakarta.mail.MailSessionDefinition;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.Set;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=MailSessionDefinition.class)
public class MailSessionDefinitionHandler
extends AbstractResourceHandler {
    private static final ResourceAnnotationControl CTRL = new ResourceAnnotationControl(MailSessionDefinition.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        MailSessionDefinition mailSessionDefnAn = (MailSessionDefinition)ainfo.getAnnotation();
        return this.processAnnotation(mailSessionDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(MailSessionDefinition mailSessionDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            MailSessionDescriptor desc;
            if (!CTRL.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set<ResourceDescriptor> mailSessionDescs = context.getResourceDescriptors(JavaEEResourceType.MSD);
            if (this.isDefinitionAlreadyPresent(mailSessionDescs, desc = this.createDescriptor(mailSessionDefnAn))) {
                this.merge(mailSessionDescs, mailSessionDefnAn);
                continue;
            }
            mailSessionDescs.add(desc);
        }
        return this.getDefaultProcessedResult();
    }

    private MailSessionDescriptor createDescriptor(MailSessionDefinition defn) {
        MailSessionDescriptor desc = new MailSessionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        if (defn.description() != null && !defn.description().isEmpty()) {
            desc.setDescription(defn.description());
        }
        if (defn.storeProtocol() != null && !defn.storeProtocol().isEmpty()) {
            desc.setStoreProtocol(defn.storeProtocol());
        }
        if (defn.transportProtocol() != null && !defn.transportProtocol().isEmpty()) {
            desc.setTransportProtocol(defn.transportProtocol());
        }
        if (defn.host() != null && !defn.host().isEmpty()) {
            desc.setHost(defn.host());
        }
        if (defn.user() != null && !defn.user().isEmpty()) {
            desc.setUser(defn.user());
        }
        if (defn.password() != null) {
            desc.setPassword(defn.password());
        }
        if (defn.from() != null && !defn.from().isEmpty()) {
            desc.setFrom(defn.from());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf(61);
                    if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index);
                    String value = property.substring(index + 1);
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> mailSessionDescs, MailSessionDescriptor mailSessionDesc) {
        boolean result = false;
        for (ResourceDescriptor msDesc : mailSessionDescs) {
            if (!msDesc.equals(mailSessionDesc)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void merge(Set<ResourceDescriptor> mailSessionDescs, MailSessionDefinition mailSessionDefn) {
        for (ResourceDescriptor orgDesc : mailSessionDescs) {
            MailSessionDescriptor desc = (MailSessionDescriptor)orgDesc;
            if (!desc.getName().equals(mailSessionDefn.name())) continue;
            if (desc.getDescription() == null && mailSessionDefn.description() != null && !mailSessionDefn.description().isEmpty()) {
                desc.setDescription(mailSessionDefn.description());
            }
            if (desc.getStoreProtocol() == null) {
                desc.setStoreProtocol(mailSessionDefn.storeProtocol());
            }
            if (desc.getTransportProtocol() == null) {
                desc.setTransportProtocol(mailSessionDefn.transportProtocol());
            }
            if (desc.getHost() == null) {
                desc.setHost(mailSessionDefn.host());
            }
            if (desc.getUser() == null && mailSessionDefn.user() != null && !mailSessionDefn.user().isEmpty()) {
                desc.setUser(mailSessionDefn.user());
            }
            if (desc.getPassword() == null && mailSessionDefn.password() != null) {
                desc.setPassword(mailSessionDefn.password());
            }
            if (desc.getFrom() == null) {
                desc.setFrom(mailSessionDefn.from());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = mailSessionDefn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf("=");
                if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index);
                String value = property.substring(index + 1);
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }
}

