/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.naming;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.naming.ApplicationScopedResourceBinding;
import org.glassfish.resourcebase.resources.naming.ModuleScopedResourceBinding;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

@Service
public final class ResourceNamingService {
    private static final System.Logger LOG = System.getLogger(ResourceNamingService.class.getName());
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private ComponentNamingUtil componentNamingUtil;
    @Inject
    private ProcessEnvironment processEnvironment;

    public void publishObject(GenericResourceInfo resourceInfo, Object object, boolean rebind) throws NamingException {
        this.publishObject(resourceInfo, resourceInfo.getName(), object, rebind);
    }

    public void publishObject(GenericResourceInfo resourceInfo, SimpleJndiName jndiName, Object object, boolean rebind) throws NamingException {
        String applicationName = resourceInfo.getApplicationName();
        String moduleName = ResourceUtil.getActualModuleName(resourceInfo.getModuleName());
        SimpleJndiName resJndiName = resourceInfo.getName();
        LOG.log(System.Logger.Level.DEBUG, "publishObject: applicationName={0}, moduleName={1}, jndiName={2}, resourceJndiName={3}", applicationName, moduleName, jndiName, resJndiName);
        if (applicationName != null && moduleName != null && resJndiName.isJavaModule()) {
            Object alreadyBoundObject = null;
            if (rebind) {
                try {
                    this.namingManager.unbindModuleObject(applicationName, moduleName, jndiName);
                }
                catch (NameNotFoundException nameNotFoundException) {}
            } else {
                try {
                    alreadyBoundObject = this.namingManager.lookupFromModuleNamespace(applicationName, moduleName, jndiName, null);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if (alreadyBoundObject != null) {
                    throw new NamingException("Object already bound for jndiName [ " + String.valueOf(jndiName) + " ] of  module namespace [" + moduleName + "] of application [" + applicationName + "] ");
                }
            }
            ModuleScopedResourceBinding bindings = new ModuleScopedResourceBinding(jndiName, object);
            ArrayList<ModuleScopedResourceBinding> list = new ArrayList<ModuleScopedResourceBinding>();
            list.add(bindings);
            this.namingManager.bindToModuleNamespace(applicationName, moduleName, list);
        } else if (applicationName != null && resJndiName.isJavaApp()) {
            Object alreadyBoundObject = null;
            if (rebind) {
                try {
                    this.namingManager.unbindAppObject(applicationName, jndiName);
                }
                catch (NameNotFoundException bindings) {}
            } else {
                try {
                    alreadyBoundObject = this.namingManager.lookupFromAppNamespace(applicationName, jndiName, null);
                }
                catch (NameNotFoundException bindings) {
                    // empty catch block
                }
                if (alreadyBoundObject != null) {
                    throw new NamingException("Object already bound for jndiName [ " + String.valueOf(jndiName) + " ] of application's namespace [" + applicationName + "]");
                }
            }
            ApplicationScopedResourceBinding binding = new ApplicationScopedResourceBinding(jndiName, object);
            this.namingManager.bindToAppNamespace(applicationName, List.of(binding));
            this.bindAppScopedNameForAppclient(object, jndiName, applicationName);
        } else {
            this.namingManager.publishObject(jndiName, object, true);
        }
    }

    private void bindAppScopedNameForAppclient(Object object, SimpleJndiName jndiName, String applicationName) throws NamingException {
        SimpleJndiName name = this.componentNamingUtil.composeInternalGlobalJavaAppName(applicationName, jndiName);
        this.namingManager.publishObject(name, object, true);
    }

    public void unpublishObject(GenericResourceInfo resourceInfo) throws NamingException {
        this.unpublishObject(resourceInfo, resourceInfo.getName());
    }

    public void unpublishObject(GenericResourceInfo resourceInfo, SimpleJndiName jndiName) throws NamingException {
        String applicationName = resourceInfo.getApplicationName();
        String moduleName = ResourceUtil.getActualModuleName(resourceInfo.getModuleName());
        SimpleJndiName resJndiName = resourceInfo.getName();
        LOG.log(System.Logger.Level.DEBUG, "unpublishObject: applicationName={0}, moduleName={1}, jndiName={2}, resourceJndiName={3}", applicationName, moduleName, jndiName, resJndiName);
        if (applicationName != null && moduleName != null && resJndiName.isJavaModule()) {
            this.namingManager.unbindModuleObject(applicationName, moduleName, jndiName);
        } else if (applicationName != null && resJndiName.isJavaApp()) {
            this.namingManager.unbindAppObject(applicationName, jndiName);
            this.unbindAppScopedNameForAppclient(jndiName, applicationName);
        } else {
            this.namingManager.unpublishObject(jndiName);
        }
    }

    private void unbindAppScopedNameForAppclient(SimpleJndiName jndiName, String applicationName) throws NamingException {
        SimpleJndiName internalGlobalJndiName = this.componentNamingUtil.composeInternalGlobalJavaAppName(applicationName, jndiName);
        this.namingManager.unpublishObject(internalGlobalJndiName);
    }

    public <T> T lookup(GenericResourceInfo resourceInfo, SimpleJndiName jndiName) throws NamingException {
        return this.lookup(resourceInfo, jndiName, null);
    }

    public <T> T lookup(GenericResourceInfo resourceInfo, SimpleJndiName jndiName, Hashtable env) throws NamingException {
        String applicationName = resourceInfo.getApplicationName();
        String moduleName = ResourceUtil.getActualModuleName(resourceInfo.getModuleName());
        SimpleJndiName resJndiName = resourceInfo.getName();
        LOG.log(System.Logger.Level.DEBUG, "lookup: applicationName={0}, moduleName={1}, jndiName={2}, resourceJndiName={3}", applicationName, moduleName, jndiName, resJndiName);
        if (applicationName != null && moduleName != null && resJndiName.isJavaModule()) {
            return this.namingManager.lookupFromModuleNamespace(applicationName, moduleName, jndiName, env);
        }
        if (applicationName != null && resJndiName.isJavaApp()) {
            if (this.processEnvironment.getProcessType().isServer() || this.processEnvironment.getProcessType().isEmbedded()) {
                return this.namingManager.lookupFromAppNamespace(applicationName, jndiName, env);
            }
            SimpleJndiName internalGlobalJndiName = this.componentNamingUtil.composeInternalGlobalJavaAppName(applicationName, jndiName);
            LOG.log(System.Logger.Level.DEBUG, "internalGlobalJndiName={0}", internalGlobalJndiName);
            return this.namingManager.lookup(internalGlobalJndiName);
        }
        if (env == null || env.isEmpty()) {
            return this.namingManager.lookup(jndiName);
        }
        return (T)new InitialContext(env).lookup(jndiName.toString());
    }
}

