/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.List;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionFactory;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalker;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalkerContext;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.impl.Visitor;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;

public class SourceExpressionVisitor
extends TreeWalker {
    private ImportList imports;
    private StringBuilder sb;

    private String typeName(Type type2) {
        if (this.imports.contains(type2)) {
            return type2.className();
        }
        return type2.name();
    }

    public String value() {
        return this.sb.toString();
    }

    public SourceExpressionVisitor(TreeWalkerContext context, ImportList imports) {
        super(context);
        context.push(this);
        this.imports = imports;
        this.sb = new StringBuilder();
    }

    @Override
    public boolean preNode(Node arg) {
        return false;
    }

    @Override
    public boolean preVariable(Variable arg) {
        this.sb.append(((VariableInternal)arg).ident());
        return false;
    }

    @Override
    public void postVariable(Variable arg) {
    }

    @Override
    public boolean preConstantExpression(ExpressionFactory.ConstantExpression arg) {
        Object value = arg.value();
        Type type2 = arg.type();
        Object javaRep = type2 == Type._null() ? "null" : (type2 == Type._Class() ? this.typeName((Type)Type.class.cast(value)) + ".class" : (type2 == Type._String() ? "\"" + value + "\"" : (type2 == Type._char() ? "'" + value + "'" : value.toString())));
        this.sb.append((String)javaRep);
        return false;
    }

    @Override
    public boolean preVoidExpression(ExpressionFactory.VoidExpression arg) {
        this.sb.append("void");
        return false;
    }

    @Override
    public boolean preThisExpression(ExpressionFactory.ThisExpression arg) {
        this.sb.append("this");
        return false;
    }

    @Override
    public boolean preUnaryOperatorExpression(ExpressionFactory.UnaryOperatorExpression arg) {
        this.sb.append(arg.operator().javaRepresentation());
        this.sb.append('(');
        return true;
    }

    @Override
    public void postUnaryOperatorExpression(ExpressionFactory.UnaryOperatorExpression arg) {
        this.sb.append(')');
    }

    @Override
    public boolean preBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        this.sb.append('(');
        return true;
    }

    @Override
    public void binaryOperatorExpressionBeforeRight(ExpressionFactory.BinaryOperatorExpression arg) {
        this.sb.append(arg.operator().javaRepresentation());
    }

    @Override
    public void postBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        this.sb.append(')');
    }

    @Override
    public boolean preCastExpression(ExpressionFactory.CastExpression arg) {
        this.sb.append("((");
        this.sb.append(this.typeName(arg.type()));
        this.sb.append(')');
        return true;
    }

    @Override
    public void postCastExpression(ExpressionFactory.CastExpression arg) {
        this.sb.append(')');
    }

    @Override
    public boolean preInstofExpression(ExpressionFactory.InstofExpression arg) {
        this.sb.append('(');
        return true;
    }

    @Override
    public void postInstofExpression(ExpressionFactory.InstofExpression arg) {
        this.sb.append(" instanceof ");
        this.sb.append(this.typeName(arg.type()));
        this.sb.append(')');
    }

    @Override
    public boolean preNonStaticCallExpression(ExpressionFactory.NonStaticCallExpression arg) {
        this.context.mark();
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void nonStaticCallExpressionBeforeArg(ExpressionFactory.NonStaticCallExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postNonStaticCallExpression(ExpressionFactory.NonStaticCallExpression arg) {
        List<Visitor> marks = this.context.popMark();
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr == 0) {
                this.sb.append(sev.value());
                this.sb.append('.');
                this.sb.append(arg.ident());
                this.sb.append('(');
            } else {
                if (ctr > 1) {
                    this.sb.append(", ");
                }
                this.sb.append(sev.value());
            }
            ++ctr;
        }
        this.sb.append(")");
    }

    @Override
    public boolean preStaticCallExpression(ExpressionFactory.StaticCallExpression arg) {
        this.context.mark();
        return true;
    }

    @Override
    public void staticCallExpressionBeforeArg(ExpressionFactory.StaticCallExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postStaticCallExpression(ExpressionFactory.StaticCallExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append(this.typeName((Type)arg.target()));
        this.sb.append('.');
        this.sb.append(arg.ident());
        this.sb.append('(');
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    @Override
    public boolean preNewObjExpression(ExpressionFactory.NewObjExpression arg) {
        this.context.mark();
        return true;
    }

    @Override
    public void newObjExpressionBeforeArg(ExpressionFactory.NewObjExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postNewObjExpression(ExpressionFactory.NewObjExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("new ");
        this.sb.append(this.typeName(arg.type()));
        this.sb.append('(');
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    @Override
    public boolean preNewArrExpression(ExpressionFactory.NewArrExpression arg) {
        this.context.mark();
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void newArrExpressionBeforeExpression(ExpressionFactory.NewArrExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postNewArrExpression(ExpressionFactory.NewArrExpression arg) {
        List<Visitor> marks = this.context.popMark();
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr == 0) {
                this.sb.append("new ");
                this.sb.append(this.typeName(arg.ctype()));
                this.sb.append('[');
                if (arg.exprs().size() == 0) {
                    this.sb.append(sev.value());
                    this.sb.append(']');
                } else {
                    this.sb.append("] {");
                }
            } else {
                if (ctr > 1) {
                    this.sb.append(", ");
                }
                this.sb.append(sev.value());
            }
            ++ctr;
        }
        this.sb.append("}");
    }

    @Override
    public boolean preSuperCallExpression(ExpressionFactory.SuperCallExpression arg) {
        this.context.mark();
        return true;
    }

    @Override
    public void superCallExpressionBeforeArg(ExpressionFactory.SuperCallExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postSuperCallExpression(ExpressionFactory.SuperCallExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("super.");
        this.sb.append(arg.ident());
        this.sb.append('(');
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    @Override
    public boolean preSuperObjExpression(ExpressionFactory.SuperObjExpression arg) {
        this.context.mark();
        return true;
    }

    @Override
    public void superObjExpressionBeforeArg(ExpressionFactory.SuperObjExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postSuperObjExpression(ExpressionFactory.SuperObjExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("super(");
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    @Override
    public boolean preThisObjExpression(ExpressionFactory.ThisObjExpression arg) {
        this.context.mark();
        return true;
    }

    @Override
    public void thisObjExpressionBeforeArg(ExpressionFactory.ThisObjExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postThisObjExpression(ExpressionFactory.ThisObjExpression arg) {
        List<Visitor> marks = this.context.popMark();
        this.sb.append("this(");
        int ctr = 0;
        for (Visitor visitor : marks) {
            SourceExpressionVisitor sev = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(visitor);
            if (ctr > 0) {
                this.sb.append(", ");
            }
            this.sb.append(sev.value());
            ++ctr;
        }
        this.sb.append(")");
    }

    @Override
    public boolean preNonStaticFieldAccessExpression(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        return true;
    }

    @Override
    public void postNonStaticFieldAccessExpression(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        this.sb.append('.');
        this.sb.append(arg.fieldName());
    }

    @Override
    public boolean preStaticFieldAccessExpression(ExpressionFactory.StaticFieldAccessExpression arg) {
        return true;
    }

    @Override
    public void postStaticFieldAccessExpression(ExpressionFactory.StaticFieldAccessExpression arg) {
        this.sb.append(this.typeName((Type)arg.target()));
        this.sb.append('.');
        this.sb.append(arg.fieldName());
    }

    @Override
    public boolean preArrayIndexExpression(ExpressionFactory.ArrayIndexExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void arrayIndexExpressionBeforeExpr(ExpressionFactory.ArrayIndexExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
    }

    @Override
    public void postArrayIndexExpression(ExpressionFactory.ArrayIndexExpression arg) {
        SourceExpressionVisitor expr = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        SourceExpressionVisitor index = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.sb.append(expr.value());
        this.sb.append('[');
        this.sb.append(index.value());
        this.sb.append(']');
    }

    @Override
    public boolean preArrayLengthExpression(ExpressionFactory.ArrayLengthExpression arg) {
        new SourceExpressionVisitor(this.context, this.imports);
        return true;
    }

    @Override
    public void postArrayLengthExpression(ExpressionFactory.ArrayLengthExpression arg) {
        SourceExpressionVisitor expr = (SourceExpressionVisitor)SourceExpressionVisitor.class.cast(this.context.pop());
        this.sb.append(expr.value());
        this.sb.append(".length");
    }
}

