/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpaconnector;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.EARBasedPersistenceHelper;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.Set;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.persistence.jpaconnector.JPASniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="jpaCompositeSniffer")
@Singleton
public class JPACompositeSniffer
extends JPASniffer {
    @Override
    public boolean handles(DeploymentContext context) {
        ArchiveType archiveType = this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        boolean isJPAApplication = false;
        ApplicationHolder holder = context.getModuleMetaData(ApplicationHolder.class);
        ReadableArchive appRoot = context.getSource();
        if (holder != null && holder.app != null && !(isJPAApplication = this.scanForPURootsInLibDir(appRoot, holder.app.getLibraryDirectory())) && DeploymentUtils.useV2Compatibility(context)) {
            isJPAApplication = this.scanForPURRootsInEarRoot(context, holder.app.getModules());
        }
        return isJPAApplication;
    }

    @Override
    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.toString().equals("ear");
    }

    private boolean scanForPURRootsInEarRoot(DeploymentContext ctx, Set<ModuleDescriptor<BundleDescriptor>> modules) {
        boolean puPresentInEarRoot = false;
        Enumeration<String> entriesInEar = ctx.getSource().entries();
        while (entriesInEar.hasMoreElements() && !puPresentInEarRoot) {
            String entry = entriesInEar.nextElement();
            puPresentInEarRoot = PersistenceArchivist.isProbablePuRootJar(entry) && !EARBasedPersistenceHelper.isComponentJar(entry, modules);
        }
        return puPresentInEarRoot;
    }
}

