/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.rotation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.rotation.LogFileArchiver;
import org.glassfish.main.jul.rotation.MeteredFileWriter;
import org.glassfish.main.jul.rotation.MeteredStream;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class LogFileManager {
    private static final DateTimeFormatter SUFFIX_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss");
    private final ReentrantLock lock = new ReentrantLock(true);
    private final File logFile;
    private final LogFileArchiver archiver;
    private final Charset fileEncoding;
    private final long maxFileSize;
    private MeteredFileWriter writer;

    public LogFileManager(File logFile, Charset fileEncoding, long maxFileSize, boolean compressOldLogFiles, int maxCountOfOldLogFiles) {
        this.logFile = logFile;
        this.fileEncoding = fileEncoding;
        this.maxFileSize = maxFileSize;
        this.archiver = new LogFileArchiver(logFile, compressOldLogFiles, maxCountOfOldLogFiles);
    }

    public void write(String text) throws IllegalStateException {
        this.lock.lock();
        try {
            if (!this.isOutputEnabled()) {
                throw new IllegalStateException("The file output is disabled!");
            }
            try {
                this.writer.write(text);
            }
            catch (Exception e) {
                GlassFishLoggingTracer.error(this.getClass(), "Could not write to the output stream.", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void flush() {
        this.lock.lock();
        try {
            if (this.isOutputEnabled()) {
                try {
                    this.writer.flush();
                }
                catch (IOException e) {
                    GlassFishLoggingTracer.error(this.getClass(), "Could not flush the writer.", e);
                }
            }
            this.rollIfFileTooBig();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getFileSize() {
        this.lock.lock();
        try {
            long l = this.writer == null ? this.logFile.length() : this.writer.getBytesWritten();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void rollIfFileTooBig() {
        this.lock.lock();
        try {
            if (this.isRollFileSizeLimitReached()) {
                this.roll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void rollIfFileNotEmpty() {
        this.lock.lock();
        try {
            if (this.getFileSize() > 0L) {
                this.roll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public void roll() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isOutputEnabled() {
        this.lock.lock();
        try {
            boolean bl = this.writer != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableOutput() {
        this.lock.lock();
        try {
            if (this.isOutputEnabled()) {
                throw new IllegalStateException("Output is already enabled!");
            }
            File parent = this.logFile.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IllegalStateException("Failed to create the parent directory " + parent.getAbsolutePath());
            }
            try {
                FileOutputStream fout = new FileOutputStream(this.logFile, true);
                BufferedOutputStream bout = new BufferedOutputStream(fout);
                MeteredStream stream = new MeteredStream(bout, this.logFile.length());
                this.writer = new MeteredFileWriter(stream, this.fileEncoding);
                GlassFishLoggingTracer.trace(LogFileManager.class, () -> "Output enabled to " + String.valueOf(this.logFile));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not open the log file for writing: " + String.valueOf(this.logFile), e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disableOutput() {
        this.lock.lock();
        try {
            if (!this.isOutputEnabled()) {
                return;
            }
            try {
                GlassFishLoggingTracer.trace(LogFileManager.class, () -> "Closing writer: " + String.valueOf(this.writer));
                this.writer.close();
            }
            catch (IOException e) {
                GlassFishLoggingTracer.error(this.getClass(), "Could not close the output stream.", e);
            }
            this.writer = null;
            GlassFishLoggingTracer.trace(LogFileManager.class, () -> "Output disabled to " + String.valueOf(this.logFile));
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isRollFileSizeLimitReached() {
        if (this.maxFileSize <= 0L) {
            return false;
        }
        long fileSize = this.getFileSize();
        return fileSize >= this.maxFileSize;
    }

    private File prepareAchivedLogFileTarget() {
        String archivedFileNameBase = this.logFile.getName() + "_" + SUFFIX_FORMATTER.format(LocalDateTime.now());
        int counter = 1;
        String archivedFileName = archivedFileNameBase;
        while (true) {
            File archivedLogFile = new File(this.logFile.getParentFile(), archivedFileName);
            File archivedGzLogFile = this.archiver.getGzArchiveFile(archivedLogFile);
            if (!archivedLogFile.exists() && !archivedGzLogFile.exists()) {
                return archivedLogFile;
            }
            archivedFileName = archivedFileNameBase + "_" + ++counter;
        }
    }

    private void forceOSFilesync(File file) throws IOException {
        new FileOutputStream(file).close();
    }

    private void moveFile(File logFileToArchive, File target, AsyncLogger logger2) throws IOException {
        logger2.logInfo("Archiving file " + String.valueOf(logFileToArchive) + " to " + String.valueOf(target));
        try {
            Files.move(logFileToArchive.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException | UnsupportedOperationException e) {
            logger2.logError(String.format("File %s could not be renamed to %s atomically, now trying to move it without this request.", logFileToArchive, target), e);
            Files.move(logFileToArchive.toPath(), target.toPath(), new CopyOption[0]);
        }
    }

    private static class AsyncLogger
    extends Thread
    implements AutoCloseable {
        private final AtomicBoolean stop;
        private final ConcurrentLinkedQueue<AsyncLogRecord> queue;
        private final Logger logger;

        private AsyncLogger() {
            super("LogFileManagerAsyncLogger");
            this.setDaemon(true);
            this.queue = new ConcurrentLinkedQueue();
            this.stop = new AtomicBoolean();
            this.logger = Logger.getLogger(LogFileManager.class.getName(), null);
            this.start();
        }

        void logInfo(String message) {
            GlassFishLoggingTracer.trace(this.getClass(), message);
            this.queue.add(new AsyncLogRecord(Level.INFO, message, null));
        }

        void logError(String message, Exception exception) {
            GlassFishLoggingTracer.error(this.getClass(), message, exception);
            this.queue.add(new AsyncLogRecord(Level.SEVERE, message, exception));
        }

        @Override
        public void close() {
            this.stop.set(true);
        }

        @Override
        public void run() {
            while (!this.stop.get()) {
                this.drainQueue();
                Thread.onSpinWait();
            }
            this.drainQueue();
        }

        private void drainQueue() {
            AsyncLogRecord record;
            while ((record = this.queue.poll()) != null) {
                this.logger.log(record);
            }
        }
    }

    private static class AsyncLogRecord
    extends GlassFishLogRecord {
        private static final long serialVersionUID = -8159574547676058852L;

        AsyncLogRecord(Level level, String message, Throwable error) {
            super(level, message, true);
            this.setThrown(error);
        }
    }
}

