/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.record;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.record.GlassFishLogRecord;

public final class MessageResolver {
    private final LogManager manager = LogManager.getLogManager();

    public GlassFishLogRecord resolve(LogRecord record) {
        if (record == null) {
            return null;
        }
        GlassFishLogRecord enhancedLogRecord = this.toGlassFishLogRecord(record);
        if (this.isAlreadyResolved(enhancedLogRecord)) {
            return enhancedLogRecord;
        }
        ResolvedLogMessage message = this.resolveMessage(record);
        enhancedLogRecord.setMessageKey(message.key);
        enhancedLogRecord.setMessage(message.message);
        enhancedLogRecord.setResourceBundle(null);
        enhancedLogRecord.setResourceBundleName(null);
        if (LoggingSystemEnvironment.isReleaseParametersEarly()) {
            enhancedLogRecord.setParameters(null);
        }
        return enhancedLogRecord;
    }

    private GlassFishLogRecord toGlassFishLogRecord(LogRecord record) {
        if (GlassFishLogRecord.class.isInstance(record)) {
            return (GlassFishLogRecord)record;
        }
        return new GlassFishLogRecord(record);
    }

    private boolean isAlreadyResolved(GlassFishLogRecord record) {
        if (record.getMessageKey() != null) {
            return true;
        }
        return record.getResourceBundle() == null && record.getResourceBundleName() == null && record.getParameters() == null;
    }

    private ResolvedLogMessage resolveMessage(LogRecord record) {
        String originalMessage = record.getMessage();
        if (originalMessage == null || originalMessage.isEmpty()) {
            return new ResolvedLogMessage(null, originalMessage);
        }
        ResourceBundle bundle2 = this.getResourceBundle(record.getResourceBundle(), record.getLoggerName());
        ResolvedLogMessage localizedTemplate = this.tryToLocalizeTemplate(originalMessage, bundle2);
        Object[] parameters = record.getParameters();
        if (parameters == null || parameters.length == 0) {
            return localizedTemplate;
        }
        String localizedMessage = this.toMessage(localizedTemplate.message, parameters);
        return new ResolvedLogMessage(localizedTemplate.key, localizedMessage);
    }

    private ResourceBundle getResourceBundle(ResourceBundle bundle2, String loggerName) {
        if (bundle2 != null || loggerName == null) {
            return bundle2;
        }
        Logger logger2 = this.manager.getLogger(loggerName);
        return logger2 == null ? null : logger2.getResourceBundle();
    }

    private ResolvedLogMessage tryToLocalizeTemplate(String originalMessage, ResourceBundle bundle2) {
        if (bundle2 == null) {
            return new ResolvedLogMessage(null, originalMessage);
        }
        try {
            String localizedMessage = bundle2.getString(originalMessage);
            return new ResolvedLogMessage(originalMessage, localizedMessage);
        }
        catch (MissingResourceException e) {
            return new ResolvedLogMessage(null, originalMessage);
        }
    }

    private String toMessage(String template, Object[] parameters) {
        try {
            return MessageFormat.format(template, parameters);
        }
        catch (Exception e) {
            return template;
        }
    }

    private static final class ResolvedLogMessage {
        private final String key;
        private final String message;

        ResolvedLogMessage(String key, String message) {
            this.key = key;
            this.message = message;
        }

        public String toString() {
            return this.key + ":" + this.message;
        }
    }
}

