/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.LogRecord;
import java.util.stream.Stream;
import org.glassfish.main.jul.GlassFishLogger;

final class StartupQueue {
    private static final StartupQueue INSTANCE = new StartupQueue();
    private final ConcurrentLinkedQueue<DeferredRecord> queue = new ConcurrentLinkedQueue();

    private StartupQueue() {
    }

    public static StartupQueue getInstance() {
        return INSTANCE;
    }

    public void add(GlassFishLogger logger2, LogRecord record) {
        this.queue.add(new DeferredRecord(logger2, record));
    }

    public Stream<DeferredRecord> toStream() {
        return this.queue.stream().sorted();
    }

    public void reset() {
        this.queue.clear();
    }

    public int getSize() {
        return this.queue.size();
    }

    static final class DeferredRecord
    implements Comparable<DeferredRecord> {
        private final GlassFishLogger logger;
        private final LogRecord record;

        DeferredRecord(GlassFishLogger logger2, LogRecord record) {
            this.logger = logger2;
            this.record = record;
        }

        public GlassFishLogger getLogger() {
            return this.logger;
        }

        public LogRecord getRecord() {
            return this.record;
        }

        @Override
        public int compareTo(DeferredRecord another) {
            if (this.record.getSequenceNumber() < another.getRecord().getSequenceNumber()) {
                return -1;
            }
            if (this.record.getSequenceNumber() > another.getRecord().getSequenceNumber()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return super.toString() + "[seq=" + this.record.getSequenceNumber() + ", level=" + String.valueOf(this.record.getLevel()) + ", message=" + this.record.getMessage() + "]";
        }
    }
}

