/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.validation.internal.ValidateOnExecutionHandler;

class ValidateOnExecutionTraversableResolver
implements TraversableResolver {
    private final TraversableResolver delegate;
    private final ConcurrentMap<String, Method> propertyToMethod = new ConcurrentHashMap<String, Method>();
    private final ValidateOnExecutionHandler validateOnExecutionHandler;
    private final boolean validateExecutable;

    public ValidateOnExecutionTraversableResolver(TraversableResolver delegate, ValidateOnExecutionHandler validateOnExecutionHandler, boolean validateExecutable) {
        this.delegate = delegate;
        this.validateExecutable = validateExecutable;
        this.validateOnExecutionHandler = validateOnExecutionHandler;
    }

    @Override
    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        boolean isEntity;
        Class<?> traversableObjectClass = traversableObject.getClass();
        boolean bl = isEntity = !rootBeanType.equals(traversableObjectClass);
        if (isEntity && this.validateExecutable && ElementType.METHOD.equals((Object)elementType)) {
            Method getter;
            String propertyName = traversableProperty.getName();
            String propertyKey = traversableObjectClass.getName() + "#" + propertyName;
            if (!this.propertyToMethod.containsKey(propertyKey) && (getter = this.getGetterMethod(traversableObjectClass, propertyName)) != null) {
                this.propertyToMethod.putIfAbsent(propertyKey, getter);
            }
            return (getter = (Method)this.propertyToMethod.get(propertyKey)) != null && this.validateOnExecutionHandler.validateGetter(traversableObjectClass, getter);
        }
        return this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    @Override
    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private Method getGetterMethod(Class<?> clazz, String propertyName) {
        Class<?> propertyType = null;
        for (Field field : AccessController.doPrivileged(ReflectionHelper.getAllFieldsPA(clazz))) {
            if (!field.getName().equals(propertyName)) continue;
            propertyType = field.getType();
        }
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String getterPropertyName = new String(chars);
        String isGetter = "is" + getterPropertyName;
        String getGetter = "get" + getterPropertyName;
        for (Method method : AccessController.doPrivileged(ReflectionHelper.getMethodsPA(clazz))) {
            String methodName = method.getName();
            if (!methodName.equals(isGetter) && !methodName.equals(getGetter) || !ReflectionHelper.isGetter(method) || propertyType != null && !propertyType.isAssignableFrom(method.getReturnType())) continue;
            return AccessController.doPrivileged(ReflectionHelper.findMethodOnClassPA(clazz, method));
        }
        return null;
    }
}

