/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.jdbc.DataSource;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.waitqueue.PoolWaitQueue;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
@ResourceDeployerInfo(value=JdbcConnectionPool.class)
public class JdbcConnectionPoolDeployer
implements ResourceDeployer<JdbcConnectionPool> {
    private static final Logger LOG = LogDomains.getLogger(JdbcConnectionPoolDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    private static final StringManager STRINGS = StringManager.getManager(JdbcConnectionPoolDeployer.class);
    private static final Locale LOCALE = Locale.getDefault();
    @Inject
    private ConnectorRuntime runtime;
    @Inject
    @Optional
    private Domain domain;
    private final ExecutorService execService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    });

    @Override
    public boolean handles(Object resource) {
        return resource instanceof JdbcConnectionPool;
    }

    @Override
    public Class<?>[] getProxyClassesForDynamicReconfiguration() {
        return new Class[]{DataSource.class};
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    @Override
    public void deployResource(JdbcConnectionPool resource) throws Exception {
        PoolInfo poolInfo = ResourceUtil.getPoolInfo(resource);
        this.actualDeployResource(resource, poolInfo);
    }

    @Override
    public void deployResource(JdbcConnectionPool resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = new SimpleJndiName(resource.getName());
        PoolInfo poolInfo = new PoolInfo(jndiName, applicationName, moduleName);
        this.actualDeployResource(resource, poolInfo);
    }

    @Override
    public void undeployResource(JdbcConnectionPool resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = new SimpleJndiName(resource.getName());
        PoolInfo poolInfo = new PoolInfo(jndiName, applicationName, moduleName);
        this.actualUndeployResource(poolInfo);
    }

    @Override
    public synchronized void undeployResource(JdbcConnectionPool resource) throws Exception {
        PoolInfo poolInfo = ResourceUtil.getPoolInfo(resource);
        this.actualUndeployResource(poolInfo);
    }

    @Override
    public synchronized void redeployResource(JdbcConnectionPool resource) throws Exception {
        PoolInfo poolInfo = ResourceUtil.getPoolInfo(resource);
        if (!this.runtime.isConnectorConnectionPoolDeployed(poolInfo)) {
            LOG.fine(() -> "The JDBC connection pool " + String.valueOf(poolInfo) + " is not referred or not yet created in this server instance and hence pool redeployment is ignored");
            return;
        }
        ConnectorConnectionPool connectorConnectionPool = this.createConnectorConnectionPool(resource, poolInfo);
        if (connectorConnectionPool == null) {
            throw new ConnectorRuntimeException("Unable to create ConnectorConnectionPool from JDBC connection pool");
        }
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("TransactionIsolation");
        excludes.add("GuaranteeIsolationLevel");
        excludes.add("ValidationTableName");
        excludes.add("ConnectionValidationRequired");
        excludes.add("ValidationMethod");
        excludes.add("StatementWrapping");
        excludes.add("StatementTimeout");
        excludes.add("ValidationClassName");
        excludes.add("StatementCacheSize");
        excludes.add("StatementCacheType");
        excludes.add("StatementLeakTimeoutInSeconds");
        excludes.add("StatementLeakReclaim");
        try {
            LOG.finest("Calling reconfigure pool");
            boolean requirePoolRecreation = this.runtime.reconfigureConnectorConnectionPool(connectorConnectionPool, excludes);
            if (requirePoolRecreation) {
                if (this.runtime.isServer() || this.runtime.isEmbedded()) {
                    this.handlePoolRecreation(connectorConnectionPool);
                } else {
                    this.recreatePool(connectorConnectionPool);
                }
            }
        }
        catch (ConnectorRuntimeException cre) {
            LOG.log(Level.WARNING, "error.redeploying.jdbc.pool", new Object[]{poolInfo, cre});
            throw cre;
        }
    }

    @Override
    public synchronized void enableResource(JdbcConnectionPool resource) throws Exception {
        throw new UnsupportedOperationException(STRINGS.getString("resource.restart_needed"));
    }

    @Override
    public synchronized void disableResource(JdbcConnectionPool resource) throws Exception {
        throw new UnsupportedOperationException(STRINGS.getString("resource.restart_needed"));
    }

    private void actualDeployResource(Object resource, PoolInfo poolInfo) {
        LOG.log(Level.CONFIG, "actualDeployResource(resource={0}, poolInfo={1})", new Object[]{resource, poolInfo});
        try {
            ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool((JdbcConnectionPool)resource, poolInfo);
            this.registerTransparentDynamicReconfigPool(poolInfo, (JdbcConnectionPool)resource);
            this.runtime.createConnectorConnectionPool(connConnPool);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "error.creating.jdbc.pool", new Object[]{poolInfo, e});
        }
    }

    private void registerTransparentDynamicReconfigPool(PoolInfo poolInfo, JdbcConnectionPool resourcePool) {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        if (ConnectorsUtil.isDynamicReconfigurationEnabled(resourcePool)) {
            registry.addTransparentDynamicReconfigPool(poolInfo);
        } else {
            registry.removeTransparentDynamicReconfigPool(poolInfo);
        }
    }

    private synchronized void actualUndeployResource(PoolInfo poolInfo) throws Exception {
        this.runtime.deleteConnectorConnectionPool(poolInfo);
        ConnectorRegistry.getInstance().removeTransparentDynamicReconfigPool(poolInfo);
        LOG.finest("Pool Undeployed");
    }

    private ConnectorConfigProperty[] getMCFConfigProperties(JdbcConnectionPool adminPool, ConnectorConnectionPool connectorConnectionPool, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ConnectorConfigProperty> configProperties = new ArrayList<ConnectorConfigProperty>();
        if (adminPool.getResType() != null) {
            if ("java.sql.Driver".equals(adminPool.getResType())) {
                configProperties.add(new ConnectorConfigProperty("ClassName", adminPool.getDriverClassname() == null ? "" : adminPool.getDriverClassname(), "The driver class name", String.class.getName()));
            } else {
                configProperties.add(new ConnectorConfigProperty("ClassName", adminPool.getDatasourceClassname() == null ? "" : adminPool.getDatasourceClassname(), "The datasource class name", String.class.getName()));
            }
        } else if (adminPool.getDriverClassname() != null) {
            configProperties.add(new ConnectorConfigProperty("ClassName", adminPool.getDriverClassname() == null ? "" : adminPool.getDriverClassname(), "The driver class name", String.class.getName()));
        } else if (adminPool.getDatasourceClassname() != null) {
            configProperties.add(new ConnectorConfigProperty("ClassName", adminPool.getDatasourceClassname() == null ? "" : adminPool.getDatasourceClassname(), "The datasource class name", String.class.getName()));
        }
        configProperties.add(new ConnectorConfigProperty("ConnectionValidationRequired", adminPool.getIsConnectionValidationRequired(), "Is connection validation required", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("ValidationMethod", adminPool.getConnectionValidationMethod() == null ? "" : adminPool.getConnectionValidationMethod(), "How the connection is validated", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("ValidationTableName", adminPool.getValidationTableName() == null ? "" : adminPool.getValidationTableName(), "Validation Table name", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("ValidationClassName", adminPool.getValidationClassname() == null ? "" : adminPool.getValidationClassname(), "Validation Class name", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("TransactionIsolation", adminPool.getTransactionIsolationLevel() == null ? "" : adminPool.getTransactionIsolationLevel(), "Transaction Isolatin Level", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("GuaranteeIsolationLevel", adminPool.getIsIsolationLevelGuaranteed(), "Transaction Isolation Guarantee", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("StatementWrapping", adminPool.getWrapJdbcObjects(), "Statement Wrapping", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("StatementTimeout", adminPool.getStatementTimeoutInSeconds(), "Statement Timeout", String.class.getName()));
        PoolInfo poolInfo = connectorConnectionPool.getPoolInfo();
        configProperties.add(new ConnectorConfigProperty("PoolMonitoringSubTreeRoot", ConnectorsUtil.getPoolMonitoringSubTreeRoot(poolInfo, true), "Pool Monitoring Sub Tree Root", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("PoolName", String.valueOf(poolInfo.getName()), "Pool Name", SimpleJndiName.class.getName()));
        if (poolInfo.getApplicationName() != null) {
            configProperties.add(new ConnectorConfigProperty("ApplicationName", poolInfo.getApplicationName(), "Application Name", String.class.getName()));
        }
        if (poolInfo.getModuleName() != null) {
            configProperties.add(new ConnectorConfigProperty("ModuleName", poolInfo.getModuleName(), "Module name", String.class.getName()));
        }
        configProperties.add(new ConnectorConfigProperty("StatementCacheSize", adminPool.getStatementCacheSize(), "Statement Cache Size", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("StatementCacheType", adminPool.getStatementCacheType(), "Statement Cache Type", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("InitSql", adminPool.getInitSql(), "InitSql", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("SqlTraceListeners", adminPool.getSqlTraceListeners(), "Sql Trace Listeners", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("StatementLeakTimeoutInSeconds", adminPool.getStatementLeakTimeoutInSeconds(), "Statement Leak Timeout in seconds", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("StatementLeakReclaim", adminPool.getStatementLeakReclaim(), "Statement Leak Reclaim", String.class.getName()));
        Set<ConnectionDefDescriptor> connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        if (connectionDefs.size() != 1) {
            throw new MissingResourceException("Only one connDefDesc present", null, null);
        }
        Set<ConnectorConfigProperty> mcfConfigProps = null;
        for (ConnectionDefDescriptor connectionDef : connectionDefs) {
            mcfConfigProps = connectionDef.getConfigProperties();
        }
        if (mcfConfigProps != null) {
            HashMap<String, String> mcfConPropKeys = new HashMap<String, String>();
            Iterator<ConnectorConfigProperty> mcfConfigPropsIter = mcfConfigProps.iterator();
            while (mcfConfigPropsIter.hasNext()) {
                String key = mcfConfigPropsIter.next().getDisplayName();
                mcfConPropKeys.put(key.toUpperCase(LOCALE), key);
            }
            Object driverProperties = "";
            for (Property adminPoolProperty : adminPool.getProperty()) {
                String value;
                if (adminPoolProperty == null) continue;
                String name = adminPoolProperty.getName();
                if ("MATCHCONNECTIONS".equals(name.toUpperCase(LOCALE))) {
                    connectorConnectionPool.setMatchConnections(this.toBoolean(adminPoolProperty.getValue(), false));
                    LOG.log(Level.FINEST, "MATCHCONNECTIONS");
                    continue;
                }
                if ("ASSOCIATEWITHTHREAD".equals(name.toUpperCase(LOCALE))) {
                    connectorConnectionPool.setAssociateWithThread(this.toBoolean(adminPoolProperty.getValue(), false));
                    LOG.log(Level.FINEST, "ASSOCIATEWITHTHREAD");
                    continue;
                }
                if ("LAZYCONNECTIONASSOCIATION".equals(name.toUpperCase(LOCALE))) {
                    ConnectionPoolObjectsUtils.setLazyEnlistAndLazyAssocProperties(adminPoolProperty.getValue(), adminPool.getProperty(), connectorConnectionPool);
                    LOG.log(Level.FINEST, "LAZYCONNECTIONASSOCIATION");
                    continue;
                }
                if ("LAZYCONNECTIONENLISTMENT".equals(name.toUpperCase(Locale.getDefault()))) {
                    connectorConnectionPool.setLazyConnectionEnlist(this.toBoolean(adminPoolProperty.getValue(), false));
                    LOG.log(Level.FINEST, "LAZYCONNECTIONENLISTMENT");
                    continue;
                }
                if ("POOLDATASTRUCTURE".equals(name.toUpperCase(Locale.getDefault()))) {
                    connectorConnectionPool.setPoolDataStructureType(adminPoolProperty.getValue());
                    LOG.log(Level.FINEST, "POOLDATASTRUCTURE");
                    continue;
                }
                if ("dynamic-reconfiguration-wait-timeout-in-seconds".equals(name.toLowerCase(LOCALE))) {
                    value = adminPoolProperty.getValue();
                    try {
                        connectorConnectionPool.setDynamicReconfigWaitTimeout(Long.parseLong(adminPoolProperty.getValue()) * 1000L);
                        LOG.log(Level.FINEST, "dynamic-reconfiguration-wait-timeout-in-seconds");
                    }
                    catch (NumberFormatException nfe) {
                        LOG.log(Level.WARNING, "Invalid value for 'dynamic-reconfiguration-wait-timeout-in-seconds' : " + value);
                    }
                    continue;
                }
                if ("POOLWAITQUEUE".equals(name.toUpperCase(LOCALE))) {
                    connectorConnectionPool.setPoolWaitQueue(adminPoolProperty.getValue());
                    LOG.log(Level.FINEST, "POOLWAITQUEUE");
                    continue;
                }
                if ("DATASTRUCTUREPARAMETERS".equals(name.toUpperCase(LOCALE))) {
                    connectorConnectionPool.setDataStructureParameters(adminPoolProperty.getValue());
                    LOG.log(Level.FINEST, "DATASTRUCTUREPARAMETERS");
                    continue;
                }
                if ("USERNAME".equals(name.toUpperCase(Locale.getDefault())) || "USER".equals(name.toUpperCase(LOCALE))) {
                    configProperties.add(new ConnectorConfigProperty("User", adminPoolProperty.getValue(), "user name", String.class.getName()));
                    continue;
                }
                if ("PASSWORD".equals(name.toUpperCase(LOCALE))) {
                    configProperties.add(new ConnectorConfigProperty("Password", adminPoolProperty.getValue(), "Password", String.class.getName()));
                    continue;
                }
                if ("JDBC30DATASOURCE".equals(name.toUpperCase(LOCALE))) {
                    configProperties.add(new ConnectorConfigProperty("JDBC30DataSource", adminPoolProperty.getValue(), "JDBC30DataSource", String.class.getName()));
                    continue;
                }
                if ("PREFER-VALIDATE-OVER-RECREATE".equals(name.toUpperCase(Locale.getDefault()))) {
                    value = adminPoolProperty.getValue();
                    connectorConnectionPool.setPreferValidateOverRecreate(this.toBoolean(value, false));
                    LOG.log(Level.FINEST, "PREFER-VALIDATE-OVER-RECREATE: {0}", value);
                    continue;
                }
                if ("STATEMENT-CACHE-TYPE".equals(name.toUpperCase(Locale.getDefault()))) {
                    if (adminPool.getStatementCacheType() == null) continue;
                    configProperties.add(new ConnectorConfigProperty("StatementCacheType", adminPoolProperty.getValue(), "StatementCacheType", String.class.getName()));
                    continue;
                }
                if ("NUMBER-OF-TOP-QUERIES-TO-REPORT".equals(name.toUpperCase(Locale.getDefault()))) {
                    configProperties.add(new ConnectorConfigProperty("NumberOfTopQueriesToReport", adminPoolProperty.getValue(), "NumberOfTopQueriesToReport", String.class.getName()));
                    continue;
                }
                if ("TIME-TO-KEEP-QUERIES-IN-MINUTES".equals(name.toUpperCase(Locale.getDefault()))) {
                    configProperties.add(new ConnectorConfigProperty("TimeToKeepQueriesInMinutes", adminPoolProperty.getValue(), "TimeToKeepQueriesInMinutes", String.class.getName()));
                    continue;
                }
                if (mcfConPropKeys.containsKey(name.toUpperCase(Locale.getDefault()))) {
                    configProperties.add(new ConnectorConfigProperty((String)mcfConPropKeys.get(name.toUpperCase(Locale.getDefault())), adminPoolProperty.getValue() == null ? "" : adminPoolProperty.getValue(), "Some property", String.class.getName()));
                    continue;
                }
                driverProperties = (String)driverProperties + "set" + this.escape(name) + "#" + this.escape(adminPoolProperty.getValue()) + "##";
            }
            if (!((String)driverProperties).isEmpty()) {
                configProperties.add(new ConnectorConfigProperty("DriverProperties", (String)driverProperties, "some proprietarty properties", String.class.getName()));
            }
        }
        configProperties.add(new ConnectorConfigProperty("Delimiter", "#", "delim", String.class.getName()));
        configProperties.add(new ConnectorConfigProperty("EscapeCharacter", "\\", "escapeCharacter", String.class.getName()));
        ConnectorConfigProperty[] environmentProperties = new ConnectorConfigProperty[configProperties.size()];
        ListIterator propListIter = configProperties.listIterator();
        int i = 0;
        while (propListIter.hasNext()) {
            environmentProperties[i] = (ConnectorConfigProperty)propListIter.next();
            ++i;
        }
        return environmentProperties;
    }

    private String escape(String value) {
        return value.replace("\\", "\\\\").replace("#", "\\#");
    }

    private boolean toBoolean(String property, boolean defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(property);
    }

    private ConnectorConnectionPool createConnectorConnectionPool(JdbcConnectionPool adminPool, PoolInfo poolInfo) throws ConnectorRuntimeException {
        String moduleName = JdbcResourcesUtil.createInstance().getRANameofJdbcConnectionPool(adminPool);
        int txSupport = this.getTxSupport(moduleName);
        ConnectorDescriptor connectorDescriptor = this.runtime.getConnectorDescriptor(moduleName);
        ConnectorConnectionPool connectorConnectionPool = new ConnectorConnectionPool(poolInfo);
        connectorConnectionPool.setTransactionSupport(txSupport);
        this.setConnectorConnectionPoolAttributes(connectorConnectionPool, adminPool);
        ConnectorDescriptorInfo connectorDescriptorInfo = this.createConnectorDescriptorInfo(connectorDescriptor, moduleName);
        connectorDescriptorInfo.setMCFConfigProperties(this.getMCFConfigProperties(adminPool, connectorConnectionPool, connectorDescriptor));
        connectorDescriptorInfo.setResourceAdapterConfigProperties((Set<ConnectorConfigProperty>)null);
        connectorConnectionPool.setConnectorDescriptorInfo(connectorDescriptorInfo);
        return connectorConnectionPool;
    }

    private int getTxSupport(String moduleName) {
        if ("__xa_jdbc_ra".equals(moduleName)) {
            return ConnectionPoolObjectsUtils.parseTransactionSupportString("XATransaction");
        }
        return ConnectionPoolObjectsUtils.parseTransactionSupportString("LocalTransaction");
    }

    private ConnectorDescriptorInfo createConnectorDescriptorInfo(ConnectorDescriptor connectorDescriptor, String moduleName) {
        ConnectorDescriptorInfo connectorDescriptorInfo = new ConnectorDescriptorInfo();
        connectorDescriptorInfo.setManagedConnectionFactoryClass(connectorDescriptor.getOutboundResourceAdapter().getManagedConnectionFactoryImpl());
        connectorDescriptorInfo.setRarName(moduleName);
        connectorDescriptorInfo.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        connectorDescriptorInfo.setConnectionDefinitionName(connectorDescriptor.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connectorDescriptorInfo.setConnectionFactoryClass(connectorDescriptor.getOutboundResourceAdapter().getConnectionFactoryImpl());
        connectorDescriptorInfo.setConnectionFactoryInterface(connectorDescriptor.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connectorDescriptorInfo.setConnectionClass(connectorDescriptor.getOutboundResourceAdapter().getConnectionImpl());
        connectorDescriptorInfo.setConnectionInterface(connectorDescriptor.getOutboundResourceAdapter().getConnectionIntf());
        return connectorDescriptorInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setConnectorConnectionPoolAttributes(ConnectorConnectionPool connectorConnectionPool, JdbcConnectionPool adminPool) {
        SimpleJndiName poolName = connectorConnectionPool.getName();
        connectorConnectionPool.setMaxPoolSize(adminPool.getMaxPoolSize());
        connectorConnectionPool.setSteadyPoolSize(adminPool.getSteadyPoolSize());
        connectorConnectionPool.setMaxWaitTimeInMillis(adminPool.getMaxWaitTimeInMillis());
        connectorConnectionPool.setPoolResizeQuantity(adminPool.getPoolResizeQuantity());
        connectorConnectionPool.setIdleTimeoutInSeconds(adminPool.getIdleTimeoutInSeconds());
        connectorConnectionPool.setFailAllConnections(Boolean.parseBoolean(adminPool.getFailAllConnections()));
        connectorConnectionPool.setConnectionValidationRequired(Boolean.parseBoolean(adminPool.getIsConnectionValidationRequired()));
        connectorConnectionPool.setNonTransactional(Boolean.parseBoolean(adminPool.getNonTransactionalConnections()));
        connectorConnectionPool.setNonComponent(Boolean.parseBoolean(adminPool.getAllowNonComponentCallers()));
        connectorConnectionPool.setPingDuringPoolCreation(Boolean.parseBoolean(adminPool.getPing()));
        connectorConnectionPool.setMatchConnections(Boolean.parseBoolean(adminPool.getMatchConnections()));
        connectorConnectionPool.setAssociateWithThread(Boolean.parseBoolean(adminPool.getAssociateWithThread()));
        connectorConnectionPool.setConnectionLeakTracingTimeout(adminPool.getConnectionLeakTimeoutInSeconds());
        connectorConnectionPool.setConnectionReclaim(Boolean.parseBoolean(adminPool.getConnectionLeakReclaim()));
        boolean lazyConnectionEnlistment = Boolean.parseBoolean(adminPool.getLazyConnectionEnlistment());
        boolean lazyConnectionAssociation = Boolean.parseBoolean(adminPool.getLazyConnectionAssociation());
        if (lazyConnectionAssociation) {
            if (!lazyConnectionEnlistment) {
                LOG.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", poolName);
                throw new RuntimeException(STRINGS.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination", poolName));
            }
            connectorConnectionPool.setLazyConnectionAssoc(true);
            connectorConnectionPool.setLazyConnectionEnlist(true);
        } else {
            connectorConnectionPool.setLazyConnectionAssoc(lazyConnectionAssociation);
            connectorConnectionPool.setLazyConnectionEnlist(lazyConnectionEnlistment);
        }
        boolean pooling = Boolean.parseBoolean(adminPool.getPooling());
        if (!pooling) {
            if (Boolean.parseBoolean(adminPool.getAssociateWithThread())) {
                LOG.log(Level.SEVERE, "conn_pool_obj_utils.pooling_disabled_assocwiththread_invalid_combination", poolName);
                throw new RuntimeException(STRINGS.getString("cpou.pooling_disabled_assocwiththread_invalid_combination", poolName));
            }
            if (Boolean.parseBoolean(adminPool.getIsConnectionValidationRequired())) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_conn_validation_invalid_combination", poolName);
            }
            if (Integer.parseInt(adminPool.getValidateAtmostOncePeriodInSeconds()) > 0) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_validate_atmost_once_invalid_combination", poolName);
            }
            if (Boolean.parseBoolean(adminPool.getMatchConnections())) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_match_connections_invalid_combination", poolName);
            }
            if (Integer.parseInt(adminPool.getMaxConnectionUsageCount()) > 0) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_max_conn_usage_invalid_combination", poolName);
            }
            if (Integer.parseInt(adminPool.getIdleTimeoutInSeconds()) > 0) {
                LOG.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_idle_timeout_invalid_combination", poolName);
            }
        }
        connectorConnectionPool.setPooling(pooling);
        connectorConnectionPool.setMaxConnectionUsage(adminPool.getMaxConnectionUsageCount());
        connectorConnectionPool.setConCreationRetryAttempts(adminPool.getConnectionCreationRetryAttempts());
        connectorConnectionPool.setConCreationRetryInterval(adminPool.getConnectionCreationRetryIntervalInSeconds());
        connectorConnectionPool.setValidateAtmostOncePeriod(adminPool.getValidateAtmostOncePeriodInSeconds());
    }

    private void handlePoolRecreation(ConnectorConnectionPool connConnPool) {
        LOG.log(Level.FINE, "handlePoolRecreation(connConnPool={0})", connConnPool);
        long reconfigWaitTimeout = connConnPool.getDynamicReconfigWaitTimeout();
        PoolInfo poolInfo = new PoolInfo(connConnPool.getName(), connConnPool.getApplicationName(), connConnPool.getModuleName());
        ResourcePool oldPool = this.runtime.getPoolManager().getPool(poolInfo);
        if (reconfigWaitTimeout > 0L) {
            oldPool.blockRequests(reconfigWaitTimeout);
            if (oldPool.getPoolWaitQueue().getQueueLength() > 0 || oldPool.getPoolStatus().getNumConnUsed() > 0) {
                Runnable runnable = () -> {
                    long numSeconds = 5000L;
                    long steps = reconfigWaitTimeout / numSeconds;
                    if (steps == 0L) {
                        this.waitForCompletion(steps, oldPool, reconfigWaitTimeout);
                    } else {
                        for (long i = 0L; i < steps; ++i) {
                            this.waitForCompletion(steps, oldPool, reconfigWaitTimeout);
                            if (oldPool.getPoolWaitQueue().getQueueLength() != 0 || oldPool.getPoolStatus().getNumConnUsed() != 0) continue;
                            LOG.finest("wait-queue is empty and num-con-used is 0");
                            break;
                        }
                    }
                    this.handlePoolRecreationForExistingProxies(connConnPool);
                    PoolWaitQueue reconfigWaitQueue = oldPool.getReconfigWaitQueue();
                    LOG.finest("checking reconfig-wait-queue for notification");
                    if (reconfigWaitQueue.getQueueContents().size() > 0) {
                        for (Object o : reconfigWaitQueue.getQueueContents()) {
                            LOG.fine("notifying reconfig-wait-queue object [ " + String.valueOf(o) + " ]");
                            Object e = o;
                            synchronized (e) {
                                o.notify();
                            }
                        }
                    }
                    LOG.finest(() -> "woke-up after giving time for in-use connections to return, WaitQueue-Length : [" + String.valueOf(oldPool.getPoolWaitQueue().getQueueContents()) + "], Num-Conn-Used : [" + oldPool.getPoolStatus().getNumConnUsed() + "]");
                };
                try {
                    this.execService.invokeAll(Arrays.asList(Executors.callable(runnable)));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "exception.redeploying.pool.transparently", new Object[]{connConnPool.getName(), e});
                }
            } else {
                this.handlePoolRecreationForExistingProxies(connConnPool);
            }
        } else if (oldPool.getReconfigWaitTime() > 0L) {
            Collection<BindableResource> resources = JdbcResourcesUtil.getResourcesOfPool(this.runtime.getResources(oldPool.getPoolInfo()), oldPool.getPoolInfo().getName());
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            for (BindableResource resource : resources) {
                registry.removeResourceFactories(ConnectorsUtil.getResourceInfo(resource));
            }
            this.recreatePool(connConnPool);
        } else {
            this.recreatePool(connConnPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion(long steps, ResourcePool oldPool, long totalWaitTime) {
        LOG.finest("waiting for in-use connections to return to pool or waiting requests to complete");
        try {
            PoolWaitQueue poolWaitQueue;
            PoolWaitQueue poolWaitQueue2 = poolWaitQueue = oldPool.getPoolWaitQueue();
            synchronized (poolWaitQueue2) {
                long waitTime = totalWaitTime / steps;
                if (waitTime > 0L) {
                    poolWaitQueue.wait(waitTime);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.finest("woke-up to verify in-use / waiting requests list");
    }

    private void handlePoolRecreationForExistingProxies(ConnectorConnectionPool connectorConnectionPool) {
        Collection<BindableResource> resourcesList;
        this.recreatePool(connectorConnectionPool);
        if (!connectorConnectionPool.isApplicationScopedResource()) {
            resourcesList = JdbcResourcesUtil.getResourcesOfPool(this.domain.getResources(), connectorConnectionPool.getName());
        } else {
            PoolInfo poolInfo = connectorConnectionPool.getPoolInfo();
            Resources resources = ResourcesUtil.createInstance().getResources(poolInfo);
            resourcesList = JdbcResourcesUtil.getResourcesOfPool(resources, connectorConnectionPool.getName());
        }
        for (BindableResource bindableResource : resourcesList) {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(bindableResource);
            ConnectorRegistry.getInstance().updateResourceInfoVersion(resourceInfo);
        }
    }

    private void recreatePool(ConnectorConnectionPool connConnPool) {
        try {
            this.runtime.recreateConnectorConnectionPool(connConnPool);
            LOG.log(Level.CONFIG, "Pool [{0}] recreation done", connConnPool.getName());
        }
        catch (ConnectorRuntimeException cre) {
            LOG.log(Level.WARNING, "error.redeploying.jdbc.pool", new Object[]{connConnPool.getName(), cre});
        }
    }
}

