/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeploymentTracing {
    final long inception = System.currentTimeMillis();
    final List<Event> events = new ArrayList<Event>();

    public long elapsed() {
        return System.currentTimeMillis() - this.inception;
    }

    public void addMark(Mark mark) {
        this.events.add(new GlobalEvent(mark));
    }

    public void addContainerMark(ContainerMark mark, String name) {
        this.events.add(new ContainerEvent(mark, name));
    }

    public void addModuleMark(ModuleMark mark, String moduleName) {
        this.events.add(new ModuleEvent(mark, moduleName));
    }

    public void print(PrintStream ps) {
        for (int i = 0; i < this.events.size(); ++i) {
            this.events.get(i).print(ps);
        }
    }

    public static void printModuleStatus(ModulesRegistry registry, Level level, Logger logger2) {
        if (!logger2.isLoggable(level)) {
            return;
        }
        int counter = 0;
        StringBuilder sb = new StringBuilder("HK2Module Status Report Begins\n");
        for (HK2Module m : registry.getModules()) {
            if (m.getState() != ModuleState.READY) continue;
            sb.append(m).append("\n");
            ++counter;
        }
        sb.append("there were " + counter + " modules in ACTIVE state");
        sb.append("\n");
        counter = 0;
        for (HK2Module m : registry.getModules()) {
            if (m.getState() != ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
            ++counter;
        }
        sb.append("there were " + counter + " modules in RESOLVED state");
        sb.append("\n");
        counter = 0;
        for (HK2Module m : registry.getModules()) {
            if (m.getState() == ModuleState.READY || m.getState() == ModuleState.RESOLVED) continue;
            sb.append(m).append("\n");
            ++counter;
        }
        sb.append("there were " + counter + " modules in INSTALLED state");
        sb.append("HK2Module Status Report Ends");
        logger2.log(level, sb.toString());
    }

    private final class GlobalEvent
    extends Event {
        final Mark mark;

        private GlobalEvent(Mark mark) {
            this.mark = mark;
        }

        @Override
        void print(PrintStream ps) {
            ps.println("Mark " + this.mark.toString() + " at " + this.elapsedInMs());
        }
    }

    public static enum Mark {
        ARCHIVE_OPENED,
        ARCHIVE_HANDLER_OBTAINED,
        INITIAL_CONTEXT_CREATED,
        APPINFO_PROVIDED,
        DOL_LOADED,
        APPNAME_DETERMINED,
        TARGET_VALIDATED,
        CONTEXT_CREATED,
        DEPLOY,
        CLASS_LOADER_HIERARCHY,
        PARSING_DONE,
        CLASS_LOADER_CREATED,
        CONTAINERS_SETUP_DONE,
        PREPARE,
        PREPARED,
        LOAD,
        LOAD_EVENTS,
        LOADED,
        START,
        START_EVENTS,
        STARTED,
        REGISTRATION;

    }

    private class ContainerEvent
    extends Event {
        final ContainerMark mark;
        final String name;

        private ContainerEvent(ContainerMark mark, String name) {
            this.mark = mark;
            this.name = name;
        }

        @Override
        void print(PrintStream ps) {
            ps.println("Container : " + this.name + " Mark " + this.mark.toString() + " at " + this.elapsedInMs());
        }
    }

    public static enum ContainerMark {
        SNIFFER_DONE,
        BEFORE_CONTAINER_SETUP,
        AFTER_CONTAINER_SETUP,
        GOT_CONTAINER,
        GOT_DEPLOYER,
        PREPARE,
        PREPARED,
        LOAD,
        LOADED,
        START,
        STARTED;

    }

    private class ModuleEvent
    extends Event {
        final ModuleMark mark;
        final String moduleName;

        private ModuleEvent(ModuleMark mark, String moduleName) {
            this.mark = mark;
            this.moduleName = moduleName;
        }

        @Override
        void print(PrintStream ps) {
            ps.println("HK2Module " + this.moduleName + " Mark " + this.mark.toString() + " at " + this.elapsedInMs());
        }
    }

    public static enum ModuleMark {
        PREPARE,
        PREPARE_EVENTS,
        PREPARED,
        LOAD,
        LOADED,
        START,
        STARTED;

    }

    private abstract class Event {
        final long inception = System.currentTimeMillis();

        private Event() {
        }

        long elapsedInMs() {
            return this.inception - DeploymentTracing.this.inception;
        }

        abstract void print(PrintStream var1);
    }
}

