/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.localization;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.glassfish.grizzly.localization.Localizable;

public class Localizer {
    private final Locale _locale;
    private final Map<String, ResourceBundle> _resourceBundles;

    public Localizer() {
        this(Locale.getDefault());
    }

    public Localizer(Locale l) {
        this._locale = l;
        this._resourceBundles = new HashMap<String, ResourceBundle>();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String localize(Localizable l) {
        String key = l.getKey();
        if (key == "\u0000") {
            return (String)l.getArguments()[0];
        }
        String bundlename = l.getResourceBundleName();
        try {
            String msg;
            ResourceBundle bundle2 = this._resourceBundles.get(bundlename);
            if (bundle2 == null) {
                block13: {
                    try {
                        bundle2 = ResourceBundle.getBundle(bundlename, this._locale);
                    }
                    catch (MissingResourceException e) {
                        int i = bundlename.lastIndexOf(46);
                        if (i == -1) break block13;
                        String alternateBundleName = bundlename.substring(i + 1);
                        try {
                            bundle2 = ResourceBundle.getBundle(alternateBundleName, this._locale);
                        }
                        catch (MissingResourceException e2) {
                            return this.getDefaultMessage(l);
                        }
                    }
                }
                this._resourceBundles.put(bundlename, bundle2);
            }
            if (bundle2 == null) {
                return this.getDefaultMessage(l);
            }
            if (key == null) {
                key = "undefined";
            }
            try {
                msg = bundle2.getString(key);
            }
            catch (MissingResourceException e) {
                msg = bundle2.getString("undefined");
            }
            Object[] args = l.getArguments();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Localizable)) continue;
                args[i] = this.localize((Localizable)args[i]);
            }
            return MessageFormat.format(msg, args);
        }
        catch (MissingResourceException e) {
            return this.getDefaultMessage(l);
        }
    }

    private String getDefaultMessage(Localizable l) {
        String key = l.getKey();
        Object[] args = l.getArguments();
        StringBuilder sb = new StringBuilder();
        sb.append("[failed to localize] ");
        sb.append(key);
        if (args != null) {
            sb.append('(');
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(args[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

