/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.faces.integration;

import com.sun.enterprise.module.HK2Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.net.JarURIPattern;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.web.TldProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.loader.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="jsfTld")
@Singleton
public class GlassFishTldProvider
implements TldProvider,
PostConstruct {
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();
    @Inject
    ModulesRegistry registry;
    private Map<URI, List<String>> tldMap = new HashMap<URI, List<String>>();
    private Map<URI, List<String>> tldListenerMap;

    @Override
    public String getName() {
        return "jsfTld";
    }

    @Override
    public Map<URI, List<String>> getTldMap() {
        return (Map)((HashMap)this.tldMap).clone();
    }

    @Override
    public synchronized Map<URI, List<String>> getTldListenerMap() {
        if (this.tldListenerMap == null) {
            this.tldListenerMap = new HashMap<URI, List<String>>();
            for (Map.Entry<URI, List<String>> entry : this.tldMap.entrySet()) {
                if (!entry.getValue().contains("META-INF/jsf_core.tld")) continue;
                this.tldListenerMap.put(entry.getKey(), entry.getValue());
                break;
            }
            this.tldListenerMap = Collections.unmodifiableMap(this.tldListenerMap);
        }
        return this.tldListenerMap;
    }

    @Override
    public void postConstruct() {
        Class<?> jsfImplClass = null;
        try {
            jsfImplClass = this.getClass().getClassLoader().loadClass("com.sun.faces.spi.InjectionProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Object[] uris = null;
        HK2Module hk2Module = null;
        if (jsfImplClass != null) {
            hk2Module = this.registry.find(jsfImplClass);
        }
        if (hk2Module != null) {
            uris = hk2Module.getModuleDefinition().getLocations();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                Object[] urls = ((URLClassLoader)classLoader).getURLs();
                if (!Utility.isEmpty(urls)) {
                    uris = new URI[urls.length];
                    for (int i = 0; i < urls.length; ++i) {
                        try {
                            uris[i] = ((URL)urls[i]).toURI();
                            continue;
                        }
                        catch (URISyntaxException e) {
                            logger.log(Level.WARNING, MessageFormat.format(rb.getString("AS-WEB-UTIL-00038"), urls[i]), e);
                        }
                    }
                }
            } else {
                logger.log(Level.WARNING, "AS-WEB-UTIL-00039", new Object[]{"JSF", classLoader, GlassFishTldProvider.class.getName()});
            }
        }
        if (!Utility.isEmpty(uris)) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (Object uri : uris) {
                List<String> entries = JarURIPattern.getJarEntries((URI)uri, pattern);
                if (Utility.isEmpty(entries)) continue;
                this.tldMap.put((URI)uri, entries);
            }
        }
    }
}

