/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly.util;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.glassfish.expressly.lang.ELSupport;
import org.glassfish.expressly.util.MessageFactory;

public class ReflectionUtil {
    protected static final String[] EMPTY_STRING = new String[0];
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (name == null || "".equals(name)) {
            return null;
        }
        Class<?> clazz = ReflectionUtil.forNamePrimitive(name);
        if (clazz == null) {
            clazz = name.endsWith("[]") ? Array.newInstance(Class.forName(name.substring(0, name.length() - 2), true, Thread.currentThread().getContextClassLoader()), 0).getClass() : Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        return clazz;
    }

    protected static Class<?> forNamePrimitive(String name) {
        int index;
        if (name.length() <= 8 && (index = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[index];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] classNames) throws ClassNotFoundException {
        if (classNames == null) {
            return null;
        }
        Class[] typeArray = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            typeArray[i] = ReflectionUtil.forName(classNames[i]);
        }
        return typeArray;
    }

    public static String[] toTypeNameArray(Class<?>[] classTypes) {
        if (classTypes == null) {
            return null;
        }
        String[] classNames = new String[classTypes.length];
        for (int i = 0; i < classTypes.length; ++i) {
            classNames[i] = classTypes[i].getName();
        }
        return classNames;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object base, Object property) throws ELException, PropertyNotFoundException {
        String name = ELSupport.coerceToString(property);
        try {
            PropertyDescriptor[] descriptor = Introspector.getBeanInfo(base.getClass()).getPropertyDescriptors();
            for (int i = 0; i < descriptor.length; ++i) {
                if (!descriptor[i].getName().equals(name)) continue;
                return descriptor[i];
            }
        }
        catch (IntrospectionException ie) {
            throw new ELException(ie);
        }
        throw new PropertyNotFoundException(MessageFactory.get("error.property.notfound", base, name));
    }

    public static Object invokeMethod(ELContext context, Method method, Object base, Object[] params) {
        Object[] parameters = ReflectionUtil.buildParameters(context, method.getParameterTypes(), method.isVarArgs(), params);
        try {
            return method.invoke(base, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes, Object[] paramValues) {
        Wrapper result;
        if (clazz == null || methodName == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", clazz, methodName, ReflectionUtil.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = ReflectionUtil.getTypesFromValues(paramValues);
        }
        if ((result = ReflectionUtil.findWrapper(clazz, Wrapper.wrap(clazz.getMethods(), methodName), methodName, paramTypes, paramValues)) == null) {
            return null;
        }
        return ReflectionUtil.getMethod(clazz, (Method)result.unWrap());
    }

    private static Wrapper findWrapper(Class<?> clazz, List<Wrapper> wrappers, String name, Class<?>[] requiredParamTypes, Object[] requiredParamValues) {
        ArrayList<Wrapper> assignableCandidates = new ArrayList<Wrapper>();
        ArrayList<Wrapper> coercibleCandidates = new ArrayList<Wrapper>();
        ArrayList<Wrapper> varArgsCandidates = new ArrayList<Wrapper>();
        int requiredParamCount = ReflectionUtil.getParamCount(requiredParamTypes);
        for (Wrapper wrapper : wrappers) {
            Class<?>[] candidateParamTypes = wrapper.getParameterTypes();
            int canidateParamCount = ReflectionUtil.getParamCount(candidateParamTypes);
            if (requiredParamCount != canidateParamCount && (!wrapper.isVarArgs() || requiredParamCount < canidateParamCount - 1)) continue;
            boolean assignable = false;
            boolean coercible = false;
            boolean varArgs = false;
            boolean noMatch = false;
            block1: for (int i = 0; i < canidateParamCount; ++i) {
                if (i == canidateParamCount - 1 && wrapper.isVarArgs()) {
                    varArgs = true;
                    if (canidateParamCount == requiredParamCount && candidateParamTypes[i] == requiredParamTypes[i]) continue;
                    Class<?> varType = candidateParamTypes[i].getComponentType();
                    for (int j = i; j < requiredParamCount; ++j) {
                        if (ReflectionUtil.isAssignableFrom(requiredParamTypes[j], varType) || requiredParamValues != null && j < requiredParamValues.length && ReflectionUtil.isCoercibleFrom(requiredParamValues[j], varType)) continue;
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (candidateParamTypes[i].equals(requiredParamTypes[i])) continue;
                if (ReflectionUtil.isAssignableFrom(requiredParamTypes[i], candidateParamTypes[i])) {
                    assignable = true;
                    continue;
                }
                if (requiredParamValues == null || i >= requiredParamValues.length) {
                    noMatch = true;
                    break;
                }
                if (ReflectionUtil.isCoercibleFrom(requiredParamValues[i], candidateParamTypes[i])) {
                    coercible = true;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (varArgs) {
                varArgsCandidates.add(wrapper);
                continue;
            }
            if (coercible) {
                coercibleCandidates.add(wrapper);
                continue;
            }
            if (assignable) {
                assignableCandidates.add(wrapper);
                continue;
            }
            return wrapper;
        }
        String errorMsg = MessageFactory.get("error.method.ambiguous", clazz, name, ReflectionUtil.paramString(requiredParamTypes));
        if (!assignableCandidates.isEmpty()) {
            return ReflectionUtil.findMostSpecificWrapper(assignableCandidates, requiredParamTypes, false, errorMsg);
        }
        if (!coercibleCandidates.isEmpty()) {
            return ReflectionUtil.findMostSpecificWrapper(coercibleCandidates, requiredParamTypes, true, errorMsg);
        }
        if (!varArgsCandidates.isEmpty()) {
            return ReflectionUtil.findMostSpecificWrapper(varArgsCandidates, requiredParamTypes, true, errorMsg);
        }
        throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", clazz, name, ReflectionUtil.paramString(requiredParamTypes)));
    }

    private static int getParamCount(Class<?>[] paramTypes) {
        if (paramTypes == null) {
            return 0;
        }
        return paramTypes.length;
    }

    private static Wrapper findMostSpecificWrapper(List<Wrapper> candidates, Class<?>[] matchingTypes, boolean elSpecific, String errorMsg) {
        ArrayList<Wrapper> ambiguouses = new ArrayList<Wrapper>();
        for (Wrapper candidate : candidates) {
            boolean lessSpecific = false;
            Iterator it = ambiguouses.iterator();
            while (it.hasNext()) {
                int result = ReflectionUtil.isMoreSpecific(candidate, (Wrapper)it.next(), matchingTypes, elSpecific);
                if (result == 1) {
                    it.remove();
                    continue;
                }
                if (result != -1) continue;
                lessSpecific = true;
            }
            if (lessSpecific) continue;
            ambiguouses.add(candidate);
        }
        if (ambiguouses.size() > 1) {
            throw new MethodNotFoundException(errorMsg);
        }
        return (Wrapper)ambiguouses.get(0);
    }

    private static int isMoreSpecific(Wrapper wrapper1, Wrapper wrapper2, Class<?>[] matchingTypes, boolean elSpecific) {
        Class<?>[] paramTypes1 = wrapper1.getParameterTypes();
        Class<?>[] paramTypes2 = wrapper2.getParameterTypes();
        if (wrapper1.isVarArgs()) {
            int length = Math.max(Math.max(paramTypes1.length, paramTypes2.length), matchingTypes.length);
            paramTypes1 = ReflectionUtil.getComparingParamTypesForVarArgsMethod(paramTypes1, length);
            paramTypes2 = ReflectionUtil.getComparingParamTypesForVarArgsMethod(paramTypes2, length);
            if (length > matchingTypes.length) {
                Class[] matchingTypes2 = new Class[length];
                System.arraycopy(matchingTypes, 0, matchingTypes2, 0, matchingTypes.length);
                matchingTypes = matchingTypes2;
            }
        }
        int result = 0;
        for (int i = 0; i < paramTypes1.length; ++i) {
            if (paramTypes1[i] == paramTypes2[i]) continue;
            int r2 = ReflectionUtil.isMoreSpecific(paramTypes1[i], paramTypes2[i], matchingTypes[i], elSpecific);
            if (r2 == 1) {
                if (result == -1) {
                    return 0;
                }
                result = 1;
                continue;
            }
            if (r2 == -1) {
                if (result == 1) {
                    return 0;
                }
                result = -1;
                continue;
            }
            return 0;
        }
        if (result == 0) {
            result = Boolean.compare(wrapper1.isBridge(), wrapper2.isBridge());
        }
        return result;
    }

    private static int isMoreSpecific(Class<?> type1, Class<?> type2, Class<?> matchingType, boolean elSpecific) {
        type1 = ReflectionUtil.getBoxingTypeIfPrimitive(type1);
        if ((type2 = ReflectionUtil.getBoxingTypeIfPrimitive(type2)).isAssignableFrom(type1)) {
            return 1;
        }
        if (type1.isAssignableFrom(type2)) {
            return -1;
        }
        if (!elSpecific) {
            return 0;
        }
        if (matchingType != null && Number.class.isAssignableFrom(matchingType)) {
            boolean b2;
            boolean b1 = Number.class.isAssignableFrom(type1) || type1.isPrimitive();
            boolean bl = b2 = Number.class.isAssignableFrom(type2) || type2.isPrimitive();
            if (b1 && !b2) {
                return 1;
            }
            if (b2 && !b1) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    private static Class<?> getBoxingTypeIfPrimitive(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        return Double.class;
    }

    private static Class<?>[] getComparingParamTypesForVarArgsMethod(Class<?>[] paramTypes, int length) {
        Class[] result = new Class[length];
        System.arraycopy(paramTypes, 0, result, 0, paramTypes.length - 1);
        Class<?> type2 = paramTypes[paramTypes.length - 1].getComponentType();
        for (int i = paramTypes.length - 1; i < length; ++i) {
            result[i] = type2;
        }
        return result;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder paramString = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    paramString.append("null, ");
                    continue;
                }
                paramString.append(types[i].getName()).append(", ");
            }
            if (paramString.length() > 2) {
                paramString.setLength(paramString.length() - 2);
            }
            return paramString.toString();
        }
        return null;
    }

    static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        return ReflectionUtil.getBoxingTypeIfPrimitive(target).isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(Object src, Class<?> target) {
        try {
            ELSupport.coerceToType(null, src, target);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : values[i].getClass();
        }
        return result;
    }

    static Method getMethod(Class<?> type2, Method method) {
        if (method == null || Modifier.isPublic(type2.getModifiers())) {
            return method;
        }
        Class<?>[] interfaces = type2.getInterfaces();
        Method publicMethod = null;
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                publicMethod = interfaces[i].getMethod(method.getName(), method.getParameterTypes());
                publicMethod = ReflectionUtil.getMethod(publicMethod.getDeclaringClass(), publicMethod);
                if (publicMethod == null) continue;
                return publicMethod;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> superClass = type2.getSuperclass();
        if (superClass != null) {
            try {
                publicMethod = superClass.getMethod(method.getName(), method.getParameterTypes());
                publicMethod = ReflectionUtil.getMethod(publicMethod.getDeclaringClass(), publicMethod);
                if (publicMethod != null) {
                    return publicMethod;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static Constructor<?> getConstructor(Class<?> type2, Constructor<?> constructor) {
        if (constructor == null || Modifier.isPublic(type2.getModifiers())) {
            return constructor;
        }
        Constructor<?> publicConstructor = null;
        Class<?> superClass = type2.getSuperclass();
        if (superClass != null) {
            try {
                publicConstructor = superClass.getConstructor(constructor.getParameterTypes());
                publicConstructor = ReflectionUtil.getConstructor(publicConstructor.getDeclaringClass(), publicConstructor);
                if (publicConstructor != null) {
                    return publicConstructor;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object[] buildParameters(ELContext context, Class<?>[] parameterTypes, boolean isVarArgs, Object[] params) {
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            int paramCount;
            parameters = new Object[parameterTypes.length];
            int n = paramCount = params == null ? 0 : params.length;
            if (isVarArgs) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i = 0; i < varArgIndex && i < paramCount; ++i) {
                    parameters[i] = context.convertToType(params[i], parameterTypes[i]);
                }
                if (parameterTypes.length == paramCount && parameterTypes[varArgIndex] == params[varArgIndex].getClass()) {
                    parameters[varArgIndex] = params[varArgIndex];
                } else {
                    Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                    Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                    for (int i = varArgIndex; i < paramCount; ++i) {
                        Array.set(varargs, i - varArgIndex, context.convertToType(params[i], varArgClass));
                    }
                    parameters[varArgIndex] = varargs;
                }
            } else {
                for (int i = 0; i < parameterTypes.length && i < paramCount; ++i) {
                    parameters[i] = context.convertToType(params[i], parameterTypes[i]);
                }
            }
        }
        return parameters;
    }

    private static class MethodWrapper
    extends Wrapper {
        private final Method method;

        public MethodWrapper(Method method) {
            this.method = method;
        }

        @Override
        public Object unWrap() {
            return this.method;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return this.method.isBridge();
        }
    }

    private static abstract class Wrapper {
        private Wrapper() {
        }

        public static List<Wrapper> wrap(Method[] methods, String name) {
            ArrayList<Wrapper> result = new ArrayList<Wrapper>();
            for (Method method : methods) {
                if (!method.getName().equals(name)) continue;
                result.add(new MethodWrapper(method));
            }
            return result;
        }

        public abstract Object unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();

        public abstract boolean isBridge();
    }
}

