/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.def;

import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.glassfish.exousia.AuthorizationService;
import org.glassfish.exousia.modules.def.DefaultPolicyConfiguration;
import org.glassfish.exousia.spi.PrincipalMapper;

public class DefaultPolicy
extends Policy {
    private static final System.Logger LOG = System.getLogger(DefaultPolicy.class.getName());
    private final Policy defaultPolicy = this.getDefaultPolicy();

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        Subject subject;
        PolicyConfiguration policyConfiguration = this.getPolicyConfigurationFactory().getPolicyConfiguration();
        PrincipalMapper roleMapper = ((DefaultPolicyConfiguration)policyConfiguration).getRoleMapper();
        if (this.isExcluded(policyConfiguration.getExcludedPermissions(), permission)) {
            return false;
        }
        if (this.isUnchecked(policyConfiguration.getUncheckedPermissions(), permission)) {
            return true;
        }
        List<Principal> currentUserPrincipals = Arrays.asList(domain.getPrincipals());
        if (!roleMapper.isAnyAuthenticatedUserRoleMapped() && !currentUserPrincipals.isEmpty() && this.hasAccessViaRole(policyConfiguration.getPerRolePermissions(), "**", permission)) {
            return true;
        }
        try {
            subject = (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
        }
        catch (PolicyContextException ex) {
            throw new RuntimeException(ex);
        }
        if (this.hasAccessViaRoles(policyConfiguration.getPerRolePermissions(), roleMapper.getMappedRoles(currentUserPrincipals, subject), permission)) {
            return true;
        }
        if (this.defaultPolicy != null) {
            return this.defaultPolicy.implies(domain, permission);
        }
        return false;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Subject subject;
        Permissions permissions = new Permissions();
        PolicyConfiguration policyConfiguration = this.getPolicyConfigurationFactory().getPolicyConfiguration();
        PrincipalMapper roleMapper = this.getRoleMapper(policyConfiguration);
        PermissionCollection excludedPermissions = policyConfiguration.getExcludedPermissions();
        if (this.defaultPolicy != null) {
            this.collectPermissions(this.defaultPolicy.getPermissions(domain), permissions, excludedPermissions);
        }
        if (domain.getPermissions() != null) {
            this.collectPermissions(domain.getPermissions(), permissions, excludedPermissions);
        }
        this.collectPermissions(policyConfiguration.getUncheckedPermissions(), permissions, excludedPermissions);
        try {
            subject = (Subject)PolicyContext.getContext("javax.security.auth.Subject.container");
        }
        catch (PolicyContextException ex) {
            throw new RuntimeException(ex);
        }
        Map<String, PermissionCollection> perRolePermissions = policyConfiguration.getPerRolePermissions();
        for (String role : roleMapper.getMappedRoles(domain.getPrincipals(), subject)) {
            if (!perRolePermissions.containsKey(role)) continue;
            this.collectPermissions(perRolePermissions.get(role), permissions, excludedPermissions);
        }
        return permissions;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Permissions permissions = new Permissions();
        PolicyConfiguration policyConfiguration = this.getPolicyConfigurationFactory().getPolicyConfiguration();
        PermissionCollection excludedPermissions = policyConfiguration.getExcludedPermissions();
        if (this.defaultPolicy != null) {
            this.collectPermissions(this.defaultPolicy.getPermissions(codesource), permissions, excludedPermissions);
        }
        this.collectPermissions(policyConfiguration.getUncheckedPermissions(), permissions, excludedPermissions);
        return permissions;
    }

    private PolicyConfigurationFactory getPolicyConfigurationFactory() {
        try {
            return PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (PolicyContextException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Policy getDefaultPolicy() {
        Policy policy = AuthorizationService.getPolicy();
        if (policy instanceof DefaultPolicy) {
            LOG.log(System.Logger.Level.WARNING, "Cannot obtain default / previous policy.");
            return null;
        }
        return policy;
    }

    private PrincipalMapper getRoleMapper(PolicyConfiguration policyConfiguration) {
        return ((DefaultPolicyConfiguration)policyConfiguration).getRoleMapper();
    }

    private boolean isExcluded(PermissionCollection excludedPermissions, Permission permission) {
        if (excludedPermissions.implies(permission)) {
            return true;
        }
        for (Permission excludedPermission : Collections.list(excludedPermissions.elements())) {
            if (!permission.implies(excludedPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnchecked(PermissionCollection uncheckedPermissions, Permission permission) {
        return uncheckedPermissions.implies(permission);
    }

    private boolean hasAccessViaRoles(Map<String, PermissionCollection> perRolePermissions, List<String> roles, Permission permission) {
        for (String role : roles) {
            if (!this.hasAccessViaRole(perRolePermissions, role, permission)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAccessViaRole(Map<String, PermissionCollection> perRolePermissions, String role, Permission permission) {
        return perRolePermissions.containsKey(role) && perRolePermissions.get(role).implies(permission);
    }

    private void collectPermissions(PermissionCollection sourcePermissions, PermissionCollection targetPermissions, PermissionCollection excludedPermissions) {
        boolean hasExcludedPermissions = excludedPermissions.elements().hasMoreElements();
        for (Permission permission : Collections.list(sourcePermissions.elements())) {
            if (hasExcludedPermissions && this.isExcluded(excludedPermissions, permission)) continue;
            targetPermissions.add(permission);
        }
    }
}

