/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia;

import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.glassfish.exousia.DefaultPolicyContextHandler;
import org.glassfish.exousia.PolicyJDK24;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.transformer.ConstraintsToPermissionsTransformer;
import org.glassfish.exousia.mapping.SecurityRoleRef;
import org.glassfish.exousia.modules.def.DefaultPolicy;
import org.glassfish.exousia.modules.def.DefaultPolicyConfigurationFactory;
import org.glassfish.exousia.permissions.JakartaPermissions;
import org.glassfish.exousia.permissions.RolesToPermissionsTransformer;
import org.glassfish.exousia.spi.PrincipalMapper;

public class AuthorizationService {
    private static final System.Logger LOG = System.getLogger(AuthorizationService.class.getName());
    private static final boolean isSecMgrOff = System.getSecurityManager() == null;
    public static final String HTTP_SERVLET_REQUEST = "jakarta.servlet.http.HttpServletRequest";
    public static final String SUBJECT = "javax.security.auth.Subject.container";
    public static final String FACTORY = "jakarta.security.jacc.PolicyConfigurationFactory.provider";
    public static final String ENTERPRISE_BEAN = "jakarta.ejb.EnterpriseBean";
    public static final String ENTERPRISE_BEAN_ARGUMENTS = "jakarta.ejb.arguments";
    public static final String PRINCIPAL_MAPPER = "jakarta.authorization.PrincipalMapper.provider";
    private final String contextId;
    private Function<Set<Principal>, ProtectionDomain> protectionDomainCreator = this::newProtectionDomain;
    private final Policy policy;
    private final PolicyConfigurationFactory factory;
    private final PolicyConfiguration policyConfiguration;
    private final CodeSource emptyCodeSource = new CodeSource(null, (Certificate[])null);
    private final ProtectionDomain emptyProtectionDomain = this.newProtectionDomain(null);
    private String constrainedUriRequestAttribute;

    public AuthorizationService(ServletContext servletContext, Supplier<Subject> subjectSupplier) {
        this(DefaultPolicyConfigurationFactory.class, DefaultPolicy.class, AuthorizationService.getServletContextId(servletContext), subjectSupplier);
    }

    public AuthorizationService(String contextId, Supplier<Subject> subjectSupplier) {
        this(DefaultPolicyConfigurationFactory.class, DefaultPolicy.class, contextId, subjectSupplier);
    }

    public AuthorizationService(Class<?> factoryClass, Class<? extends Policy> policyClass, String contextId, Supplier<Subject> subjectSupplier) {
        this(factoryClass, policyClass, contextId, subjectSupplier, null);
    }

    public AuthorizationService(Class<?> factoryClass, Class<? extends Policy> policyClass, String contextId, Supplier<Subject> subjectSupplier, PrincipalMapper principalMapper) {
        this(AuthorizationService.installFactory(factoryClass), AuthorizationService.installPolicy(policyClass), contextId, subjectSupplier, principalMapper);
    }

    public AuthorizationService(String contextId, Supplier<Subject> subjectSupplier, PrincipalMapper principalMapper) {
        this(AuthorizationService.getFactory(), AuthorizationService.getPolicy(), contextId, subjectSupplier, principalMapper);
    }

    public AuthorizationService(PolicyConfigurationFactory factory, Policy policy, String contextId, Supplier<Subject> subjectSupplier, PrincipalMapper principalMapper) {
        try {
            this.factory = factory;
            this.policyConfiguration = factory.getPolicyConfiguration(contextId, false);
            this.policy = AuthorizationService.getPolicy();
            this.contextId = contextId;
            PolicyContext.setContextID(contextId);
            PolicyContext.registerHandler(SUBJECT, new DefaultPolicyContextHandler(SUBJECT, subjectSupplier), true);
            PolicyContext.registerHandler(PRINCIPAL_MAPPER, new DefaultPolicyContextHandler(PRINCIPAL_MAPPER, () -> principalMapper), true);
        }
        catch (PolicyContextException | IllegalArgumentException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setRequestSupplier(Supplier<HttpServletRequest> requestSupplier) {
        try {
            PolicyContext.registerHandler(HTTP_SERVLET_REQUEST, new DefaultPolicyContextHandler(HTTP_SERVLET_REQUEST, requestSupplier), true);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setSubjectSupplier(Supplier<Subject> subjectSupplier) {
        try {
            PolicyContext.registerHandler(SUBJECT, new DefaultPolicyContextHandler(SUBJECT, subjectSupplier), true);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setEnterpriseBeanSupplier(Supplier<Object> beanSupplier) {
        try {
            PolicyContext.registerHandler(ENTERPRISE_BEAN, new DefaultPolicyContextHandler(ENTERPRISE_BEAN, beanSupplier), true);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public Function<Set<Principal>, ProtectionDomain> getProtectionDomainCreator() {
        return this.protectionDomainCreator;
    }

    public void setProtectionDomainCreator(Function<Set<Principal>, ProtectionDomain> protectionDomainCreator) {
        this.protectionDomainCreator = protectionDomainCreator;
    }

    public String getConstrainedUriRequestAttribute() {
        return this.constrainedUriRequestAttribute;
    }

    public void setConstrainedUriRequestAttribute(String constrainedUriRequestAttribute) {
        this.constrainedUriRequestAttribute = constrainedUriRequestAttribute;
    }

    public void addConstraintsToPolicy(List<SecurityConstraint> securityConstraints, Set<String> declaredRoles, boolean isDenyUncoveredHttpMethods, Map<String, List<SecurityRoleRef>> servletRoleMappings) {
        try {
            JakartaPermissions jakartaResourceDataPermissions = ConstraintsToPermissionsTransformer.createResourceAndDataPermissions(declaredRoles, isDenyUncoveredHttpMethods, securityConstraints);
            this.addPermissionsToPolicy(jakartaResourceDataPermissions);
            JakartaPermissions jakartaRoleRefPermissions = RolesToPermissionsTransformer.createWebRoleRefPermission(declaredRoles, servletRoleMappings);
            this.addPermissionsToPolicy(jakartaRoleRefPermissions);
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addPermissionsToPolicy(JakartaPermissions jakartaPermissions) {
        try {
            this.policyConfiguration.addToExcludedPolicy(jakartaPermissions.getExcluded());
            this.policyConfiguration.addToUncheckedPolicy(jakartaPermissions.getUnchecked());
            for (Map.Entry<String, Permissions> roleEntry : jakartaPermissions.getPerRole().entrySet()) {
                this.policyConfiguration.addToRole(roleEntry.getKey(), roleEntry.getValue());
            }
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void removeStatementsFromPolicy(Set<String> declaredRoles) {
        try {
            boolean inService = this.factory.inService(this.contextId);
            PolicyConfiguration policyConfiguration = this.factory.getPolicyConfiguration(this.contextId, false);
            policyConfiguration.removeUncheckedPolicy();
            policyConfiguration.removeExcludedPolicy();
            if (declaredRoles != null) {
                for (String role : declaredRoles) {
                    policyConfiguration.removeRole(role);
                }
            }
            policyConfiguration.removeRole("*");
            policyConfiguration.removeRole("*");
            if (inService) {
                this.policy.refresh();
            }
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean linkPolicy(String linkedContextId, boolean lastInService) {
        try {
            boolean inService = this.factory.inService(this.contextId);
            if (linkedContextId == null) {
                return inService;
            }
            if (inService != lastInService) {
                throw new IllegalStateException("Inconsistent Module State");
            }
            if (!inService) {
                PolicyConfiguration policyConfiguration = this.factory.getPolicyConfiguration(this.contextId, false);
                PolicyConfiguration linkedPolicyConfiguration = this.factory.getPolicyConfiguration(linkedContextId, false);
                policyConfiguration.linkConfiguration(linkedPolicyConfiguration);
            }
            return lastInService;
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    public static boolean linkPolicy(String contextId, String linkedContextId, boolean lastInService) {
        try {
            PolicyConfigurationFactory factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            boolean inService = factory.inService(contextId);
            if (linkedContextId == null) {
                return inService;
            }
            if (inService != lastInService) {
                throw new IllegalStateException("Inconsistent Module State");
            }
            if (!inService) {
                PolicyConfiguration policyConfiguration = factory.getPolicyConfiguration(contextId, false);
                PolicyConfiguration linkedPolicyConfiguration = factory.getPolicyConfiguration(linkedContextId, false);
                policyConfiguration.linkConfiguration(linkedPolicyConfiguration);
            }
            return lastInService;
        }
        catch (PolicyContextException | ClassNotFoundException pce) {
            throw new IllegalStateException(pce.toString());
        }
    }

    public void commitPolicy() {
        try {
            if (!this.factory.inService(this.contextId)) {
                this.policyConfiguration.commit();
                LOG.log(System.Logger.Level.DEBUG, "Committed policy for context: {0}", this.contextId);
            }
            this.policy.refresh();
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException(pce);
        }
    }

    public static void commitPolicy(String contextId) {
        try {
            PolicyConfigurationFactory configurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            if (!configurationFactory.inService(contextId)) {
                configurationFactory.getPolicyConfiguration(contextId, false).commit();
                LOG.log(System.Logger.Level.DEBUG, "Committed policy for context: {0}", contextId);
            }
            AuthorizationService.getPolicy().refresh();
        }
        catch (PolicyContextException | ClassNotFoundException pce) {
            throw new IllegalStateException(pce);
        }
    }

    public void refresh() {
        try {
            if (this.factory.inService(this.contextId)) {
                this.policy.refresh();
            }
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public boolean checkWebUserDataPermission(HttpServletRequest request) {
        return this.checkPermission(new WebUserDataPermission(request));
    }

    public boolean checkWebUserDataPermission(String uri, String httpMethod, boolean requestIsSecure) {
        String[] stringArray;
        if (httpMethod == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = httpMethod;
        }
        return this.checkPermission(new WebUserDataPermission(uri, stringArray, requestIsSecure ? "CONFIDENTIAL" : null));
    }

    public boolean checkWebUserDataPermission(String uri, String httpMethod, boolean requestIsSecure, Set<Principal> principals) {
        String[] stringArray;
        if (httpMethod == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = httpMethod;
        }
        return this.checkPermission(new WebUserDataPermission(uri, stringArray, requestIsSecure ? "CONFIDENTIAL" : null), principals);
    }

    public boolean checkPublicWebResourcePermission(HttpServletRequest request) {
        return this.checkPermission(new WebResourcePermission(this.getConstrainedURI(request), request.getMethod()));
    }

    public boolean checkWebResourcePermission(HttpServletRequest request) {
        try {
            Subject subject = (Subject)PolicyContext.getContext(SUBJECT);
            return this.checkWebResourcePermission(request, subject == null ? null : subject.getPrincipals());
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean checkWebResourcePermission(HttpServletRequest request, Set<Principal> principals) {
        return this.checkPermission(new WebResourcePermission(this.getConstrainedURI(request), request.getMethod()), principals);
    }

    public boolean checkWebRoleRefPermission(String servletName, String role) {
        try {
            Subject subject = (Subject)PolicyContext.getContext(SUBJECT);
            return this.checkWebRoleRefPermission(servletName, role, subject == null ? null : subject.getPrincipals());
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean checkWebRoleRefPermission(String servletName, String role, Set<Principal> principals) {
        return this.checkPermission(new WebRoleRefPermission(servletName, role), principals);
    }

    public boolean checkBeanRoleRefPermission(String beanName, String role, Set<Principal> principals) {
        EJBRoleRefPermission ejbRoleRefPermission = new EJBRoleRefPermission(beanName, role);
        boolean isCallerInRole = this.checkPermissionScoped(ejbRoleRefPermission, principals);
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, "checkBeanRoleRefPermission result: {0} for EJBRoleRefPermission[Name = {1}, Actions = {2}], Codesource = {3}", isCallerInRole, ejbRoleRefPermission.getName(), ejbRoleRefPermission.getActions(), this.protectionDomainCreator.apply(principals).getCodeSource());
        }
        return isCallerInRole;
    }

    public boolean checkBeanMethodPermission(String beanName, String methodInterface, Method method, Set<Principal> principals) {
        EJBMethodPermission methodPermission = new EJBMethodPermission(beanName, methodInterface, method);
        boolean authorized = this.checkPermissionScoped(methodPermission, principals);
        LOG.log(System.Logger.Level.DEBUG, "Authorization: Access Control Decision result: {0} for EJBMethodPermission[Name = {1}, Actions = {2}]", authorized, methodPermission.getName(), methodPermission.getActions());
        return authorized;
    }

    public Object invokeBeanMethod(Object bean, Method beanClassMethod, Object[] methodParameters) throws Throwable {
        return this.runInScope(() -> beanClassMethod.invoke(bean, methodParameters));
    }

    public void deletePolicy() {
        try {
            boolean wasInService = this.factory.inService(this.contextId);
            this.factory.getPolicyConfiguration(this.contextId, false).delete();
            if (wasInService) {
                this.policy.refresh();
            }
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException(pce);
        }
    }

    public static void deletePolicy(String contextId) {
        try {
            PolicyConfigurationFactory factory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            boolean wasInService = factory.inService(contextId);
            factory.getPolicyConfiguration(contextId, false).delete();
            if (wasInService) {
                AuthorizationService.getPolicy().refresh();
            }
        }
        catch (PolicyContextException | ClassNotFoundException pce) {
            throw new IllegalStateException(pce);
        }
    }

    boolean checkPermission(Permission permissionToBeChecked) {
        LOG.log(System.Logger.Level.DEBUG, "checkPermission(permissionToBeChecked={0})", permissionToBeChecked);
        return this.policy.implies(this.emptyProtectionDomain, permissionToBeChecked);
    }

    boolean checkPermission(Permission permissionToBeChecked, Set<Principal> principals) {
        LOG.log(System.Logger.Level.DEBUG, "checkPermission(permissionToBeChecked={0}, principals={1})", permissionToBeChecked, principals);
        return this.policy.implies(this.newProtectionDomain(principals), permissionToBeChecked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPermissionScoped(Permission permissionToBeChecked, Set<Principal> principals) {
        LOG.log(System.Logger.Level.DEBUG, "checkPermission(permissionToBeChecked={0}, principals={1})", permissionToBeChecked, principals);
        String oldContextId = null;
        try {
            oldContextId = AuthorizationService.setThreadContextId(this.contextId);
            boolean bl = this.policy.implies(this.protectionDomainCreator.apply(principals), permissionToBeChecked);
            return bl;
        }
        catch (Throwable t) {
            LOG.log(System.Logger.Level.ERROR, "Unexpected security exception", t);
        }
        finally {
            try {
                AuthorizationService.setPolicyContextChecked(oldContextId, this.contextId);
            }
            catch (Throwable ex) {
                LOG.log(System.Logger.Level.ERROR, "Unexpected exception manipulating policy context", ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runInScope(ThrowableSupplier<Object> supplier) throws Throwable {
        String oldContextId = AuthorizationService.setThreadContextId(this.contextId);
        try {
            Object object = supplier.get();
            return object;
        }
        finally {
            AuthorizationService.setPolicyContextChecked(oldContextId, this.contextId);
        }
    }

    private static PolicyConfigurationFactory installFactory(Class<?> factoryClass) {
        System.setProperty(FACTORY, factoryClass.getName());
        return AuthorizationService.getFactory();
    }

    private static Policy installPolicy(Class<? extends Policy> policyClass) {
        try {
            AuthorizationService.setPolicy(policyClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            return AuthorizationService.getPolicy();
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Policy getPolicy() {
        Policy policy = PolicyJDK24.getPolicy();
        if (policy == null) {
            policy = Policy.getPolicy();
        }
        return policy;
    }

    public static void setPolicy(Policy policy) {
        try {
            Policy.setPolicy(policy);
        }
        catch (UnsupportedOperationException e) {
            PolicyJDK24.setPolicy(policy);
        }
    }

    private static PolicyConfigurationFactory getFactory() {
        try {
            return PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (PolicyContextException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private ProtectionDomain newProtectionDomain(Set<Principal> principalSet) {
        return new ProtectionDomain(this.emptyCodeSource, null, null, principalSet == null ? null : (Principal[])principalSet.toArray(Principal[]::new));
    }

    private String getConstrainedURI(HttpServletRequest request) {
        String uri;
        if (this.constrainedUriRequestAttribute != null && (uri = (String)request.getAttribute(this.constrainedUriRequestAttribute)) != null) {
            return uri;
        }
        String relativeURI = this.getRequestRelativeURI(request);
        if (relativeURI.equals("/")) {
            return "";
        }
        return relativeURI.replaceAll(":", "%3A");
    }

    private String getRequestRelativeURI(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    public static String getServletContextId(ServletContext context) {
        return context.getVirtualServerName() + " " + context.getContextPath();
    }

    public static void setThreadContextId(ServletContext context) {
        PolicyContext.setContextID(AuthorizationService.getServletContextId(context));
    }

    public static String setThreadContextId(String contextId) {
        String oldContextId = PolicyContext.getContextID();
        AuthorizationService.setPolicyContextChecked(contextId, oldContextId);
        return oldContextId;
    }

    private static void setPolicyContextChecked(String newContextId, String oldContextId) {
        if (!(newContextId == null || oldContextId != null && oldContextId.equals(newContextId))) {
            LOG.log(System.Logger.Level.DEBUG, "Changing Policy Context ID: oldContextId = {0}, newContextId = {1}", oldContextId, newContextId);
            try {
                AuthorizationService.doPrivileged(() -> PolicyContext.setContextID(newContextId));
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    throw new IllegalStateException(e.getCause());
                }
                throw new IllegalStateException(e);
            }
        }
    }

    public static void doPrivileged(PrivilegedExceptionRunnable runnable) throws Exception {
        if (isSecMgrOff) {
            runnable.run();
        }
        AccessController.doPrivileged(() -> {
            runnable.run();
            return null;
        });
    }

    @FunctionalInterface
    public static interface ThrowableSupplier<T> {
        public T get() throws Throwable;
    }

    @FunctionalInterface
    private static interface PrivilegedExceptionRunnable {
        public void run() throws PrivilegedActionException;
    }
}

