/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.services;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.config.AuthConfig;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.glassfish.epicyro.config.helper.AuthMessagePolicy;
import org.glassfish.epicyro.config.helper.Caller;
import org.glassfish.epicyro.config.servlet.HttpMessageInfo;
import org.glassfish.epicyro.services.AuthConfigRegistrationWrapper;
import org.glassfish.epicyro.services.ConfigData;
import org.glassfish.epicyro.services.RegistrationWrapperRemover;

public class BaseAuthenticationService {
    protected static final AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
    private static final String MESSAGE_INFO = BaseAuthenticationService.class.getName() + ".message.info";
    private ReadWriteLock readWriteLock;
    private Lock readLock;
    private Lock writeLock;
    protected String messageLayer;
    protected String appContextId;
    protected Map<String, Object> map;
    protected CallbackHandler callbackHandler;
    protected AuthConfigRegistrationWrapper listenerWrapper;

    protected void init(String messageLayer, String appContextId, Map<String, Object> properties, CallbackHandler callbackHandler, RegistrationWrapperRemover removerDelegate) {
        this.messageLayer = messageLayer;
        this.appContextId = appContextId;
        this.map = properties;
        this.callbackHandler = callbackHandler;
        if (this.callbackHandler == null) {
            this.callbackHandler = this.getCallbackHandler();
        }
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.listenerWrapper = new AuthConfigRegistrationWrapper(this.messageLayer, this.appContextId, removerDelegate);
    }

    public void setRegistrationId(String registrationId) {
        this.listenerWrapper.setRegistrationId(registrationId);
    }

    public AuthConfigRegistrationWrapper getRegistrationWrapper() {
        return this.listenerWrapper;
    }

    public void setRegistrationWrapper(AuthConfigRegistrationWrapper wrapper) {
        this.listenerWrapper = wrapper;
    }

    public AuthConfigRegistrationWrapper.AuthConfigRegistrationListener getRegistrationListener() {
        return this.listenerWrapper.getListener();
    }

    public void disable() {
        this.listenerWrapper.disable();
    }

    public Object getProperty(String key) {
        return this.map == null ? null : this.map.get(key);
    }

    public String getAppContextID() {
        return this.appContextId;
    }

    public ClientAuthConfig getClientAuthConfig() throws AuthException {
        return (ClientAuthConfig)this.getAuthConfig(false);
    }

    public ServerAuthConfig getServerAuthConfig() throws AuthException {
        return (ServerAuthConfig)this.getAuthConfig(true);
    }

    public ClientAuthContext getClientAuthContext(MessageInfo info, Subject clientSubject) throws AuthException {
        ClientAuthConfig clientConfig = (ClientAuthConfig)this.getAuthConfig(false);
        if (clientConfig != null) {
            return clientConfig.getAuthContext(clientConfig.getAuthContextID(info), clientSubject, this.map);
        }
        return null;
    }

    public ServerAuthContext getServerAuthContext(MessageInfo info) throws AuthException {
        return this.getServerAuthContext(info, null);
    }

    public ServerAuthContext getServerAuthContext(MessageInfo info, Subject serviceSubject) throws AuthException {
        ServerAuthConfig serverAuthConfig = (ServerAuthConfig)this.getAuthConfig(true);
        if (serverAuthConfig != null) {
            return serverAuthConfig.getAuthContext(serverAuthConfig.getAuthContextID(info), serviceSubject, this.map);
        }
        return null;
    }

    protected AuthConfig getAuthConfig(AuthConfigProvider authConfigProvider, boolean isServer) throws AuthException {
        AuthConfig authConfig = null;
        if (authConfigProvider != null) {
            authConfig = isServer ? authConfigProvider.getServerAuthConfig(this.messageLayer, this.appContextId, this.callbackHandler) : authConfigProvider.getClientAuthConfig(this.messageLayer, this.appContextId, this.callbackHandler);
        }
        return authConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthConfig getAuthConfig(boolean isServer) throws AuthException {
        ConfigData configData = null;
        AuthConfig authConfig = null;
        boolean disabled = false;
        AuthConfigProvider lastConfigProvider = null;
        try {
            this.readLock.lock();
            boolean bl = disabled = !this.listenerWrapper.isEnabled();
            if (!disabled && (configData = this.listenerWrapper.getConfigData()) != null) {
                authConfig = isServer ? configData.getServerConfig() : configData.getClientConfig();
                lastConfigProvider = configData.getProvider();
            }
        }
        finally {
            this.readLock.unlock();
            if (disabled || authConfig != null || configData != null && lastConfigProvider == null) {
                return authConfig;
            }
        }
        if (configData == null) {
            try {
                this.writeLock.lock();
                if (this.listenerWrapper.getConfigData() == null) {
                    AuthConfigProvider nextConfigProvider = authConfigFactory.getConfigProvider(this.messageLayer, this.appContextId, this.getRegistrationListener());
                    if (nextConfigProvider != null) {
                        this.listenerWrapper.setConfigData(new ConfigData(nextConfigProvider, this.getAuthConfig(nextConfigProvider, isServer)));
                    } else {
                        this.listenerWrapper.setConfigData(new ConfigData());
                    }
                }
                configData = this.listenerWrapper.getConfigData();
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return isServer ? configData.getServerConfig() : configData.getClientConfig();
    }

    protected boolean hasExactMatchAuthProvider() {
        boolean exactMatch = false;
        AuthConfigProvider configProvider = authConfigFactory.getConfigProvider(this.messageLayer, this.appContextId, null);
        if (configProvider != null) {
            for (String registrationId : authConfigFactory.getRegistrationIDs(configProvider)) {
                AuthConfigFactory.RegistrationContext registrationContext = authConfigFactory.getRegistrationContext(registrationId);
                if (!this.messageLayer.equals(registrationContext.getMessageLayer()) || !this.appContextId.equals(registrationContext.getAppContext())) continue;
                exactMatch = true;
                break;
            }
        }
        return exactMatch;
    }

    protected CallbackHandler getCallbackHandler() {
        return AuthMessagePolicy.getDefaultCallbackHandler();
    }

    public Caller login(String username, String password) {
        Subject subject = new Subject();
        try {
            PasswordValidationCallback passwordValidation = new PasswordValidationCallback(subject, username, password == null ? null : password.toCharArray());
            this.callbackHandler.handle(new Callback[]{passwordValidation});
            if (passwordValidation.getResult()) {
                return Caller.fromSubject(subject);
            }
            return null;
        }
        catch (IOException | RuntimeException | UnsupportedCallbackException e) {
            throw new IllegalStateException(e);
        }
    }

    public Caller validateRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, boolean calledFromAuthenticate, boolean isMandatory) throws IOException {
        Subject subject = new Subject();
        MessageInfo messageInfo = this.getMessageInfo(servletRequest, servletResponse);
        try {
            if (isMandatory || calledFromAuthenticate) {
                this.setMandatory(messageInfo);
            }
            if (!AuthStatus.SUCCESS.equals(this.getServerAuthContext(messageInfo).validateRequest(messageInfo, subject, null))) {
                return null;
            }
            return Caller.fromSubject(subject);
        }
        catch (AuthException | RuntimeException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean mustRegisterSession(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return this.isRegisterSession(this.getMessageInfo(servletRequest, servletResponse));
    }

    public HttpServletRequest getWrappedRequestIfSet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return (HttpServletRequest)this.getMessageInfo(servletRequest, servletResponse).getRequestMessage();
    }

    public HttpServletResponse getWrappedResponseIfSet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return (HttpServletResponse)this.getMessageInfo(servletRequest, servletResponse).getResponseMessage();
    }

    public void secureResponse(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        MessageInfo messageInfo = this.getMessageInfo(servletRequest, servletResponse);
        try {
            this.getServerAuthContext(messageInfo).secureResponse(messageInfo, null);
        }
        catch (AuthException e) {
            throw new IllegalStateException(e);
        }
    }

    public void clearSubject(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Subject subject) {
        MessageInfo messageInfo = this.getMessageInfo(servletRequest, servletResponse);
        try {
            this.getServerAuthContext(messageInfo).cleanSubject(messageInfo, subject);
        }
        catch (AuthException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isRegisterSession(MessageInfo messageInfo) {
        return Boolean.valueOf((String)messageInfo.getMap().get("jakarta.servlet.http.registerSession"));
    }

    private void setMandatory(MessageInfo messageInfo) {
        messageInfo.getMap().put("jakarta.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
    }

    private MessageInfo getMessageInfo(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        MessageInfo messageInfo = (MessageInfo)servletRequest.getAttribute(MESSAGE_INFO);
        if (messageInfo == null) {
            messageInfo = new HttpMessageInfo(servletRequest, servletResponse);
            this.saveMessageInfo(servletRequest, messageInfo);
        }
        return messageInfo;
    }

    private void saveMessageInfo(HttpServletRequest servletRequest, MessageInfo messageInfo) {
        servletRequest.setAttribute(MESSAGE_INFO, messageInfo);
    }
}

