/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.context;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.delegate.MessagePolicyDelegate;
import org.glassfish.epicyro.config.helper.ModulesManager;

public class ServerAuthContextImpl
implements ServerAuthContext {
    private static final AuthStatus[] validateRequestSuccessValues = new AuthStatus[]{AuthStatus.SUCCESS, AuthStatus.SEND_SUCCESS};
    private static final AuthStatus[] secureResponseSuccessValues = new AuthStatus[]{AuthStatus.SEND_SUCCESS};
    private String loggerName;
    private ModulesManager modulesManager;
    private MessagePolicyDelegate policyDelegate;
    private String appContext;
    private CallbackHandler callbackHandler;
    private String authContextID;
    private Map<String, ?> properties;
    private ServerAuthModule[] serverAuthModules;

    public ServerAuthContextImpl(String loggerName, ModulesManager modulesManager, MessagePolicyDelegate policyDelegate, String appContext, CallbackHandler callbackHandler, String authContextID, Map<String, ?> properties) {
        this.loggerName = loggerName;
        this.modulesManager = modulesManager;
        this.policyDelegate = policyDelegate;
        this.appContext = appContext;
        this.callbackHandler = callbackHandler;
        this.authContextID = authContextID;
        this.properties = properties;
        this.serverAuthModules = this.getServerAuthModules();
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        AuthStatus[] status = new AuthStatus[this.serverAuthModules.length];
        for (int moduleNumber = 0; moduleNumber < this.serverAuthModules.length; ++moduleNumber) {
            if (this.serverAuthModules[moduleNumber] == null) continue;
            if (this.isLoggable(Level.FINE)) {
                this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", this.authContextID, "of AppContext: ", this.appContext, "calling vaidateRequest on module");
            }
            status[moduleNumber] = this.serverAuthModules[moduleNumber].validateRequest(messageInfo, clientSubject, serviceSubject);
            if (!this.modulesManager.shouldStopProcessingModules(validateRequestSuccessValues, moduleNumber, status[moduleNumber])) continue;
            return this.modulesManager.getReturnStatus(validateRequestSuccessValues, AuthStatus.SEND_FAILURE, status, moduleNumber);
        }
        return this.modulesManager.getReturnStatus(validateRequestSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        AuthStatus[] status = new AuthStatus[this.serverAuthModules.length];
        for (int i = 0; i < this.serverAuthModules.length; ++i) {
            if (this.serverAuthModules[i] == null) continue;
            if (this.isLoggable(Level.FINE)) {
                this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", this.authContextID, "of AppContext: ", this.appContext, "calling secureResponse on module");
            }
            status[i] = this.serverAuthModules[i].secureResponse(messageInfo, serviceSubject);
            if (!this.modulesManager.shouldStopProcessingModules(secureResponseSuccessValues, i, status[i])) continue;
            return this.modulesManager.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, i);
        }
        return this.modulesManager.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
    }

    @Override
    public void cleanSubject(MessageInfo arg0, Subject arg1) throws AuthException {
        for (int i = 0; i < this.serverAuthModules.length; ++i) {
            if (this.serverAuthModules[i] == null) continue;
            if (this.isLoggable(Level.FINE)) {
                this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", this.authContextID, "of AppContext: ", this.appContext, "calling cleanSubject on module");
            }
            this.serverAuthModules[i].cleanSubject(arg0, arg1);
        }
    }

    private ServerAuthModule[] getServerAuthModules() {
        try {
            ServerAuthModule[] serverAuthModules;
            try {
                serverAuthModules = this.modulesManager.getModules(new ServerAuthModule[0], this.authContextID);
            }
            catch (AuthException ae) {
                this.logIfLevel(Level.SEVERE, ae, "ServerAuthContext: ", this.authContextID, "of AppContext: ", this.appContext, "unable to load server auth modules");
                throw ae;
            }
            MessagePolicy requestPolicy = this.policyDelegate.getRequestPolicy(this.authContextID, this.properties);
            MessagePolicy responsePolicy = this.policyDelegate.getResponsePolicy(this.authContextID, this.properties);
            boolean noModules = true;
            for (int i = 0; i < serverAuthModules.length; ++i) {
                if (serverAuthModules[i] == null) continue;
                if (this.isLoggable(Level.FINE)) {
                    this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", this.authContextID, "of AppContext: ", this.appContext, "initializing module");
                }
                noModules = false;
                this.checkMessageTypes(serverAuthModules[i].getSupportedMessageTypes());
                serverAuthModules[i].initialize(requestPolicy, responsePolicy, this.callbackHandler, this.modulesManager.getInitProperties(i, this.properties));
            }
            if (noModules) {
                this.logIfLevel(Level.WARNING, null, "ServerAuthContext: ", this.authContextID, "of AppContext: ", this.appContext, "contains no Auth Modules");
            }
            return serverAuthModules;
        }
        catch (AuthException e) {
            throw new IllegalStateException(e);
        }
    }

    protected boolean isLoggable(Level level) {
        return Logger.getLogger(this.loggerName).isLoggable(level);
    }

    protected void logIfLevel(Level level, Throwable t, String ... msgParts) {
        Logger logger2 = Logger.getLogger(this.loggerName);
        if (logger2.isLoggable(level)) {
            StringBuilder messageBuffer = new StringBuilder("");
            for (String m : msgParts) {
                messageBuffer.append(m);
            }
            String msg = messageBuffer.toString();
            if (!msg.isEmpty() && t != null) {
                logger2.log(level, msg, t);
            } else if (!msg.isEmpty()) {
                logger2.log(level, msg);
            }
        }
    }

    protected void checkMessageTypes(Class<?>[] supportedMessageTypes) throws AuthException {
        Class<?>[] requiredMessageTypes;
        for (Class<?> requiredType : requiredMessageTypes = this.policyDelegate.getMessageTypes()) {
            boolean supported = false;
            for (Class<?> supportedType : supportedMessageTypes) {
                if (!requiredType.isAssignableFrom(supportedType)) continue;
                supported = true;
            }
            if (supported) continue;
            throw new AuthException("module does not support message type: " + requiredType.getName());
        }
    }
}

