/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.configprovider;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import java.util.Locale;
import java.util.Map;
import org.glassfish.epicyro.config.helper.JAASModulesManager;
import org.glassfish.epicyro.config.helper.ModulesManager;
import org.glassfish.epicyro.config.jaas.ExtendedConfigFile;
import org.glassfish.epicyro.config.module.configprovider.BaseAuthConfigProvider;

public abstract class JAASAuthConfigProvider
extends BaseAuthConfigProvider {
    private static final String CONFIG_FILE_NAME_KEY = "config.file.name";
    private static final String DEFAULT_JAAS_APP_NAME = "other";
    private static final String ALL_APPS = "*";
    private ExtendedConfigFile jaasConfigFile;
    private Map<String, ?> properties;
    private AuthConfigFactory factory;

    public JAASAuthConfigProvider(Map<String, ?> properties, AuthConfigFactory factory) {
        this.properties = properties;
        this.factory = factory;
        this.jaasConfigFile = ExtendedConfigFile.fromFileName(this.getProperty(CONFIG_FILE_NAME_KEY, null));
        this.selfRegister();
    }

    @Override
    public Map<String, ?> getProperties() {
        return this.properties;
    }

    @Override
    public AuthConfigFactory getFactory() {
        return this.factory;
    }

    @Override
    public AuthConfigFactory.RegistrationContext[] getSelfRegistrationContexts() {
        String[] appContexts = this.jaasConfigFile.getAppNames(this.getModuleTypes());
        AuthConfigFactory.RegistrationContext[] selfRegistrationContexts = new AuthConfigFactory.RegistrationContext[appContexts.length];
        for (int i = 0; i < appContexts.length; ++i) {
            selfRegistrationContexts[i] = this.getRegistrationContext(appContexts[i]);
        }
        return selfRegistrationContexts;
    }

    @Override
    public ModulesManager getModulesManager(String appContext, boolean returnNullContexts) throws AuthException {
        return new JAASModulesManager(this.getLogManager(), returnNullContexts, this.jaasConfigFile, this.properties, appContext);
    }

    @Override
    public void refresh() {
        this.jaasConfigFile.refresh();
        super.refresh();
    }

    private AuthConfigFactory.RegistrationContext getRegistrationContext(String id) {
        final String layer = this.getLayer();
        final String appContext = id.toLowerCase(Locale.getDefault()).equals(DEFAULT_JAAS_APP_NAME) ? ALL_APPS : id;
        return new AuthConfigFactory.RegistrationContext(){
            String description;
            {
                this.description = "JAAS AuthConfig: " + appContext;
            }

            @Override
            public String getMessageLayer() {
                return layer;
            }

            @Override
            public String getAppContext() {
                return appContext;
            }

            @Override
            public String getDescription() {
                return this.description;
            }

            @Override
            public boolean isPersistent() {
                return false;
            }
        };
    }
}

