/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.configprovider;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.module.ClientAuthModule;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.delegate.MessagePolicyDelegate;
import org.glassfish.epicyro.config.helper.EpochCarrier;
import org.glassfish.epicyro.config.helper.LogManager;
import org.glassfish.epicyro.config.helper.ModulesManager;
import org.glassfish.epicyro.config.module.config.ClientAuthConfigImpl;
import org.glassfish.epicyro.config.module.config.ServerAuthConfigImpl;

public abstract class BaseAuthConfigProvider
implements AuthConfigProvider {
    public static final String LAYER_NAME_KEY = "message.layer";
    public static final String ALL_LAYERS = "*";
    public static final String LOGGER_NAME_KEY = "logger.name";
    public static final String AUTH_MODULE_KEY = "auth.module.type";
    public static final String SERVER_AUTH_MODULE = "server.auth.module";
    public static final String CLIENT_AUTH_MODULE = "client.auth.module";
    private ReentrantReadWriteLock instanceReadWriteLock = new ReentrantReadWriteLock();
    private Lock writeLock = this.instanceReadWriteLock.writeLock();
    private HashSet<String> selfRegistered = new HashSet();
    private EpochCarrier epochCarrier = new EpochCarrier();

    @Override
    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) throws AuthException {
        return new ClientAuthConfigImpl(this.getLoggerName(), this.epochCarrier, this.getModulesManager(appContext, true), this.getMessagePolicyDelegate(appContext), layer, appContext, this.getClientCallbackHandler(callbackHandler));
    }

    @Override
    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler callbackHandler) throws AuthException {
        return new ServerAuthConfigImpl(this.getLoggerName(), this.epochCarrier, this.getModulesManager(appContext, true), this.getMessagePolicyDelegate(appContext), layer, appContext, this.getServerCallbackHandler(callbackHandler));
    }

    public boolean contextsAreEqual(AuthConfigFactory.RegistrationContext context1, AuthConfigFactory.RegistrationContext context2) {
        if (context1 == null || context2 == null) {
            return false;
        }
        if (context1.isPersistent() != context2.isPersistent()) {
            return false;
        }
        if (!context1.getAppContext().equals(context2.getAppContext())) {
            return false;
        }
        if (!context1.getMessageLayer().equals(context2.getMessageLayer())) {
            return false;
        }
        return context1.getDescription().equals(context2.getDescription());
    }

    @Override
    public void refresh() {
        this.epochCarrier.increment();
        this.selfRegister();
    }

    public String getLoggerName() {
        return this.getProperty(LOGGER_NAME_KEY, BaseAuthConfigProvider.class.getName());
    }

    public LogManager getLogManager() {
        return new LogManager(this.getLoggerName());
    }

    protected final String getProperty(String key, String defaultValue) {
        Map<String, ?> properties = this.getProperties();
        if (properties != null && properties.containsKey(key)) {
            return (String)properties.get(key);
        }
        return defaultValue;
    }

    protected String getLayer() {
        return this.getProperty(LAYER_NAME_KEY, ALL_LAYERS);
    }

    protected Class<?>[] getModuleTypes() {
        Class[] moduleTypes = new Class[]{ServerAuthModule.class, ClientAuthModule.class};
        Map<String, ?> properties = this.getProperties();
        if (properties.containsKey(AUTH_MODULE_KEY)) {
            String keyValue = (String)properties.get(AUTH_MODULE_KEY);
            if (SERVER_AUTH_MODULE.equals(keyValue)) {
                moduleTypes = new Class[]{ServerAuthModule.class};
            } else if (CLIENT_AUTH_MODULE.equals(keyValue)) {
                moduleTypes = new Class[]{ClientAuthModule.class};
            }
        }
        return moduleTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selfRegister() {
        if (this.getFactory() != null) {
            this.writeLock.lock();
            try {
                AuthConfigFactory.RegistrationContext[] contexts = this.getSelfRegistrationContexts();
                if (!this.selfRegistered.isEmpty()) {
                    HashSet<String> toBeUnregistered = new HashSet<String>();
                    String[] registrationIDs = this.getFactory().getRegistrationIDs(this);
                    for (String registrationId : registrationIDs) {
                        AuthConfigFactory.RegistrationContext context;
                        if (!this.selfRegistered.contains(registrationId) || (context = this.getFactory().getRegistrationContext(registrationId)) == null || context.isPersistent()) continue;
                        toBeUnregistered.add(registrationId);
                    }
                    for (String registrationId : toBeUnregistered) {
                        AuthConfigFactory.RegistrationContext context = this.getFactory().getRegistrationContext(registrationId);
                        for (int j = 0; j < contexts.length; ++j) {
                            if (!this.contextsAreEqual(contexts[j], context)) continue;
                            toBeUnregistered.remove(registrationId);
                            contexts[j] = null;
                        }
                    }
                    for (String registrationId : toBeUnregistered) {
                        this.selfRegistered.remove(registrationId);
                        this.getFactory().removeRegistration(registrationId);
                    }
                }
                for (AuthConfigFactory.RegistrationContext context : contexts) {
                    if (context == null) continue;
                    String id = this.getFactory().registerConfigProvider(this, context.getMessageLayer(), context.getAppContext(), context.getDescription());
                    this.selfRegistered.add(id);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    protected CallbackHandler getClientCallbackHandler(CallbackHandler callbackHandler) throws AuthException {
        if (callbackHandler == null) {
            throw (AuthException)new AuthException("AuthConfigProvider does not support null Client Callbackhandler").initCause(new UnsupportedOperationException());
        }
        return callbackHandler;
    }

    protected CallbackHandler getServerCallbackHandler(CallbackHandler callbackHandler) throws AuthException {
        if (callbackHandler == null) {
            throw (AuthException)new AuthException("AuthConfigProvider does not support null Server Callbackhandler").initCause(new UnsupportedOperationException());
        }
        return callbackHandler;
    }

    public abstract Map<String, ?> getProperties();

    public abstract AuthConfigFactory getFactory();

    public abstract AuthConfigFactory.RegistrationContext[] getSelfRegistrationContexts();

    public abstract ModulesManager getModulesManager(String var1, boolean var2) throws AuthException;

    public abstract MessagePolicyDelegate getMessagePolicyDelegate(String var1) throws AuthException;
}

