/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.config;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.delegate.MessagePolicyDelegate;
import org.glassfish.epicyro.config.helper.EpochCarrier;
import org.glassfish.epicyro.config.helper.ModulesManager;
import org.glassfish.epicyro.config.module.config.BaseAuthConfigImpl;
import org.glassfish.epicyro.config.module.context.ServerAuthContextImpl;

public class ServerAuthConfigImpl
extends BaseAuthConfigImpl
implements ServerAuthConfig {
    private Map<String, Map<Integer, ServerAuthContext>> contextMap;
    private ModulesManager authContextHelper;

    public ServerAuthConfigImpl(String loggerName, EpochCarrier providerEpoch, ModulesManager authContextHelper, MessagePolicyDelegate policyDelegate, String layer, String appContext, CallbackHandler callbackHandler) throws AuthException {
        super(loggerName, providerEpoch, policyDelegate, layer, appContext, callbackHandler);
        this.authContextHelper = authContextHelper;
        this.policyDelegate = policyDelegate;
    }

    public ServerAuthContext getAuthContext(String authContextID, Subject subject, Map properties) throws AuthException {
        return (ServerAuthContext)super.getContext(this.contextMap, authContextID, subject, properties);
    }

    @Override
    public boolean isProtected() {
        return !this.authContextHelper.returnsNullContexts() || this.policyDelegate.isProtected();
    }

    @Override
    protected void initializeContextMap() {
        this.contextMap = new HashMap<String, Map<Integer, ServerAuthContext>>();
    }

    @Override
    protected <M> M createAuthContext(String authContextID, Map<String, ?> properties) throws AuthException {
        if (!this.authContextHelper.isProtected(new ServerAuthModule[0], authContextID)) {
            return null;
        }
        return (M)new ServerAuthContextImpl(this.loggerName, this.authContextHelper, this.policyDelegate, this.getAppContext(), this.callbackHandler, authContextID, properties);
    }
}

