/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager {
    public static final String PACKAGE_ROOT = "com.sun.logging.";
    public static final String RESOURCE_BUNDLE = "LogStrings";
    public static final String JASPIC_LOGGER = "enterprise.system.jaspic.security";
    public static final String RES_BUNDLE = "com.sun.logging.enterprise.system.jaspic.security.LogStrings";
    private String loggerName;

    public LogManager(String loggerName) {
        this.loggerName = loggerName;
    }

    protected boolean isLoggable(Level level) {
        return Logger.getLogger(this.loggerName).isLoggable(level);
    }

    protected void logIfLevel(Level level, Throwable t, String ... msgParts) {
        Logger logger2 = Logger.getLogger(this.loggerName);
        if (logger2.isLoggable(level)) {
            StringBuilder msgB = new StringBuilder();
            for (String m : msgParts) {
                msgB.append(m);
            }
            String msg = msgB.toString();
            if (!msg.isEmpty() && t != null) {
                logger2.log(level, msg, t);
            } else if (!msg.isEmpty()) {
                logger2.log(level, msg);
            }
        }
    }

    protected Logger getLogger(Level level) {
        Logger logger2 = Logger.getLogger(this.loggerName);
        if (logger2.isLoggable(level)) {
            return logger2;
        }
        return null;
    }
}

