/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.CertStoreCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.callback.PrivateKeyCallback;
import jakarta.security.auth.message.callback.SecretKeyCallback;
import jakarta.security.auth.message.callback.TrustStoreCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.glassfish.epicyro.config.helper.Caller;
import org.glassfish.epicyro.config.helper.CallerPrincipal;
import org.glassfish.epicyro.config.helper.ModuleConfigurationManager;
import org.glassfish.epicyro.services.InMemoryStore;

public abstract class BaseCallbackHandler
implements CallbackHandler {
    public static final Logger LOG = Logger.getLogger(ModuleConfigurationManager.class.getName());
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-1";

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            return;
        }
        for (Callback callback : callbacks) {
            if (this.isSupportedCallback(callback)) continue;
            throw new UnsupportedCallbackException(callback, callback.getClass().getName());
        }
        this.handleSupportedCallbacks(callbacks);
    }

    protected void processCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof CallerPrincipalCallback) {
            this.processCallerPrincipal((CallerPrincipalCallback)callback);
        } else if (callback instanceof GroupPrincipalCallback) {
            this.processGroupPrincipal((GroupPrincipalCallback)callback);
        } else if (callback instanceof PasswordValidationCallback) {
            this.processPasswordValidation((PasswordValidationCallback)callback);
        } else if (callback instanceof PrivateKeyCallback) {
            this.processPrivateKey((PrivateKeyCallback)callback);
        } else if (callback instanceof TrustStoreCallback) {
            this.processTrustStore((TrustStoreCallback)callback);
        } else if (callback instanceof CertStoreCallback) {
            this.processCertStore((CertStoreCallback)callback);
        } else if (callback instanceof SecretKeyCallback) {
            this.processSecretKey((SecretKeyCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void processCallerPrincipal(CallerPrincipalCallback callerPrincipalCallback) {
        Caller caller;
        Subject subject = callerPrincipalCallback.getSubject();
        Principal principal = callerPrincipalCallback.getPrincipal();
        if (principal == null) {
            principal = new CallerPrincipal(callerPrincipalCallback.getName());
        }
        if ((caller = Caller.fromSubject(subject)) == null) {
            Caller.toSubject(subject, new Caller(principal));
        } else {
            caller.setCallerPrincipal(principal);
        }
    }

    private void processGroupPrincipal(GroupPrincipalCallback groupCallback) {
        Subject subject = groupCallback.getSubject();
        String[] groups = groupCallback.getGroups();
        Caller caller = Caller.fromSubject(subject);
        if (groups != null && groups.length > 0) {
            if (caller == null) {
                Caller.toSubject(subject, new Caller(groups));
            } else {
                caller.addGroups(groups);
            }
        } else if (groups == null && caller != null) {
            caller.getGroups().clear();
        }
    }

    protected void processPasswordValidation(PasswordValidationCallback pwdCallback) {
        Caller caller = InMemoryStore.validate(pwdCallback.getUsername(), this.getPassword(pwdCallback));
        if (caller != null) {
            this.processCallerPrincipal(new CallerPrincipalCallback(pwdCallback.getSubject(), caller.getCallerPrincipal()));
            if (!caller.getGroups().isEmpty()) {
                this.processGroupPrincipal(new GroupPrincipalCallback(pwdCallback.getSubject(), caller.getGroupsAsArray()));
            }
            pwdCallback.setResult(true);
        }
    }

    protected void processTrustStore(TrustStoreCallback trustStoreCallback) {
        trustStoreCallback.setTrustStore(this.getTrustStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPrivateKey(PrivateKeyCallback privateKeyCallback) {
        Object[] keyStores = this.getKeyStores();
        if (BaseCallbackHandler.isEmpty(keyStores)) {
            privateKeyCallback.setKey(null, null);
            return;
        }
        PrivateKeyCallback.Request request = privateKeyCallback.getRequest();
        PrivateKey privateKey = null;
        Certificate[] certificateChain = null;
        if (request == null) {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.getDefaultPrivateKeyEntry((KeyStore[])keyStores);
            if (privateKeyEntry != null) {
                privateKey = privateKeyEntry.getPrivateKey();
                certificateChain = privateKeyEntry.getCertificateChain();
            }
            privateKeyCallback.setKey(privateKey, certificateChain);
            return;
        }
        try {
            if (request instanceof PrivateKeyCallback.AliasRequest) {
                PrivateKeyCallback.AliasRequest aliasRequest = (PrivateKeyCallback.AliasRequest)request;
                String alias = aliasRequest.getAlias();
                KeyStore.PrivateKeyEntry privateKeyEntry = alias == null ? this.getDefaultPrivateKeyEntry((KeyStore[])keyStores) : this.getPrivateKeyEntryFromTokenAlias(alias);
                if (privateKeyEntry != null) {
                    privateKey = privateKeyEntry.getPrivateKey();
                    certificateChain = privateKeyEntry.getCertificateChain();
                }
            } else if (request instanceof PrivateKeyCallback.IssuerSerialNumRequest) {
                PrivateKeyCallback.IssuerSerialNumRequest issuerSerialNumRequest = (PrivateKeyCallback.IssuerSerialNumRequest)request;
                X500Principal issuer = issuerSerialNumRequest.getIssuer();
                BigInteger serialNum = issuerSerialNumRequest.getSerialNum();
                if (issuer != null && serialNum != null) {
                    boolean found = false;
                    for (int i = 0; i < keyStores.length && !found; ++i) {
                        Enumeration<String> aliases = ((KeyStore)keyStores[i]).aliases();
                        while (aliases.hasMoreElements() && !found) {
                            Certificate[] certificates;
                            X509Certificate eeCert;
                            String nextAlias = aliases.nextElement();
                            PrivateKey key = this.getPrivateKeyForAlias(nextAlias, i);
                            if (key == null || !(eeCert = (X509Certificate)(certificates = ((KeyStore)keyStores[i]).getCertificateChain(nextAlias))[0]).getIssuerX500Principal().equals(issuer) || !eeCert.getSerialNumber().equals(serialNum)) continue;
                            privateKey = key;
                            certificateChain = certificates;
                            found = true;
                        }
                    }
                }
            } else if (request instanceof PrivateKeyCallback.SubjectKeyIDRequest) {
                PrivateKeyCallback.SubjectKeyIDRequest subjectKeyIDRequest = (PrivateKeyCallback.SubjectKeyIDRequest)request;
                byte[] subjectKeyID = subjectKeyIDRequest.getSubjectKeyID();
                if (subjectKeyID != null) {
                    boolean found = false;
                    X509CertSelector selector = new X509CertSelector();
                    selector.setSubjectKeyIdentifier(this.toDerOctetString(subjectKeyID));
                    for (int i = 0; i < keyStores.length && !found; ++i) {
                        Enumeration<String> aliases = ((KeyStore)keyStores[i]).aliases();
                        while (aliases.hasMoreElements() && !found) {
                            Certificate[] certificates;
                            String nextAlias = aliases.nextElement();
                            PrivateKey key = this.getPrivateKeyForAlias(nextAlias, i);
                            if (key == null || !selector.match((certificates = ((KeyStore)keyStores[i]).getCertificateChain(nextAlias))[0])) continue;
                            privateKey = key;
                            certificateChain = certificates;
                            found = true;
                        }
                    }
                }
            } else if (request instanceof PrivateKeyCallback.DigestRequest) {
                PrivateKeyCallback.DigestRequest digestRequest = (PrivateKeyCallback.DigestRequest)request;
                byte[] digest = digestRequest.getDigest();
                String algorithm = digestRequest.getAlgorithm();
                KeyStore.PrivateKeyEntry privateKeyEntry = null;
                if (digest == null) {
                    privateKeyEntry = this.getDefaultPrivateKeyEntry((KeyStore[])keyStores);
                } else {
                    if (algorithm == null) {
                        algorithm = DEFAULT_DIGEST_ALGORITHM;
                    }
                    MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
                    privateKeyEntry = this.getPrivateKeyEntry((KeyStore[])keyStores, messageDigest, digest);
                }
                if (privateKeyEntry != null) {
                    privateKey = privateKeyEntry.getPrivateKey();
                    certificateChain = privateKeyEntry.getCertificateChain();
                }
            } else {
                LOG.log(Level.FINE, () -> "invalid request type: " + request.getClass().getName());
            }
            privateKeyCallback.setKey(privateKey, certificateChain);
        }
        catch (Exception e) {
            try {
                LOG.log(Level.FINE, "Jakarta Authentication: In PrivateKeyCallback Processor: Error reading key !", e);
                privateKeyCallback.setKey(privateKey, certificateChain);
            }
            catch (Throwable throwable) {
                privateKeyCallback.setKey(privateKey, certificateChain);
                throw throwable;
            }
        }
    }

    protected KeyStore.PrivateKeyEntry getDefaultPrivateKeyEntry(KeyStore[] keyStores) {
        PrivateKey privateKey = null;
        Certificate[] certificates = null;
        try {
            for (int i = 0; i < keyStores.length && privateKey == null; ++i) {
                Enumeration<String> aliases = keyStores[i].aliases();
                while (aliases.hasMoreElements() && privateKey == null) {
                    String nextAlias = aliases.nextElement();
                    privateKey = null;
                    certificates = null;
                    PrivateKey key = this.getPrivateKeyForAlias(nextAlias, i);
                    if (key == null) continue;
                    privateKey = key;
                    certificates = keyStores[i].getCertificateChain(nextAlias);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Exception in getDefaultPrivateKeyEntry", e);
        }
        return new KeyStore.PrivateKeyEntry(privateKey, certificates);
    }

    protected PrivateKey getPrivateKeyForAlias(String alias, int keystoreIndex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return null;
    }

    protected KeyStore.PrivateKeyEntry getPrivateKeyEntryFromTokenAlias(String certNickname) throws Exception {
        return null;
    }

    protected void processCertStore(CertStoreCallback certStoreCallback) {
        LOG.log(Level.FINE, "Jakarta Authentication: In CertStoreCallback Processor");
        KeyStore certStore = this.getTrustStore();
        if (certStore == null) {
            certStoreCallback.setCertStore(null);
        }
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try {
            if (certStore != null) {
                for (String alias : Collections.list(certStore.aliases())) {
                    if (!certStore.isCertificateEntry(alias)) continue;
                    try {
                        certificates.add(certStore.getCertificate(alias));
                    }
                    catch (KeyStoreException kse) {
                        LOG.log(Level.FINE, () -> "Jakarta Authentication: Cannot retrieve certificate for alias " + alias);
                    }
                }
            }
            certStoreCallback.setCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(certificates)));
        }
        catch (KeyStoreException kse) {
            LOG.log(Level.FINE, "Jakarta Authentication:  Cannot determine truststore aliases", kse);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException nsape) {
            LOG.log(Level.FINE, "Jakarta Authentication:  Cannot instantiate CertStore", nsape);
        }
    }

    protected void processSecretKey(SecretKeyCallback secretKeyCallback) {
        LOG.log(Level.FINE, "Jakarta Authentication: In SecretKeyCallback Processor");
        String alias = ((SecretKeyCallback.AliasRequest)secretKeyCallback.getRequest()).getAlias();
        if (alias != null) {
            try {
                secretKeyCallback.setKey(this.getPasswordSecretKeyForAlias(alias));
            }
            catch (Exception e) {
                LOG.log(Level.FINE, e, () -> "Jakarta Authentication: In SecretKeyCallback Processor:  Error reading key ! for alias " + alias);
                secretKeyCallback.setKey(null);
            }
        } else {
            secretKeyCallback.setKey(null);
            LOG.log(Level.WARNING, "No support to read Principals in SecretKeyCallback.");
        }
    }

    protected KeyStore getTrustStore() {
        return null;
    }

    protected KeyStore[] getKeyStores() {
        return null;
    }

    protected SecretKey getPasswordSecretKeyForAlias(String alias) throws GeneralSecurityException {
        return null;
    }

    protected abstract boolean isSupportedCallback(Callback var1);

    protected abstract void handleSupportedCallbacks(Callback[] var1) throws IOException, UnsupportedCallbackException;

    private String getPassword(PasswordValidationCallback pwdCallback) {
        char[] password = pwdCallback.getPassword();
        if (password == null) {
            return null;
        }
        return new String(password);
    }

    private byte[] toDerOctetString(byte[] value) throws IOException {
        ByteArrayOutputStream subjectOutputStream = new ByteArrayOutputStream();
        subjectOutputStream.write(4);
        subjectOutputStream.write(this.length2Bytes(value.length));
        subjectOutputStream.write(value);
        return subjectOutputStream.toByteArray();
    }

    private byte[] length2Bytes(int length) {
        if (length <= 127) {
            return new byte[]{(byte)length};
        }
        int byteCount = 1;
        int lengthValue = length;
        while ((lengthValue >>>= 8) != 0) {
            ++byteCount;
        }
        byte[] lengthBytes = new byte[byteCount + 1];
        lengthBytes[0] = (byte)(byteCount | 0x80);
        int pos = 1;
        for (int i = (byteCount - 1) * 8; i >= 0; i -= 8) {
            lengthBytes[pos] = (byte)(length >> i);
            ++pos;
        }
        return lengthBytes;
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(KeyStore[] keyStores, MessageDigest messageDigest, byte[] digest) {
        PrivateKey privateKey = null;
        Certificate[] certificates = null;
        try {
            for (int i = 0; i < keyStores.length && privateKey == null; ++i) {
                Enumeration<String> aliases = keyStores[i].aliases();
                while (aliases.hasMoreElements() && privateKey == null) {
                    String nextAlias = aliases.nextElement();
                    privateKey = null;
                    certificates = null;
                    PrivateKey key = this.getPrivateKeyForAlias(nextAlias, i);
                    if (key == null) continue;
                    certificates = keyStores[i].getCertificateChain(nextAlias);
                    messageDigest.reset();
                    byte[] cDigest = messageDigest.digest(certificates[0].getEncoded());
                    if (!Arrays.equals(digest, cDigest)) continue;
                    privateKey = key;
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Exception in getPrivateKeyEntry for Digest", e);
        }
        return new KeyStore.PrivateKeyEntry(privateKey, certificates);
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }
}

