/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.factory;

import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.ServletContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.epicyro.config.factory.RegistrationContextImpl;
import org.glassfish.epicyro.config.factory.file.AuthConfigProviderEntry;
import org.glassfish.epicyro.config.factory.file.RegStoreFileParser;
import org.glassfish.epicyro.config.factory.singlemodule.DefaultAuthConfigProvider;
import org.glassfish.epicyro.config.helper.OperationLock;

public abstract class BaseAuthConfigFactory
extends AuthConfigFactory {
    private static final Logger logger = Logger.getLogger("enterprise.system.jaspic.security", "com.sun.logging.enterprise.system.jaspic.security.LogStrings");
    private static final String CONTEXT_REGISTRATION_ID = "org.glassfish.security.message.registrationId";
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private static final OperationLock operationLock = new OperationLock(readWriteLock);
    private static Map<String, AuthConfigProvider> idToProviderMap;
    private static Map<String, AuthConfigFactory.RegistrationContext> idToRegistrationContextMap;
    private static Map<String, List<RegistrationListener>> idToRegistrationListenersMap;
    private static Map<AuthConfigProvider, List<String>> providerToIdsMap;
    protected static final String CONF_FILE_NAME = "auth.conf";

    @Override
    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        if (listener == null) {
            return this.doReadLocked(() -> this.getConfigProviderUnderLock(layer, appContext, null));
        }
        return this.doWriteLocked(() -> this.getConfigProviderUnderLock(layer, appContext, listener));
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        BaseAuthConfigFactory.tryCheckPermission(providerRegistrationSecurityPermission);
        return this._register(BaseAuthConfigFactory._constructProvider(className, properties, null), properties, layer, appContext, description, true);
    }

    @Override
    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        BaseAuthConfigFactory.tryCheckPermission(providerRegistrationSecurityPermission);
        return this._register(provider, null, layer, appContext, description, false);
    }

    @Override
    public boolean removeRegistration(String registrationID) {
        BaseAuthConfigFactory.tryCheckPermission(AuthConfigFactory.providerRegistrationSecurityPermission);
        return this._unRegister(registrationID);
    }

    @Override
    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        BaseAuthConfigFactory.tryCheckPermission(providerRegistrationSecurityPermission);
        ArrayList<String> removedListenerIds = new ArrayList<String>();
        String registrationId = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        this.doWriteLocked(() -> {
            for (Map.Entry<String, List<RegistrationListener>> entry : idToRegistrationListenersMap.entrySet()) {
                List<RegistrationListener> listeners;
                String targetID = entry.getKey();
                if (!BaseAuthConfigFactory.regIdImplies(registrationId, targetID) || (listeners = entry.getValue()) == null || !listeners.remove(listener)) continue;
                removedListenerIds.add(targetID);
            }
        });
        return this.toArray(removedListenerIds);
    }

    @Override
    public String[] getRegistrationIDs(AuthConfigProvider configProvider) {
        return this.doReadLocked(() -> {
            HashSet<String> registrationIDs = null;
            if (configProvider != null) {
                registrationIDs = (HashSet<String>)((Object)providerToIdsMap.get(configProvider));
            } else {
                Collection<List<String>> collList = providerToIdsMap.values();
                if (collList != null) {
                    registrationIDs = new HashSet<String>();
                    for (List<String> listIds : collList) {
                        if (listIds == null) continue;
                        registrationIDs.addAll(listIds);
                    }
                }
            }
            return registrationIDs != null ? this.toArray(registrationIDs) : new String[]{};
        });
    }

    @Override
    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        return this.doReadLocked(() -> idToRegistrationContextMap.get(registrationID));
    }

    @Override
    public void refresh() {
        BaseAuthConfigFactory.tryCheckPermission(AuthConfigFactory.providerRegistrationSecurityPermission);
        Map preExistingListenersMap = this.doWriteLocked(() -> this.loadFactory());
        if (preExistingListenersMap != null) {
            BaseAuthConfigFactory.notifyListeners(preExistingListenersMap);
        }
    }

    public static String getAppContextID(ServletContext context) {
        return context.getVirtualServerName() + " " + context.getContextPath();
    }

    @Override
    public String registerServerAuthModule(final ServerAuthModule serverAuthModule, Object context) {
        if (!(context instanceof ServletContext)) {
            return null;
        }
        final ServletContext servletContext = (ServletContext)context;
        String registrationId = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return BaseAuthConfigFactory.this.registerConfigProvider(new DefaultAuthConfigProvider(serverAuthModule), "HttpServlet", BaseAuthConfigFactory.getAppContextID(servletContext), "Default single SAM authentication config provider");
            }
        });
        servletContext.setAttribute(CONTEXT_REGISTRATION_ID, registrationId);
        return registrationId;
    }

    @Override
    public void removeServerAuthModule(Object context) {
        if (!(context instanceof ServletContext)) {
            return;
        }
        ServletContext servletContext = (ServletContext)context;
        final String registrationId = (String)servletContext.getAttribute(CONTEXT_REGISTRATION_ID);
        if (!BaseAuthConfigFactory.isEmpty(registrationId)) {
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return BaseAuthConfigFactory.this.removeRegistration(registrationId);
                }
            });
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    protected abstract RegStoreFileParser getRegStore();

    private AuthConfigProvider getConfigProviderUnderLock(String layer, String appContext, RegistrationListener listener) {
        List listeners;
        String matchedID;
        AuthConfigProvider provider = null;
        String registrationID = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        boolean providerFound = false;
        if (idToProviderMap.containsKey(registrationID)) {
            provider = idToProviderMap.get(registrationID);
            providerFound = true;
        }
        if (!providerFound && idToProviderMap.containsKey(matchedID = BaseAuthConfigFactory.getRegistrationID(null, appContext))) {
            provider = idToProviderMap.get(matchedID);
            providerFound = true;
        }
        if (!providerFound && idToProviderMap.containsKey(matchedID = BaseAuthConfigFactory.getRegistrationID(layer, null))) {
            provider = idToProviderMap.get(matchedID);
            providerFound = true;
        }
        if (!providerFound && idToProviderMap.containsKey(matchedID = BaseAuthConfigFactory.getRegistrationID(null, null))) {
            provider = idToProviderMap.get(matchedID);
        }
        if (listener != null && !(listeners = idToRegistrationListenersMap.computeIfAbsent(registrationID, e -> new ArrayList())).contains(listener)) {
            listeners.add(listener);
        }
        return provider;
    }

    private static String getRegistrationID(String layer, String appContext) {
        if (layer != null) {
            return appContext != null ? "__3" + layer.length() + "_" + layer + appContext : "__2" + layer;
        }
        return appContext != null ? "__1" + appContext : "__0";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] decomposeRegistrationId(String registrationId) {
        String layer = null;
        String appContext = null;
        if (registrationId.equals("__0")) return new String[]{layer, appContext};
        if (registrationId.startsWith("__1")) {
            appContext = registrationId.length() == 3 ? "" : registrationId.substring(3);
            return new String[]{layer, appContext};
        } else if (registrationId.startsWith("__2")) {
            layer = registrationId.length() == 3 ? "" : registrationId.substring(3);
            return new String[]{layer, appContext};
        } else {
            if (!registrationId.startsWith("__3")) throw new IllegalArgumentException();
            int ind = registrationId.indexOf(95, 3);
            if (registrationId.length() <= 3 || ind <= 0) throw new IllegalArgumentException();
            int layerLength = BaseAuthConfigFactory.stringToInt(registrationId.substring(3, ind));
            layer = registrationId.substring(ind + 1, ind + 1 + layerLength);
            appContext = registrationId.substring(ind + 1 + layerLength);
        }
        return new String[]{layer, appContext};
    }

    private static AuthConfigProvider _constructProvider(String className, Map<String, String> properties, AuthConfigFactory factory) {
        AuthConfigProvider provider = null;
        if (className != null) {
            try {
                provider = (AuthConfigProvider)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).getConstructor(Map.class, AuthConfigFactory.class).newInstance(properties, factory);
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                logger.log(Level.WARNING, "jaspic.factory_unable_to_load_provider", new Object[]{className, t.toString(), cause == null ? "cannot determine" : cause.toString()});
            }
        }
        return provider;
    }

    private String _register(AuthConfigProvider provider, Map<String, String> properties, String layer, String appContext, String description, boolean persistent) {
        String registrationId = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        RegistrationContextImpl registrationContext = new RegistrationContextImpl(layer, appContext, description, persistent);
        Map listenerMap = this.doWriteLocked(() -> this.register(provider, properties, persistent, registrationId, registrationContext));
        BaseAuthConfigFactory.notifyListeners(listenerMap);
        return registrationId;
    }

    private Map<String, List<RegistrationListener>> register(AuthConfigProvider provider, Map<String, String> properties, boolean persistent, String registrationId, AuthConfigFactory.RegistrationContext registrationContext) {
        AuthConfigFactory.RegistrationContext previousRegistrationContext = idToRegistrationContextMap.get(registrationId);
        AuthConfigProvider previousProvider = idToProviderMap.get(registrationId);
        if (persistent) {
            this._storeRegistration(registrationContext, provider, properties);
        } else if (previousRegistrationContext != null && previousRegistrationContext.isPersistent()) {
            this._deleteStoredRegistration(previousRegistrationContext);
        }
        if (idToProviderMap.containsKey(registrationId)) {
            List<String> previousRegistrationsIds = providerToIdsMap.get(previousProvider);
            previousRegistrationsIds.remove(registrationId);
            if (previousRegistrationsIds.isEmpty()) {
                providerToIdsMap.remove(previousProvider);
            }
        }
        idToProviderMap.put(registrationId, provider);
        idToRegistrationContextMap.put(registrationId, registrationContext);
        List registrationIds = providerToIdsMap.computeIfAbsent(provider, e -> new ArrayList());
        if (!registrationIds.contains(registrationId)) {
            registrationIds.add(registrationId);
        }
        return BaseAuthConfigFactory.getEffectedListeners(registrationId);
    }

    private boolean _unRegister(String registrationId) {
        Map effectedListeners = this.doWriteLocked(() -> {
            AuthConfigFactory.RegistrationContext registrationContext = idToRegistrationContextMap.remove(registrationId);
            boolean hasProvider = idToProviderMap.containsKey(registrationId);
            AuthConfigProvider provider = idToProviderMap.remove(registrationId);
            List<String> registrationIds = providerToIdsMap.get(provider);
            if (registrationIds != null) {
                registrationIds.remove(registrationId);
            }
            if (registrationIds == null || registrationIds.isEmpty()) {
                providerToIdsMap.remove(provider);
            }
            if (!hasProvider) {
                return null;
            }
            Map<String, List<RegistrationListener>> listeners = BaseAuthConfigFactory.getEffectedListeners(registrationId);
            if (registrationContext != null && registrationContext.isPersistent()) {
                this._deleteStoredRegistration(registrationContext);
            }
            return listeners;
        });
        if (effectedListeners == null) {
            return false;
        }
        BaseAuthConfigFactory.notifyListeners(effectedListeners);
        return true;
    }

    private Map<String, List<RegistrationListener>> loadFactory() {
        Map<String, List<RegistrationListener>> oldId2RegisListenersMap = idToRegistrationListenersMap;
        this._loadFactory();
        return oldId2RegisListenersMap;
    }

    protected void _loadFactory() {
        block6: {
            try {
                BaseAuthConfigFactory.initializeMaps();
                List<AuthConfigProviderEntry> persistedEntries = this.getRegStore().getPersistedEntries();
                for (AuthConfigProviderEntry authConfigProviderEntry : persistedEntries) {
                    if (authConfigProviderEntry.isConstructorEntry()) {
                        BaseAuthConfigFactory._constructProvider(authConfigProviderEntry.getClassName(), authConfigProviderEntry.getProperties(), this);
                        continue;
                    }
                    boolean first = true;
                    AuthConfigProvider configProvider = null;
                    for (AuthConfigFactory.RegistrationContext context : authConfigProviderEntry.getRegistrationContexts()) {
                        if (first) {
                            configProvider = BaseAuthConfigFactory._constructProvider(authConfigProviderEntry.getClassName(), authConfigProviderEntry.getProperties(), null);
                        }
                        BaseAuthConfigFactory._loadRegistration(configProvider, context.getMessageLayer(), context.getAppContext(), context.getDescription());
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "jaspic.factory_auth_config_loader_failure", e);
            }
        }
    }

    private static void initializeMaps() {
        idToProviderMap = new HashMap<String, AuthConfigProvider>();
        idToRegistrationContextMap = new HashMap<String, AuthConfigFactory.RegistrationContext>();
        idToRegistrationListenersMap = new HashMap<String, List<RegistrationListener>>();
        providerToIdsMap = new HashMap<AuthConfigProvider, List<String>>();
    }

    private static String _loadRegistration(AuthConfigProvider provider, String layer, String appContext, String description) {
        RegistrationContextImpl registrationContext = new RegistrationContextImpl(layer, appContext, description, true);
        String registrationId = BaseAuthConfigFactory.getRegistrationID(layer, appContext);
        AuthConfigProvider previousProvider = idToProviderMap.get(registrationId);
        boolean wasRegistered = idToProviderMap.containsKey(registrationId);
        if (wasRegistered) {
            List<String> previousRegistrationIds = providerToIdsMap.get(previousProvider);
            previousRegistrationIds.remove(registrationId);
            if (previousRegistrationIds.isEmpty()) {
                providerToIdsMap.remove(previousProvider);
            }
        }
        idToProviderMap.put(registrationId, provider);
        idToRegistrationContextMap.put(registrationId, registrationContext);
        List<String> registrationIds = providerToIdsMap.get(provider);
        if (registrationIds == null) {
            registrationIds = new ArrayList<String>();
            providerToIdsMap.put(provider, registrationIds);
        }
        if (!registrationIds.contains(registrationId)) {
            registrationIds.add(registrationId);
        }
        return registrationId;
    }

    private void _storeRegistration(AuthConfigFactory.RegistrationContext registrationContext, AuthConfigProvider configProvider, Map<String, String> properties) {
        String className = null;
        if (configProvider != null) {
            className = configProvider.getClass().getName();
        }
        if (this.propertiesContainAnyNonStringValues(properties)) {
            throw new IllegalArgumentException("AuthConfigProvider cannot be registered - properties must all be of type String.");
        }
        if (registrationContext.isPersistent()) {
            this.getRegStore().store(className, registrationContext, properties);
        }
    }

    private boolean propertiesContainAnyNonStringValues(Map<String, String> properties) {
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (entry.getValue() instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private void _deleteStoredRegistration(AuthConfigFactory.RegistrationContext registrationContext) {
        if (registrationContext.isPersistent()) {
            this.getRegStore().delete(registrationContext);
        }
    }

    private static boolean regIdImplies(String reference, String target) {
        boolean rvalue = true;
        String[] refID = BaseAuthConfigFactory.decomposeRegistrationId(reference);
        String[] targetID = BaseAuthConfigFactory.decomposeRegistrationId(target);
        if (refID[0] != null && !refID[0].equals(targetID[0])) {
            rvalue = false;
        } else if (refID[1] != null && !refID[1].equals(targetID[1])) {
            rvalue = false;
        }
        return rvalue;
    }

    private static Map<String, List<RegistrationListener>> getEffectedListeners(String regisID) {
        HashMap<String, List<RegistrationListener>> effectedListeners = new HashMap<String, List<RegistrationListener>>();
        HashSet<String> listenerRegistrations = new HashSet<String>(idToRegistrationListenersMap.keySet());
        for (String listenerID : listenerRegistrations) {
            if (!BaseAuthConfigFactory.regIdImplies(regisID, listenerID)) continue;
            if (!effectedListeners.containsKey(listenerID)) {
                effectedListeners.put(listenerID, new ArrayList());
            }
            ((List)effectedListeners.get(listenerID)).addAll((Collection)idToRegistrationListenersMap.remove(listenerID));
        }
        return effectedListeners;
    }

    private static void tryCheckPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }

    protected <T> T doReadLocked(Supplier<T> supplier) {
        return operationLock.doReadLocked(supplier);
    }

    protected <T> T doWriteLocked(Supplier<T> supplier) {
        return operationLock.doWriteLocked(supplier);
    }

    protected void doWriteLocked(Runnable runnable) {
        operationLock.doWriteLocked(runnable);
    }

    private String[] toArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private static int stringToInt(String numberString) {
        try {
            return Integer.parseInt(numberString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    private static void notifyListeners(Map<String, List<RegistrationListener>> map) {
        Set<Map.Entry<String, List<RegistrationListener>>> entrySet = map.entrySet();
        for (Map.Entry<String, List<RegistrationListener>> entry : entrySet) {
            List<RegistrationListener> listeners = map.get(entry.getKey());
            if (listeners == null || listeners.size() <= 0) continue;
            String[] dIds = BaseAuthConfigFactory.decomposeRegistrationId(entry.getKey());
            for (RegistrationListener listener : listeners) {
                listener.notify(dIds[0], dIds[1]);
            }
        }
    }
}

