/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.node.PropertiesNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.DefaultResourcePrincipalNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.node.runtime.common.RuntimeNameValuePairNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.w3c.dom.Node;

public class CmpResourceNode
extends RuntimeDescriptorNode<ResourceReferenceDescriptor> {
    private ResourceReferenceDescriptor descriptor;

    public CmpResourceNode() {
        this.registerElementHandler(new XMLElement("default-resource-principal"), DefaultResourcePrincipalNode.class, "setResourcePrincipal");
        this.registerElementHandler(new XMLElement("property"), RuntimeNameValuePairNode.class, "addProperty");
        this.registerElementHandler(new XMLElement("schema-generator-properties"), PropertiesNode.class, "setSchemaGeneratorProperties");
    }

    @Override
    public ResourceReferenceDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ResourceReferenceDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        table.put("create-tables-at-deploy", "setCreateTablesAtDeploy");
        table.put("drop-tables-at-undeploy", "setDropTablesAtUndeploy");
        table.put("database-vendor-name", "setDatabaseVendorName");
        return table;
    }

    @Override
    public void postParsing() {
        EjbBundleDescriptorImpl bd = (EjbBundleDescriptorImpl)this.getParentNode().getDescriptor();
        if (bd == null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{this.descriptor});
            return;
        }
        bd.setCMPResourceReference(this.descriptor);
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, ResourceReferenceDescriptor descriptor) {
        Iterator<NameValuePairDescriptor> properties;
        Node cmp = super.writeDescriptor(parent, nodeName, descriptor);
        CmpResourceNode.appendTextChild(cmp, "jndi-name", descriptor.getJndiName());
        if (descriptor.getResourcePrincipal() != null) {
            DefaultResourcePrincipalNode drpNode = new DefaultResourcePrincipalNode();
            drpNode.writeDescriptor(cmp, "default-resource-principal", descriptor.getResourcePrincipal());
        }
        if ((properties = descriptor.getProperties()) != null) {
            RuntimeNameValuePairNode propNode = new RuntimeNameValuePairNode();
            while (properties.hasNext()) {
                NameValuePairDescriptor aProp = properties.next();
                propNode.writeDescriptor(cmp, "property", aProp);
            }
        }
        if (descriptor.isCreateTablesAtDeploy()) {
            CmpResourceNode.appendTextChild(cmp, "create-tables-at-deploy", "true");
        }
        if (descriptor.isDropTablesAtUndeploy()) {
            CmpResourceNode.appendTextChild(cmp, "drop-tables-at-undeploy", "true");
        }
        CmpResourceNode.appendTextChild(cmp, "database-vendor-name", descriptor.getDatabaseVendorName());
        Properties schemaGeneratorProps = descriptor.getSchemaGeneratorProperties();
        if (schemaGeneratorProps != null) {
            PropertiesNode node = new PropertiesNode();
            node.write(cmp, "schema-generator-properties", schemaGeneratorProps);
        }
        return cmp;
    }
}

