/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import java.util.Vector;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContainerTransactionNode
extends DeploymentDescriptorNode<ContainerTransaction> {
    private String trans_attribute;
    private String description;
    private final Vector<MethodDescriptor> methods = new Vector();

    public static Node writeContainerTransactions(Node parent, String nodeName, String methodName, Map<MethodDescriptor, ContainerTransaction> methodToTransactions) {
        MethodNode mn = new MethodNode();
        for (Map.Entry<MethodDescriptor, ContainerTransaction> entry : methodToTransactions.entrySet()) {
            MethodDescriptor md = entry.getKey();
            Element ctNode = ContainerTransactionNode.appendChild(parent, nodeName);
            ContainerTransaction ct = entry.getValue();
            ContainerTransactionNode.appendTextChild((Node)ctNode, "description", ct.getDescription());
            mn.writeDescriptor(ctNode, "method", md, methodName);
            ContainerTransactionNode.appendTextChild((Node)ctNode, "trans-attribute", ct.getTransactionAttribute());
        }
        return null;
    }

    public ContainerTransactionNode() {
        this.registerElementHandler(new XMLElement("method"), MethodNode.class);
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof MethodDescriptor) {
            this.methods.add((MethodDescriptor)newDescriptor);
        }
    }

    @Override
    public ContainerTransaction getDescriptor() {
        return null;
    }

    @Override
    public boolean endElement(XMLElement element) {
        boolean doneWithNode = super.endElement(element);
        if (doneWithNode) {
            ContainerTransaction ct = new ContainerTransaction(this.trans_attribute, this.description);
            for (MethodDescriptor method : this.methods) {
                EjbBundleDescriptorImpl bundle2 = (EjbBundleDescriptorImpl)this.getParentNode().getDescriptor();
                EjbDescriptor ejb = bundle2.getEjbByName(method.getEjbName(), true);
                ejb.getMethodContainerTransactions().put(method, ct);
            }
        }
        return doneWithNode;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("description".equals(element.getQName())) {
            this.description = value;
        }
        if ("trans-attribute".equals(element.getQName())) {
            this.trans_attribute = value;
        }
    }
}

