/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.deployment.common.Descriptor;

public final class ContainerTransaction
extends Descriptor {
    private static final long serialVersionUID = 1L;
    public static final String NOT_SUPPORTED = "NotSupported";
    public static final String SUPPORTS = "Supports";
    public static final String REQUIRED = "Required";
    public static final String REQUIRES_NEW = "RequiresNew";
    public static final String MANDATORY = "Mandatory";
    public static final String NEVER = "Never";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ContainerTransaction.class);
    private String transactionAttribute;

    public ContainerTransaction(ContainerTransaction other) {
        if (other != null) {
            this.transactionAttribute = other.transactionAttribute;
            this.setDescription(other.getDescription());
        }
    }

    public ContainerTransaction(String transactionAttribute, String description) {
        super("a Container Transaction", description);
        boolean isValidAttribute;
        boolean bl = isValidAttribute = NOT_SUPPORTED.equals(transactionAttribute) || SUPPORTS.equals(transactionAttribute) || REQUIRED.equals(transactionAttribute) || REQUIRES_NEW.equals(transactionAttribute) || MANDATORY.equals(transactionAttribute) || NEVER.equals(transactionAttribute);
        if (!isValidAttribute && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionunknowncontainertxtype", "Unknown ContainerTransaction type: {0}", transactionAttribute));
        }
        this.transactionAttribute = transactionAttribute;
    }

    public String getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public boolean equals(Object other) {
        ContainerTransaction otherContainerTransaction;
        return other != null && other instanceof ContainerTransaction && (otherContainerTransaction = (ContainerTransaction)other).getTransactionAttribute().equals(this.getTransactionAttribute());
    }

    public int hashCode() {
        return this.getTransactionAttribute().hashCode();
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Container Transaction: ").append(this.getTransactionAttribute()).append("@").append(this.getDescription());
    }
}

